/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS_POSIX;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.FS_Win32_Cygwin;
import org.eclipse.jgit.util.FileUtils;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FS {
    private static final Logger LOG = LoggerFactory.getLogger(FS.class);
    public static final FS DETECTED = FS.detect();
    private static volatile FSFactory factory;
    private volatile Holder<File> userHome;
    private volatile Holder<File> gitSystemConfig;

    public static FS detect() {
        return FS.detect(null);
    }

    public static FS detect(Boolean cygwinUsed) {
        if (factory == null) {
            factory = new FSFactory();
        }
        return factory.detect(cygwinUsed);
    }

    protected FS() {
    }

    protected FS(FS src) {
        this.userHome = src.userHome;
        this.gitSystemConfig = src.gitSystemConfig;
    }

    public abstract FS newInstance();

    public abstract boolean supportsExecute();

    public boolean supportsSymlinks() {
        return false;
    }

    public abstract boolean isCaseSensitive();

    public abstract boolean canExecute(File var1);

    public abstract boolean setExecute(File var1, boolean var2);

    public long lastModified(File f) throws IOException {
        return FileUtils.lastModified(f);
    }

    public void setLastModified(File f, long time) throws IOException {
        FileUtils.setLastModified(f, time);
    }

    public long length(File path) throws IOException {
        return FileUtils.getLength(path);
    }

    public void delete(File f) throws IOException {
        FileUtils.delete(f);
    }

    public File resolve(File dir, String name) {
        File abspn = new File(name);
        if (abspn.isAbsolute()) {
            return abspn;
        }
        return new File(dir, name);
    }

    public File userHome() {
        Holder<File> p = this.userHome;
        if (p == null) {
            this.userHome = p = new Holder<File>(this.userHomeImpl());
        }
        return (File)p.value;
    }

    public FS setUserHome(File path) {
        this.userHome = new Holder<File>(path);
        return this;
    }

    public abstract boolean retryFailedLockFileCommit();

    protected File userHomeImpl() {
        String home = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.home");
            }
        });
        if (home == null || home.length() == 0) {
            return null;
        }
        return new File(home).getAbsoluteFile();
    }

    protected static File searchPath(String path, String ... lookFor) {
        if (path == null) {
            return null;
        }
        for (String p : path.split(File.pathSeparator)) {
            for (String command : lookFor) {
                File e2 = new File(p, command);
                if (!e2.isFile()) continue;
                return e2.getAbsoluteFile();
            }
        }
        return null;
    }

    @Nullable
    protected static String readPipe(File dir, String[] command, String encoding) throws CommandFailedException {
        return FS.readPipe(dir, command, encoding, null);
    }

    @Nullable
    protected static String readPipe(File dir, String[] command, String encoding, Map<String, String> env) throws CommandFailedException {
        boolean debug2 = LOG.isDebugEnabled();
        try {
            if (debug2) {
                LOG.debug("readpipe " + Arrays.asList(command) + "," + dir);
            }
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(dir);
            if (env != null) {
                pb.environment().putAll(env);
            }
            Process p = pb.start();
            p.getOutputStream().close();
            GobblerThread gobbler = new GobblerThread(p, command, dir);
            gobbler.start();
            String r = null;
            try (BufferedReader lineRead = new BufferedReader(new InputStreamReader(p.getInputStream(), encoding));){
                r = lineRead.readLine();
                if (debug2) {
                    String l;
                    LOG.debug("readpipe may return '" + r + "'");
                    LOG.debug("remaining output:\n");
                    while ((l = lineRead.readLine()) != null) {
                        LOG.debug(l);
                    }
                }
            }
            while (true) {
                try {
                    int rc = p.waitFor();
                    gobbler.join();
                    if (rc == 0 && !gobbler.fail.get()) {
                        return r;
                    }
                    if (debug2) {
                        LOG.debug("readpipe rc=" + rc);
                    }
                    throw new CommandFailedException(rc, gobbler.errorMessage.get(), gobbler.exception.get());
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException e2) {
            LOG.error("Caught exception in FS.readPipe()", e2);
            if (debug2) {
                LOG.debug("readpipe returns null");
            }
            return null;
        }
    }

    protected abstract File discoverGitExe();

    protected File discoverGitSystemConfig() {
        String w;
        String v;
        File gitExe = this.discoverGitExe();
        if (gitExe == null) {
            return null;
        }
        try {
            v = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "--version"}, Charset.defaultCharset().name());
        }
        catch (CommandFailedException e2) {
            LOG.warn(e2.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(v) || v != null && v.startsWith("jgit")) {
            return null;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("GIT_EDITOR", "echo");
        try {
            w = FS.readPipe(gitExe.getParentFile(), new String[]{"git", "config", "--system", "--edit"}, Charset.defaultCharset().name(), env);
        }
        catch (CommandFailedException e3) {
            LOG.warn(e3.getMessage());
            return null;
        }
        if (StringUtils.isEmptyOrNull(w)) {
            return null;
        }
        return new File(w);
    }

    public File getGitSystemConfig() {
        if (this.gitSystemConfig == null) {
            this.gitSystemConfig = new Holder<File>(this.discoverGitSystemConfig());
        }
        return (File)this.gitSystemConfig.value;
    }

    public FS setGitSystemConfig(File configFile) {
        this.gitSystemConfig = new Holder<File>(configFile);
        return this;
    }

    protected static File resolveGrandparentFile(File grandchild) {
        File parent;
        if (grandchild != null && (parent = grandchild.getParentFile()) != null) {
            return parent.getParentFile();
        }
        return null;
    }

    public String readSymLink(File path) throws IOException {
        return FileUtils.readSymLink(path);
    }

    public boolean isSymLink(File path) throws IOException {
        return FileUtils.isSymlink(path);
    }

    public boolean exists(File path) {
        return FileUtils.exists(path);
    }

    public boolean isDirectory(File path) {
        return FileUtils.isDirectory(path);
    }

    public boolean isFile(File path) {
        return FileUtils.isFile(path);
    }

    public boolean isHidden(File path) throws IOException {
        return FileUtils.isHidden(path);
    }

    public void setHidden(File path, boolean hidden) throws IOException {
        FileUtils.setHidden(path, hidden);
    }

    public void createSymLink(File path, String target) throws IOException {
        FileUtils.createSymLink(path, target);
    }

    public String relativize(String base, String other) {
        return FileUtils.relativize(base, other);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args) throws JGitInternalException {
        return this.runHookIfPresent(repository, hookName, args, System.out, System.err, null);
    }

    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        return new ProcessResult(ProcessResult.Status.NOT_SUPPORTED);
    }

    protected ProcessResult internalRunHookIfPresent(Repository repository, String hookName, String[] args, PrintStream outRedirect, PrintStream errRedirect, String stdinArgs) throws JGitInternalException {
        File hookFile = this.findHook(repository, hookName);
        if (hookFile == null) {
            return new ProcessResult(ProcessResult.Status.NOT_PRESENT);
        }
        String hookPath = hookFile.getAbsolutePath();
        File runDirectory = repository.isBare() ? repository.getDirectory() : repository.getWorkTree();
        String cmd = this.relativize(runDirectory.getAbsolutePath(), hookPath);
        ProcessBuilder hookProcess = this.runInShell(cmd, args);
        hookProcess.directory(runDirectory);
        try {
            return new ProcessResult(this.runProcess(hookProcess, (OutputStream)outRedirect, (OutputStream)errRedirect, stdinArgs), ProcessResult.Status.OK);
        }
        catch (IOException e2) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfHook, hookName), e2);
        }
        catch (InterruptedException e3) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionHookExecutionInterrupted, hookName), e3);
        }
    }

    public File findHook(Repository repository, String hookName) {
        File gitDir = repository.getDirectory();
        if (gitDir == null) {
            return null;
        }
        File hookFile = new File(new File(gitDir, "hooks"), hookName);
        return hookFile.isFile() ? hookFile : null;
    }

    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws IOException, InterruptedException {
        ByteArrayInputStream in = stdinArgs == null ? null : new ByteArrayInputStream(stdinArgs.getBytes("UTF-8"));
        return this.runProcess(processBuilder, outRedirect, errRedirect, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int runProcess(ProcessBuilder processBuilder, OutputStream outRedirect, OutputStream errRedirect, InputStream inRedirect) throws IOException, InterruptedException {
        IOException ioException;
        block36: {
            int n;
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Process process = null;
            ioException = null;
            try {
                process = processBuilder.start();
                executor.execute(new StreamGobbler(process.getErrorStream(), errRedirect));
                executor.execute(new StreamGobbler(process.getInputStream(), outRedirect));
                OutputStream outputStream = process.getOutputStream();
                if (inRedirect != null) {
                    new StreamGobbler(inRedirect, outputStream).copy();
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                n = process.waitFor();
            }
            catch (IOException e2) {
                try {
                    ioException = e2;
                }
                catch (Throwable throwable) {
                    FS.shutdownAndAwaitTermination(executor);
                    if (process != null) {
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException e3) {
                            Thread.interrupted();
                        }
                        if (inRedirect != null) {
                            inRedirect.close();
                        }
                        try {
                            process.getErrorStream().close();
                        }
                        catch (IOException e4) {
                            ioException = ioException != null ? ioException : e4;
                        }
                        try {
                            process.getInputStream().close();
                        }
                        catch (IOException e5) {
                            ioException = ioException != null ? ioException : e5;
                        }
                        try {
                            process.getOutputStream().close();
                        }
                        catch (IOException e6) {
                            ioException = ioException != null ? ioException : e6;
                        }
                        process.destroy();
                    }
                    throw throwable;
                }
                FS.shutdownAndAwaitTermination(executor);
                if (process == null) break block36;
                try {
                    process.waitFor();
                }
                catch (InterruptedException e7) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e8) {
                    ioException = ioException != null ? ioException : e8;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e9) {
                    ioException = ioException != null ? ioException : e9;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e10) {
                    ioException = ioException != null ? ioException : e10;
                }
                process.destroy();
            }
            FS.shutdownAndAwaitTermination(executor);
            if (process != null) {
                try {
                    process.waitFor();
                }
                catch (InterruptedException e11) {
                    Thread.interrupted();
                }
                if (inRedirect != null) {
                    inRedirect.close();
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e12) {
                    ioException = ioException != null ? ioException : e12;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e13) {
                    ioException = ioException != null ? ioException : e13;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e14) {
                    ioException = ioException != null ? ioException : e14;
                }
                process.destroy();
            }
            return n;
        }
        throw ioException;
    }

    private static boolean shutdownAndAwaitTermination(ExecutorService pool) {
        boolean hasShutdown = true;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                    hasShutdown = false;
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
            hasShutdown = false;
        }
        return hasShutdown;
    }

    public abstract ProcessBuilder runInShell(String var1, String[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(ProcessBuilder pb, InputStream in) throws IOException, InterruptedException {
        TemporaryBuffer.LocalFile stdout = new TemporaryBuffer.LocalFile(null);
        TemporaryBuffer.Heap stderr = new TemporaryBuffer.Heap(1024, 0x100000);
        try {
            int rc = this.runProcess(pb, (OutputStream)stdout, (OutputStream)stderr, in);
            ExecutionResult executionResult = new ExecutionResult(stdout, stderr, rc);
            return executionResult;
        }
        finally {
            stdout.close();
            stderr.close();
        }
    }

    public Attributes getAttributes(File path) {
        boolean isFile;
        boolean isDirectory = this.isDirectory(path);
        boolean bl = isFile = !isDirectory && path.isFile();
        assert (path.exists() == isDirectory || isFile);
        boolean exists = isDirectory || isFile;
        boolean canExecute = exists && !isDirectory && this.canExecute(path);
        boolean isSymlink = false;
        long lastModified = exists ? path.lastModified() : 0L;
        long createTime = 0L;
        return new Attributes(this, path, exists, isDirectory, canExecute, isSymlink, isFile, createTime, lastModified, -1L);
    }

    public File normalize(File file) {
        return file;
    }

    public String normalize(String name) {
        return name;
    }

    public static class Attributes {
        private final boolean isDirectory;
        private final boolean isSymbolicLink;
        private final boolean isRegularFile;
        private final long creationTime;
        private final long lastModifiedTime;
        private final boolean isExecutable;
        private final File file;
        private final boolean exists;
        protected long length = -1L;
        final FS fs;

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isExecutable() {
            return this.isExecutable;
        }

        public boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public boolean isRegularFile() {
            return this.isRegularFile;
        }

        public long getCreationTime() {
            return this.creationTime;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        Attributes(FS fs, File file, boolean exists, boolean isDirectory, boolean isExecutable, boolean isSymbolicLink, boolean isRegularFile, long creationTime, long lastModifiedTime, long length) {
            this.fs = fs;
            this.file = file;
            this.exists = exists;
            this.isDirectory = isDirectory;
            this.isExecutable = isExecutable;
            this.isSymbolicLink = isSymbolicLink;
            this.isRegularFile = isRegularFile;
            this.creationTime = creationTime;
            this.lastModifiedTime = lastModifiedTime;
            this.length = length;
        }

        public Attributes(File path, FS fs) {
            this(fs, path, false, false, false, false, false, 0L, 0L, 0L);
        }

        public long getLength() {
            if (this.length == -1L) {
                this.length = this.file.length();
                return this.length;
            }
            return this.length;
        }

        public String getName() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        boolean exists() {
            return this.exists;
        }
    }

    public static class ExecutionResult {
        private TemporaryBuffer stdout;
        private TemporaryBuffer stderr;
        private int rc;

        public ExecutionResult(TemporaryBuffer stdout, TemporaryBuffer stderr, int rc) {
            this.stdout = stdout;
            this.stderr = stderr;
            this.rc = rc;
        }

        public TemporaryBuffer getStdout() {
            return this.stdout;
        }

        public TemporaryBuffer getStderr() {
            return this.stderr;
        }

        public int getRc() {
            return this.rc;
        }
    }

    public static class FSFactory {
        protected FSFactory() {
        }

        public FS detect(Boolean cygwinUsed) {
            if (SystemReader.getInstance().isWindows()) {
                if (cygwinUsed == null) {
                    cygwinUsed = FS_Win32_Cygwin.isCygwin();
                }
                if (cygwinUsed.booleanValue()) {
                    return new FS_Win32_Cygwin();
                }
                return new FS_Win32();
            }
            return new FS_POSIX();
        }
    }

    private static class GobblerThread
    extends Thread {
        private final Process p;
        private final String desc;
        private final String dir;
        final AtomicBoolean fail = new AtomicBoolean();
        final AtomicReference<String> errorMessage = new AtomicReference();
        final AtomicReference<Throwable> exception = new AtomicReference();

        GobblerThread(Process p, String[] command, File dir) {
            this.p = p;
            this.desc = Arrays.toString(command);
            this.dir = Objects.toString(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuilder err = new StringBuilder();
            try (InputStream is = this.p.getErrorStream();){
                int ch;
                while ((ch = is.read()) != -1) {
                    err.append((char)ch);
                }
            }
            catch (IOException e2) {
                if (this.p.exitValue() != 0) {
                    this.setError(e2, e2.getMessage());
                    this.fail.set(true);
                }
            }
            finally {
                if (err.length() > 0) {
                    this.setError(null, err.toString());
                    if (this.p.exitValue() != 0) {
                        this.fail.set(true);
                    }
                }
            }
        }

        private void setError(IOException e2, String message) {
            this.exception.set(e2);
            this.errorMessage.set(MessageFormat.format(JGitText.get().exceptionCaughtDuringExcecutionOfCommand, this.desc, this.dir, this.p.exitValue(), message));
        }
    }

    private static class Holder<V> {
        final V value;

        Holder(V value) {
            this.value = value;
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream in;
        private OutputStream out;

        public StreamGobbler(InputStream stream, OutputStream output) {
            this.in = stream;
            this.out = output;
        }

        @Override
        public void run() {
            try {
                this.copy();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void copy() throws IOException {
            int readBytes;
            boolean writeFailure = false;
            byte[] buffer = new byte[4096];
            while ((readBytes = this.in.read(buffer)) != -1) {
                if (writeFailure || this.out == null) continue;
                try {
                    this.out.write(buffer, 0, readBytes);
                    this.out.flush();
                }
                catch (IOException e2) {
                    writeFailure = true;
                }
            }
        }
    }
}

