/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Objects;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.AbstractFileCompareSheet;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;

public class FileCopyrightSheet
extends AbstractFileCompareSheet {
    static final int COPYRIGHT_COL_WIDTH = 60;

    public FileCopyrightSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    static void create(Workbook wb, String sheetName) {
        AbstractFileCompareSheet.create(wb, sheetName, 60);
    }

    @Override
    boolean valuesMatch(SpdxComparer comparer, SpdxFile fileA, int docIndexA, SpdxFile fileB, int docIndexB) throws SpdxCompareException {
        return Objects.equal(fileA.getCopyrightText(), fileB.getCopyrightText());
    }

    @Override
    String getFileValue(SpdxFile spdxFile) {
        String retval = spdxFile.getCopyrightText();
        if (retval == null) {
            retval = "NONE";
        }
        return retval;
    }
}

