/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.spdx.html.AnnotationContext;
import org.spdx.html.RelationshipContext;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxSnippet;
import org.spdx.rdfparser.model.pointer.StartEndPointer;

public class SnippetContext {
    private SpdxSnippet snippet;
    private Map<String, String> spdxIdToUrl;
    private Exception error = null;

    public SnippetContext(SpdxSnippet snippet, Map<String, String> spdxIdToUrl) {
        this.snippet = snippet;
        this.spdxIdToUrl = spdxIdToUrl;
    }

    public SnippetContext(InvalidSPDXAnalysisException e2) {
        this.error = e2;
    }

    public String spdxId() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getId();
    }

    public String byteRange() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        try {
            StartEndPointer byteRange = this.snippet.getByteRange();
            if (byteRange == null) {
                return null;
            }
            return byteRange.toString();
        }
        catch (InvalidSPDXAnalysisException e2) {
            return "Error getting SPDX snippet byte range: " + e2.getMessage();
        }
    }

    public String lineRange() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        try {
            StartEndPointer lineRange = this.snippet.getLineRange();
            if (lineRange == null) {
                return null;
            }
            return lineRange.toString();
        }
        catch (InvalidSPDXAnalysisException e2) {
            return "Error getting SPDX snippet line range: " + e2.getMessage();
        }
    }

    public String licenseConcluded() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getLicenseConcluded().toString();
    }

    public String licenseComments() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getLicenseComments();
    }

    public List<String> licenseInfoInSnippet() {
        ArrayList<String> retval = Lists.newArrayList();
        if (this.snippet == null && this.error != null) {
            retval.add("Error getting SPDX snippet information: " + this.error.getMessage());
        }
        if (this.snippet != null) {
            AnyLicenseInfo[] licenseInfos = this.snippet.getLicenseInfoFromFiles();
            for (int i = 0; i < licenseInfos.length; ++i) {
                retval.add(licenseInfos[i].toString());
            }
        }
        return retval;
    }

    public String copyrightText() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        return this.snippet.getCopyrightText();
    }

    public String comment() {
        if (this.snippet != null) {
            return this.snippet.getComment();
        }
        return null;
    }

    public List<RelationshipContext> snippetRelationships() {
        Object[] relationships;
        ArrayList<RelationshipContext> retval = Lists.newArrayList();
        if (this.snippet != null && (relationships = this.snippet.getRelationships()) != null) {
            Arrays.sort(relationships);
            for (Object relationship : relationships) {
                retval.add(new RelationshipContext((Relationship)relationship, this.spdxIdToUrl));
            }
        }
        return retval;
    }

    public List<AnnotationContext> snippetAnnotations() {
        Object[] annotations;
        ArrayList<AnnotationContext> retval = Lists.newArrayList();
        if (this.snippet != null && (annotations = this.snippet.getAnnotations()) != null) {
            Arrays.sort(annotations);
            for (Object annotation : annotations) {
                retval.add(new AnnotationContext((Annotation)annotation));
            }
        }
        return retval;
    }

    public String snippetFromFile() {
        if (this.snippet == null) {
            return "Error getting SPDX snippet information: " + (this.error != null ? this.error.getMessage() : "null");
        }
        try {
            SpdxFile fromFile = this.snippet.getSnippetFromFile();
            if (fromFile.getId() != null && fromFile.getName() != null) {
                return fromFile.getName() + " (" + fromFile.getId() + ")";
            }
            return "[UNKNOWN]";
        }
        catch (InvalidSPDXAnalysisException e2) {
            return "Error getting SPDX snippet from file: " + e2.getMessage();
        }
    }
}

