/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.licensexml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.licensexml.LicenseXmlException;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LicenseXmlHelper
implements SpdxRdfConstants {
    static final Logger logger = LoggerFactory.getLogger(LicenseXmlHelper.class);
    private static final String INDENT_STRING = "   ";
    private static final String BULLET_ALT_MATCH = ".{0,20}";
    private static final String BULLET_ALT_NAME = "bullet";
    static HashSet<String> LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS = new HashSet();
    static HashSet<String> HEADER_UNPROCESSED_TAGS;
    static HashSet<String> NOTES_UNPROCESSED_TAGS;
    static HashSet<String> FLOW_CONTROL_ELEMENTS;
    static String DOUBLE_QUOTES_REGEX;
    static String SINGLE_QUOTES_REGEX;

    private static void appendNodeText(Node node, boolean useTemplateFormat, StringBuilder sb, int indentCount, HashSet<String> unprocessedTags, boolean includeHtmlTags) throws LicenseXmlException {
        if (node.getNodeType() == 3) {
            if (includeHtmlTags) {
                sb.append(StringEscapeUtils.escapeHtml4(LicenseXmlHelper.fixUpText(node.getNodeValue())));
            } else {
                LicenseXmlHelper.appendNormalizedWhiteSpaceText(sb, node.getNodeValue());
            }
        } else if (node.getNodeType() == 1) {
            Element element = (Element)node;
            String tagName = element.getTagName();
            if ("list".equals(tagName)) {
                LicenseXmlHelper.appendListElements(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
            } else if ("alt".equals(tagName)) {
                if (!element.hasAttribute("name")) {
                    throw new LicenseXmlException("Missing name attribute for variable text");
                }
                String altName = element.getAttribute("name");
                if (!element.hasAttribute("match")) {
                    throw new LicenseXmlException("Missing match attribute for variable text");
                }
                String match = element.getAttribute("match");
                LicenseXmlHelper.appendAltText(element, altName, match, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
            } else if ("optional".equals(tagName)) {
                LicenseXmlHelper.appendOptionalText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
            } else if ("br".equals(tagName)) {
                if (includeHtmlTags) {
                    sb.append("<br>");
                }
                LicenseXmlHelper.addNewline(sb, indentCount);
                LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
            } else if ("p".equals(tagName)) {
                if (includeHtmlTags) {
                    LicenseXmlHelper.appendParagraphTag(sb, indentCount);
                } else if (sb.length() > 1) {
                    LicenseXmlHelper.addNewline(sb, indentCount);
                }
                LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
                if (includeHtmlTags) {
                    sb.append("</p>\n");
                }
            } else if ("titleText".equals(tagName)) {
                if (!LicenseXmlHelper.inALtBlock(element)) {
                    LicenseXmlHelper.appendOptionalText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
                } else {
                    LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
                }
            } else if (BULLET_ALT_NAME.equals(tagName)) {
                if (!LicenseXmlHelper.inALtBlock(element)) {
                    LicenseXmlHelper.appendAltText(element, BULLET_ALT_NAME, BULLET_ALT_MATCH, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
                } else {
                    LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
                }
            } else if (unprocessedTags.contains(tagName)) {
                LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
            } else {
                throw new LicenseXmlException("Unknown license element tag name: " + tagName);
            }
        }
    }

    private static boolean inALtBlock(Element element) {
        if ("alt".equals(element.getTagName())) {
            return true;
        }
        for (Node parent = element.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (parent.getNodeType() != 1 || !"alt".equals(((Element)parent).getTagName())) continue;
            return true;
        }
        return false;
    }

    private static void appendParagraphTag(StringBuilder sb, int indentCount) {
        sb.append("<p>");
    }

    private static void appendNormalizedWhiteSpaceText(StringBuilder sb, String text) {
        boolean endsInWhiteSpace = sb.length() == 0 || Character.isWhitespace(sb.charAt(sb.length() - 1));
        List<String> tokens = LicenseXmlHelper.tokenize(text);
        if (tokens.size() > 0) {
            if (!endsInWhiteSpace) {
                sb.append(' ');
            }
            sb.append(tokens.get(0));
            for (int i = 1; i < tokens.size(); ++i) {
                sb.append(' ');
                sb.append(tokens.get(i));
            }
        }
    }

    private static List<String> tokenize(String text) {
        ArrayList<String> result = new ArrayList<String>();
        int loc = 0;
        while (loc < text.length()) {
            while (loc < text.length() && Character.isWhitespace(text.charAt(loc))) {
                ++loc;
            }
            if (loc >= text.length()) continue;
            StringBuilder sb = new StringBuilder();
            while (loc < text.length() && !Character.isWhitespace(text.charAt(loc))) {
                sb.append(text.charAt(loc++));
            }
            result.add(sb.toString());
        }
        return result;
    }

    private static void appendElementChildrenText(Element element, boolean useTemplateFormat, StringBuilder sb, int indentCount, HashSet<String> unprocessedTags, boolean includeHtmlTags) throws LicenseXmlException {
        NodeList licenseChildNodes = element.getChildNodes();
        for (int i = 0; i < licenseChildNodes.getLength(); ++i) {
            LicenseXmlHelper.appendNodeText(licenseChildNodes.item(i), useTemplateFormat, sb, indentCount, unprocessedTags, includeHtmlTags);
        }
    }

    private static void addNewline(StringBuilder sb, int indentCount) {
        sb.append('\n');
        for (int i = 0; i < indentCount; ++i) {
            sb.append(INDENT_STRING);
        }
    }

    private static void appendOptionalText(Element element, boolean useTemplateFormat, StringBuilder sb, int indentCount, HashSet<String> unprocessedTags, boolean includeHtmlTags) throws LicenseXmlException {
        StringBuilder childSb = new StringBuilder();
        if (element.hasChildNodes()) {
            LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, childSb, indentCount, unprocessedTags, includeHtmlTags);
        } else {
            childSb.append(element.getTextContent());
        }
        if (useTemplateFormat) {
            sb.append("<<beginOptional>>");
            if (childSb.length() > 0 && childSb.charAt(0) == ' ') {
                sb.append(' ');
                childSb.delete(0, 1);
            } else if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.append(' ');
            }
            sb.append((CharSequence)childSb);
            sb.append("<<endOptional>>");
        } else if (includeHtmlTags) {
            if (LicenseXmlHelper.includesFlowControl(element)) {
                sb.append("<div class=\"");
            } else {
                sb.append("<var class=\"");
            }
            sb.append("optional-license-text");
            sb.append("\">");
            sb.append(childSb.toString());
            if (LicenseXmlHelper.includesFlowControl(element)) {
                sb.append("</div>");
            } else {
                sb.append("</var>");
            }
        } else {
            if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.append(' ');
            }
            sb.append((CharSequence)childSb);
        }
    }

    private static boolean includesFlowControl(Element element) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element eChild = (Element)child;
            if (FLOW_CONTROL_ELEMENTS.contains(eChild.getTagName())) {
                return true;
            }
            if (!LicenseXmlHelper.includesFlowControl(eChild)) continue;
            return true;
        }
        return false;
    }

    private static void appendAltText(Element element, String altName, String match, boolean useTemplateFormat, StringBuilder sb, int indentCount, HashSet<String> unprocessedTags, boolean includeHtmlTags) throws LicenseXmlException {
        StringBuilder originalSb = new StringBuilder();
        if (element.hasChildNodes()) {
            LicenseXmlHelper.appendElementChildrenText(element, useTemplateFormat, originalSb, indentCount, unprocessedTags, includeHtmlTags);
        } else {
            originalSb.append(element.getTextContent());
        }
        if (useTemplateFormat) {
            if (originalSb.length() > 0 && originalSb.charAt(0) == ' ') {
                sb.append(' ');
                originalSb.delete(0, 1);
            } else if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.append(' ');
            }
            sb.append("<<var;name=\"");
            sb.append(altName);
            sb.append("\";original=\"");
            sb.append((CharSequence)originalSb);
            sb.append("\";match=\"");
            sb.append(match);
            sb.append("\">>");
        } else if (includeHtmlTags) {
            if (LicenseXmlHelper.includesFlowControl(element)) {
                sb.append("\n<div class=\"");
            } else {
                sb.append("\n<var class=\"");
            }
            sb.append("replacable-license-text");
            sb.append("\">");
            sb.append((CharSequence)originalSb);
            if (LicenseXmlHelper.includesFlowControl(element)) {
                sb.append("</div>");
            } else {
                sb.append("</var>");
            }
        } else {
            if (sb.length() > 0 && !Character.isWhitespace(sb.charAt(sb.length() - 1))) {
                sb.append(' ');
            }
            sb.append((CharSequence)originalSb);
        }
    }

    private static void appendListElements(Element element, boolean useTemplateFormat, StringBuilder sb, int indentCount, HashSet<String> unprocessedTags, boolean includeHtmlTags) throws LicenseXmlException {
        if (!"list".equals(element.getTagName())) {
            throw new LicenseXmlException("Invalid list element tag - expected 'list', found '" + element.getTagName() + "'");
        }
        if (includeHtmlTags) {
            sb.append("\n<ul style=\"list-style:none\">");
        }
        NodeList listItemNodes = element.getChildNodes();
        for (int i = 0; i < listItemNodes.getLength(); ++i) {
            if (listItemNodes.item(i).getNodeType() == 1) {
                Element listItem = (Element)listItemNodes.item(i);
                if ("item".equals(listItem.getTagName())) {
                    if (includeHtmlTags) {
                        sb.append("\n<li>");
                        LicenseXmlHelper.appendNodeText(listItem, useTemplateFormat, sb, indentCount + 1, unprocessedTags, includeHtmlTags);
                        sb.append("</li>");
                        continue;
                    }
                    LicenseXmlHelper.addNewline(sb, indentCount + 1);
                    LicenseXmlHelper.appendNodeText(listItem, useTemplateFormat, sb, indentCount + 1, unprocessedTags, includeHtmlTags);
                    continue;
                }
                if ("list".equals(listItem.getTagName())) {
                    LicenseXmlHelper.appendListElements(listItem, useTemplateFormat, sb, indentCount + 1, unprocessedTags, includeHtmlTags);
                    continue;
                }
                throw new LicenseXmlException("Expected only list item tags ('item') or lists ('list') in a list, found " + listItem.getTagName());
            }
            if (listItemNodes.item(i).getNodeType() == 3) continue;
            throw new LicenseXmlException("Expected only element children for a list element");
        }
        if (includeHtmlTags) {
            sb.append("\n</ul>");
        }
    }

    public static String getLicenseTemplate(Element licenseElement) throws LicenseXmlException {
        if (!"text".equals(licenseElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'text'" + licenseElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(licenseElement, true, sb, 0, LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS, false);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    public static String getNoteText(Element licenseElement) throws LicenseXmlException {
        if (!"notes".equals(licenseElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'notes'" + licenseElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(licenseElement, false, sb, 0, NOTES_UNPROCESSED_TAGS, false);
        return sb.toString();
    }

    public static String getLicenseText(Element licenseElement) throws LicenseXmlException {
        if (!"text".equals(licenseElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'text'" + licenseElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(licenseElement, false, sb, 0, LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS, false);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    public static String dumpLicenseDom(Element licenseElement) {
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNode(licenseElement, sb, 0);
        return sb.toString();
    }

    private static void appendNode(Node node, StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(INDENT_STRING);
        }
        sb.append("Node Type: ");
        sb.append(node.getNodeType());
        sb.append(", Node Name: ");
        sb.append(node.getNodeName());
        sb.append(", Node Value: '");
        sb.append(node.getNodeValue());
        sb.append('\'');
        sb.append(", Node Text: '");
        sb.append(node.getTextContent());
        sb.append("'\n");
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                LicenseXmlHelper.appendNode(children.item(i), sb, indent + 1);
            }
        }
    }

    public static Object getHeaderText(Element headerElement) throws LicenseXmlException {
        if (!"standardLicenseHeader".equals(headerElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'standardLicenseHeader'" + headerElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(headerElement, false, sb, 0, HEADER_UNPROCESSED_TAGS, false);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    public static Object getHeaderTemplate(Element headerElement) throws LicenseXmlException {
        if (!"standardLicenseHeader".equals(headerElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'standardLicenseHeader'" + headerElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(headerElement, true, sb, 0, HEADER_UNPROCESSED_TAGS, false);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    public static Object getHeaderTextHtml(Element headerElement) throws LicenseXmlException {
        if (!"standardLicenseHeader".equals(headerElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'standardLicenseHeader'" + headerElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(headerElement, false, sb, 0, HEADER_UNPROCESSED_TAGS, true);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    private static String fixUpText(String string) {
        return string.replaceAll(DOUBLE_QUOTES_REGEX, "\"").replaceAll(SINGLE_QUOTES_REGEX, "'");
    }

    public static String getLicenseTextHtml(Element licenseElement) throws LicenseXmlException {
        if (!"text".equals(licenseElement.getTagName())) {
            throw new LicenseXmlException("Invalid element tag name - expected 'text'" + licenseElement.getTagName() + "'");
        }
        StringBuilder sb = new StringBuilder();
        LicenseXmlHelper.appendNodeText(licenseElement, false, sb, 0, LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS, true);
        return LicenseXmlHelper.fixUpText(sb.toString());
    }

    static {
        LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS.add("copyrightText");
        LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS.add("item");
        LICENSE_AND_EXCEPTION_UNPROCESSED_TAGS.add("text");
        HEADER_UNPROCESSED_TAGS = new HashSet();
        HEADER_UNPROCESSED_TAGS.add("copyrightText");
        HEADER_UNPROCESSED_TAGS.add("titleText");
        HEADER_UNPROCESSED_TAGS.add("item");
        HEADER_UNPROCESSED_TAGS.add(BULLET_ALT_NAME);
        HEADER_UNPROCESSED_TAGS.add("standardLicenseHeader");
        NOTES_UNPROCESSED_TAGS = new HashSet();
        NOTES_UNPROCESSED_TAGS.add("notes");
        FLOW_CONTROL_ELEMENTS = new HashSet();
        FLOW_CONTROL_ELEMENTS.add("list");
        FLOW_CONTROL_ELEMENTS.add("p");
        DOUBLE_QUOTES_REGEX = "(\\u201C|\\u201D)";
        SINGLE_QUOTES_REGEX = "(\\u2018|\\u2019)";
    }
}

