/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.referencetype.ReferenceType;

public class ExternalRef
extends RdfModelObject
implements Comparable<ExternalRef> {
    static final Logger logger = LoggerFactory.getLogger(ExternalRef.class);
    private ReferenceCategory referenceCategory;
    private ReferenceType referenceType;
    private String referenceLocator;
    private String comment;

    public ExternalRef(ReferenceCategory referenceCategory, ReferenceType referenceType, String referenceLocator, String comment) {
        this.referenceCategory = referenceCategory;
        this.referenceType = referenceType;
        this.referenceLocator = referenceLocator;
        this.comment = comment;
    }

    public ExternalRef(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        if (this.referenceCategory == null) {
            retval.add("Missing or invalid reference category");
        }
        if (this.referenceType == null) {
            retval.add("Missing or invalid reference type");
        } else {
            retval.addAll(this.referenceType.verify());
        }
        if (this.referenceLocator == null || this.referenceLocator.isEmpty()) {
            retval.add("Missing or invalid reference locator");
        } else if (this.referenceLocator.contains(" ")) {
            retval.add("Reference locator contains spaces");
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof ExternalRef)) {
            return false;
        }
        ExternalRef erCompare = (ExternalRef)compare;
        try {
            return Objects.equal((Object)this.getReferenceCategory(), (Object)erCompare.getReferenceCategory()) && Objects.equal(this.getReferenceLocator(), erCompare.getReferenceLocator()) && this.equivalentConsideringNull(this.getReferenceType(), erCompare.getReferenceType());
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting equiv. data", e2);
            return false;
        }
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        String categoryUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "referenceCategory");
        if (categoryUri != null && !categoryUri.isEmpty()) {
            if (!categoryUri.startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid reference category: " + categoryUri);
            }
            String categoryS = categoryUri.substring("http://spdx.org/rdf/terms#".length());
            try {
                this.referenceCategory = ReferenceCategory.valueOf(categoryS);
            }
            catch (Exception ex) {
                logger.error("Invalid reference category in the model - " + categoryS);
                throw new InvalidSPDXAnalysisException("Invalid referenceCategory: " + categoryS);
            }
        }
        this.referenceType = this.findReferenceTypePropertyValue("http://spdx.org/rdf/terms#", "referenceType");
        this.referenceLocator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "referenceLocator");
        this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#ExternalRef");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        if (this.referenceCategory == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "referenceCategory");
        } else {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "referenceCategory", "http://spdx.org/rdf/terms#" + this.referenceCategory.toString());
        }
        this.setPropertyValue("http://spdx.org/rdf/terms#", "referenceType", this.referenceType);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "referenceLocator", this.referenceLocator);
        this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", this.comment);
    }

    @Override
    public int compareTo(ExternalRef o) {
        ReferenceType myReferenceType = null;
        int retval = 0;
        try {
            myReferenceType = this.getReferenceType();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Invalid reference type during compare", e2);
        }
        ReferenceType compRefType = null;
        try {
            compRefType = o.getReferenceType();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.error("Invalid reference type during compare", e3);
        }
        if (myReferenceType == null) {
            if (compRefType != null) {
                retval = 1;
            }
        } else {
            retval = compRefType == null ? -1 : myReferenceType.compareTo(compRefType);
        }
        if (retval == 0) {
            String myReferenceLocator = this.getReferenceLocator();
            if (myReferenceLocator == null) {
                if (o.getReferenceLocator() != null) {
                    retval = 1;
                }
            } else {
                retval = o.getReferenceLocator() == null ? -1 : myReferenceLocator.compareTo(o.getReferenceLocator());
            }
        }
        if (retval == 0) {
            if (this.getReferenceCategory() == null) {
                if (o.getReferenceCategory() != null) {
                    return 1;
                }
                return 0;
            }
            retval = this.referenceCategory.toString().compareTo(o.getReferenceCategory().toString());
        }
        if (retval == 0) {
            String myComment = this.getComment();
            if (myComment == null) {
                if (o.getComment() != null) {
                    retval = 1;
                }
            } else {
                retval = o.getComment() == null ? -1 : myComment.compareTo(o.getComment());
            }
        }
        return retval;
    }

    public ExternalRef clone() {
        return new ExternalRef(this.referenceCategory, this.referenceType, this.referenceLocator, this.comment);
    }

    public String getComment() {
        if (this.resource != null && this.refreshOnGet) {
            this.comment = this.findSinglePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        }
        return this.comment;
    }

    public void setComment(String comment) {
        if (this.comment == null) {
            this.removePropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment");
        } else {
            this.setPropertyValue("http://www.w3.org/2000/01/rdf-schema#", "comment", comment);
        }
        this.comment = comment;
    }

    public ReferenceCategory getReferenceCategory() {
        if (this.resource != null && this.refreshOnGet) {
            String categoryUri = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "referenceCategory");
            if (categoryUri != null && !categoryUri.isEmpty()) {
                if (!categoryUri.startsWith("http://spdx.org/rdf/terms#")) {
                    logger.error("Invalid reference category in the model - " + categoryUri);
                } else {
                    String categoryS = categoryUri.substring("http://spdx.org/rdf/terms#".length());
                    try {
                        this.referenceCategory = ReferenceCategory.valueOf(categoryS);
                    }
                    catch (Exception ex) {
                        logger.error("Invalid reference category in the model - " + categoryS);
                        this.referenceCategory = null;
                    }
                }
            } else {
                this.referenceCategory = null;
            }
        }
        return this.referenceCategory;
    }

    public void setReferenceCategory(ReferenceCategory referenceCategory) throws InvalidSPDXAnalysisException {
        this.referenceCategory = referenceCategory;
        if (referenceCategory == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "referenceCategory");
        } else {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "referenceCategory", "http://spdx.org/rdf/terms#" + this.referenceCategory.toString());
        }
    }

    public ReferenceType getReferenceType() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            this.referenceType = this.findReferenceTypePropertyValue("http://spdx.org/rdf/terms#", "referenceType");
        }
        return this.referenceType;
    }

    public void setReferenceType(ReferenceType referenceType) throws InvalidSPDXAnalysisException {
        this.referenceType = referenceType;
        if (referenceType == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "referenceType");
        } else {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "referenceType", referenceType);
        }
    }

    public String getReferenceLocator() {
        if (this.resource != null && this.refreshOnGet) {
            this.referenceLocator = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "referenceLocator");
        }
        return this.referenceLocator;
    }

    public void setReferenceLocator(String referenceLocator) {
        this.referenceLocator = referenceLocator;
        if (referenceLocator == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "referenceLocator");
        } else {
            this.setPropertyValue("http://spdx.org/rdf/terms#", "referenceLocator", referenceLocator);
        }
    }

    @Override
    public Resource findDuplicateResource(IModelContainer modelContainer, String uri) throws InvalidSPDXAnalysisException {
        if (this.referenceCategory == null || this.referenceType == null || this.referenceLocator == null) {
            return null;
        }
        Node referenceLocatorProperty = modelContainer.getModel().getProperty("http://spdx.org/rdf/terms#", "referenceLocator").asNode();
        Triple referenceLocatorMatch = Triple.createMatch(null, referenceLocatorProperty, NodeFactory.createLiteral(this.referenceLocator));
        ExtendedIterator<Triple> referenceMatchIter = modelContainer.getModel().getGraph().find(referenceLocatorMatch);
        while (referenceMatchIter.hasNext()) {
            String categoryUri;
            Triple categoryMatchTriple;
            Triple typeMatchTriple;
            Triple referenceMatchTriple = (Triple)referenceMatchIter.next();
            Node referenceNode = referenceMatchTriple.getSubject();
            Node typeProperty = modelContainer.getModel().getProperty("http://spdx.org/rdf/terms#", "referenceType").asNode();
            Node categoryProperty = modelContainer.getModel().getProperty("http://spdx.org/rdf/terms#", "referenceCategory").asNode();
            Triple typeMatch = Triple.createMatch(referenceNode, typeProperty, null);
            Triple categoryMatch = Triple.createMatch(referenceNode, categoryProperty, null);
            ExtendedIterator<Triple> typeMatchIterator = modelContainer.getModel().getGraph().find(typeMatch);
            ExtendedIterator<Triple> categoryMatchIterator = modelContainer.getModel().getGraph().find(categoryMatch);
            if (!typeMatchIterator.hasNext() || (typeMatchTriple = (Triple)typeMatchIterator.next()).getObject() == null || !typeMatchTriple.getObject().isURI() || !this.referenceType.getReferenceTypeUri().toString().equals(typeMatchTriple.getObject().getURI()) || !categoryMatchIterator.hasNext() || (categoryMatchTriple = (Triple)categoryMatchIterator.next()).getObject() == null || !categoryMatchTriple.getObject().isURI() || (categoryUri = categoryMatchTriple.getObject().getURI()) == null || categoryUri.length() <= "http://spdx.org/rdf/terms#".length() || !this.referenceCategory.toString().equals(categoryUri.substring("http://spdx.org/rdf/terms#".length()))) continue;
            return RdfParserHelper.convertToResource(modelContainer.getModel(), referenceNode);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.referenceCategory == null) {
            sb.append("[NONE] ");
        } else {
            sb.append(this.referenceCategory.getTag());
            sb.append(' ');
        }
        if (this.referenceType == null) {
            sb.append("[NONE] ");
        } else {
            sb.append(this.referenceType.toString());
            sb.append(' ');
        }
        if (this.referenceLocator == null) {
            sb.append("[NONE]");
        } else {
            sb.append(this.referenceLocator);
        }
        if (this.comment != null) {
            sb.append(" (");
            sb.append(this.comment);
            sb.append(")");
        }
        return sb.toString();
    }

    public static enum ReferenceCategory {
        referenceCategory_packageManager,
        referenceCategory_security,
        referenceCategory_other;


        public String getTag() {
            switch (this) {
                case referenceCategory_packageManager: {
                    return "PACKAGE-MANAGER";
                }
                case referenceCategory_security: {
                    return "SECURITY";
                }
                case referenceCategory_other: {
                    return "OTHER";
                }
            }
            return "OTHER";
        }

        public static ReferenceCategory fromTag(String tag) {
            String uTag = tag.toUpperCase();
            if ("PACKAGE-MANAGER".equals(uTag)) {
                return referenceCategory_packageManager;
            }
            if ("SECURITY".equals(uTag)) {
                return referenceCategory_security;
            }
            if ("OTHER".equals(uTag)) {
                return referenceCategory_other;
            }
            return null;
        }
    }
}

