/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.ListedLicenses;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.ExternalDocumentRef;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;

public class SpdxDocument
extends SpdxElement {
    private SpdxDocumentContainer documentContainer;
    SPDXCreatorInformation creationInfo;
    AnyLicenseInfo dataLicense;
    String specVersion;
    @Deprecated
    SPDXReview[] reviewers;

    public SpdxDocument(SpdxDocumentContainer documentContainer, Node node) throws InvalidSPDXAnalysisException {
        super(documentContainer, node);
        this.documentContainer = documentContainer;
        this.getMyPropertiesFromModel();
        if (this.getCreationInfo() == null) {
            String licenseListVersion = ListedLicenses.getListedLicenses().getLicenseListVersion();
            String creationDate = DateFormatUtils.format(Calendar.getInstance(), "yyyy-MM-dd'T'HH:mm:ss'Z'");
            SPDXCreatorInformation creationInfo = new SPDXCreatorInformation(new String[0], creationDate, null, licenseListVersion);
            this.setCreationInfo(creationInfo);
        } else if (StringUtils.isBlank(this.getCreationInfo().getLicenseListVersion())) {
            this.getCreationInfo().setLicenseListVersion(ListedLicenses.getListedLicenses().getLicenseListVersion());
        }
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.getMyPropertiesFromModel();
    }

    void getMyPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.dataLicense = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "dataLicense");
        this.creationInfo = this.findCreationInfoPropertyValue("http://spdx.org/rdf/terms#", "creationInfo");
        this.specVersion = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "specVersion");
        this.reviewers = this.findReviewPropertyValues("http://spdx.org/rdf/terms#", "reviewed");
    }

    public SpdxItem[] getDocumentDescribes() throws InvalidSPDXAnalysisException {
        Relationship[] allRelationships = this.getRelationships();
        int count = 0;
        for (int i = 0; i < allRelationships.length; ++i) {
            if (allRelationships[i].getRelationshipType() != Relationship.RelationshipType.DESCRIBES || !(allRelationships[i].getRelatedSpdxElement() instanceof SpdxItem)) continue;
            ++count;
        }
        SpdxItem[] refresh = new SpdxItem[count];
        int refreshIndex = 0;
        for (int i = 0; i < allRelationships.length; ++i) {
            if (allRelationships[i].getRelationshipType() != Relationship.RelationshipType.DESCRIBES || !(allRelationships[i].getRelatedSpdxElement() instanceof SpdxItem)) continue;
            refresh[refreshIndex++] = (SpdxItem)allRelationships[i].getRelatedSpdxElement();
        }
        return refresh;
    }

    SpdxItem[] getPackagesFromItems(SpdxItem[] items) {
        int count = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof SpdxPackage)) continue;
            ++count;
        }
        SpdxItem[] retval = new SpdxItem[count];
        count = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof SpdxPackage)) continue;
            retval[count++] = items[i];
        }
        return retval;
    }

    SpdxItem[] getFilesFromItems(SpdxItem[] items) {
        int count = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof SpdxFile)) continue;
            ++count;
        }
        SpdxItem[] retval = new SpdxItem[count];
        count = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!(items[i] instanceof SpdxFile)) continue;
            retval[count++] = items[i];
        }
        return retval;
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        if (this.node != null && this.node.isURI()) {
            return this.node.getURI();
        }
        return modelContainer.getDocumentNamespace();
    }

    public String getDocumentUri() throws InvalidSPDXAnalysisException {
        return this.getUri(this.documentContainer);
    }

    public String getDocumentNamespace() throws InvalidSPDXAnalysisException {
        String[] parts = this.getDocumentUri().split("#");
        return parts[0];
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#SpdxDocument");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://spdx.org/rdf/terms#", "dataLicense", this.dataLicense);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "creationInfo", this.creationInfo);
        this.setPropertyValues("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo", this.documentContainer.getExtractedLicenseInfos());
        this.setPropertyValue("http://spdx.org/rdf/terms#", "specVersion", this.specVersion);
        this.setPropertyValues("http://spdx.org/rdf/terms#", "reviewed", this.reviewers);
    }

    public SpdxDocumentContainer getDocumentContainer() {
        return this.documentContainer;
    }

    public SPDXCreatorInformation getCreationInfo() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.creationInfo = this.findCreationInfoPropertyValue("http://spdx.org/rdf/terms#", "creationInfo");
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.error("Error getting creationInfo from model");
                throw e2;
            }
        }
        return this.creationInfo;
    }

    public void setCreationInfo(SPDXCreatorInformation creationInfo) {
        this.creationInfo = creationInfo;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "creationInfo", this.creationInfo);
    }

    public AnyLicenseInfo getDataLicense() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            try {
                AnyLicenseInfo refresh = this.findAnyLicenseInfoPropertyValue("http://spdx.org/rdf/terms#", "dataLicense");
                if (refresh == null || !refresh.equals(this.dataLicense)) {
                    this.dataLicense = refresh;
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.error("Error getting data license from model");
                throw e2;
            }
        }
        return this.dataLicense;
    }

    public void setDataLicense(AnyLicenseInfo dataLicense) throws InvalidSPDXAnalysisException {
        this.dataLicense = dataLicense;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "dataLicense", this.dataLicense);
    }

    public ExternalDocumentRef[] getExternalDocumentRefs() throws InvalidSPDXAnalysisException {
        return this.documentContainer.getExternalDocumentRefs();
    }

    public void setExternalDocumentRefs(ExternalDocumentRef[] externalDocumentRefs) throws InvalidSPDXAnalysisException {
        this.documentContainer.setExternalDocumentRefs(externalDocumentRefs);
    }

    public ExtractedLicenseInfo[] getExtractedLicenseInfos() throws InvalidSPDXAnalysisException {
        return this.documentContainer.getExtractedLicenseInfos();
    }

    public void setExtractedLicenseInfos(ExtractedLicenseInfo[] extractedLicenseInfos) throws InvalidSPDXAnalysisException {
        this.documentContainer.setExtractedLicenseInfos(extractedLicenseInfos);
    }

    public String getSpecVersion() {
        if (this.resource != null && this.refreshOnGet) {
            this.specVersion = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "specVersion");
        }
        return this.specVersion;
    }

    @Deprecated
    public SPDXReview[] getReviewers() throws InvalidSPDXAnalysisException {
        if (this.resource != null && this.refreshOnGet) {
            try {
                this.reviewers = this.findReviewPropertyValues("http://spdx.org/rdf/terms#", "reviewed");
            }
            catch (InvalidSPDXAnalysisException e2) {
                logger.error("Error getting reviews from model");
                throw e2;
            }
        }
        return this.reviewers;
    }

    @Deprecated
    public void setReviewers(SPDXReview[] reviewers) {
        this.reviewers = reviewers;
        this.setPropertyValues("http://spdx.org/rdf/terms#", "reviewed", reviewers);
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "specVersion", specVersion);
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        String docSpecVersion = "";
        if (this.specVersion == null || this.specVersion.isEmpty()) {
            retval.add("Missing required SPDX version");
            docSpecVersion = "UNKNOWN";
        } else {
            docSpecVersion = this.specVersion;
            String verify = this.documentContainer.verifySpdxVersion(docSpecVersion);
            if (verify != null) {
                retval.add(verify);
            }
        }
        try {
            SPDXCreatorInformation creator = this.getCreationInfo();
            if (creator == null) {
                retval.add("Missing required Creator");
            } else {
                List<String> creatorVerification = creator.verify();
                retval.addAll(creatorVerification);
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Invalid creator information: " + e2.getMessage());
        }
        try {
            SPDXReview[] reviews = this.getReviewers();
            if (reviews != null) {
                for (int i = 0; i < reviews.length; ++i) {
                    List<String> reviewerVerification = reviews[i].verify();
                    retval.addAll(reviewerVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Invalid reviewers: " + e3.getMessage());
        }
        try {
            ExtractedLicenseInfo[] extractedLicInfos = this.getExtractedLicenseInfos();
            if (extractedLicInfos != null) {
                for (int i = 0; i < extractedLicInfos.length; ++i) {
                    List<String> extractedLicInfoVerification = extractedLicInfos[i].verify();
                    retval.addAll(extractedLicInfoVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Invalid extracted licensing info: " + e4.getMessage());
        }
        if (!docSpecVersion.equals("SPDX-0.8") && !docSpecVersion.equals("SPDX-0.9")) {
            try {
                AnyLicenseInfo dataLicense = this.getDataLicense();
                if (dataLicense == null) {
                    retval.add("Missing required data license");
                } else if (!(dataLicense instanceof SpdxListedLicense)) {
                    retval.add("Invalid license type for data license - must be an SPDX Listed license");
                } else if (docSpecVersion.equals("SPDX-1.0")) {
                    if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("PDDL-1.0")) {
                        retval.add("Incorrect data license for SPDX version 1.0 document - found " + ((SpdxListedLicense)dataLicense).getLicenseId() + ", expected " + "PDDL-1.0");
                    }
                } else if (!((SpdxListedLicense)dataLicense).getLicenseId().equals("CC0-1.0")) {
                    retval.add("Incorrect data license for SPDX document - found " + ((SpdxListedLicense)dataLicense).getLicenseId() + ", expected " + "CC0-1.0");
                }
            }
            catch (InvalidSPDXAnalysisException e5) {
                retval.add("Invalid data license: " + e5.getMessage());
            }
        }
        try {
            ExternalDocumentRef[] externalRefs = this.getExternalDocumentRefs();
            for (int i = 0; i < externalRefs.length; ++i) {
                retval.addAll(externalRefs[i].verify());
            }
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Invalid external document references: " + e6.getMessage());
        }
        try {
            SpdxItem[] items = this.getDocumentDescribes();
            if (items.length == 0) {
                retval.add("Document must have at least one relationship of type DOCUMENT_DESCRIBES");
            }
        }
        catch (InvalidSPDXAnalysisException e7) {
            retval.add("Invalid document items: " + e7.getMessage());
        }
        try {
            List<SpdxElement> allElements = this.documentContainer.findAllElements();
            for (SpdxElement element : allElements) {
                if (element.getId().equals(this.getId())) continue;
                retval.addAll(element.verify());
            }
        }
        catch (InvalidSPDXAnalysisException e8) {
            retval.add("Invalid elements: " + e8.getMessage());
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        return this.equivalent(o, true);
    }

    @Override
    public boolean equivalent(IRdfModel o, boolean testRelationships) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpdxDocument)) {
            return false;
        }
        if (!super.equivalent(o, testRelationships)) {
            return false;
        }
        SpdxDocument comp = (SpdxDocument)o;
        try {
            return Objects.equal(this.creationInfo, comp.getCreationInfo()) && Objects.equal(this.dataLicense, comp.getDataLicense()) && this.arraysEquivalent(this.getExternalDocumentRefs(), comp.getExternalDocumentRefs(), testRelationships) && RdfModelHelper.arraysEqual(this.getExtractedLicenseInfos(), comp.getExtractedLicenseInfos()) && RdfModelHelper.arraysEqual(this.reviewers, comp.getReviewers()) && Objects.equal(this.specVersion, comp.getSpecVersion());
        }
        catch (InvalidSPDXAnalysisException ex) {
            logger.error("Error testing for equivalent", ex);
            return false;
        }
    }

    @Override
    protected String getNamePropertyName() {
        return "name";
    }

    @Deprecated
    public String getSpdxVersion() {
        return this.getSpecVersion();
    }

    @Deprecated
    public SPDXCreatorInformation getCreatorInfo() throws InvalidSPDXAnalysisException {
        return this.getCreationInfo();
    }

    @Deprecated
    public String getDocumentComment() {
        return this.getComment();
    }

    @Deprecated
    public SpdxPackage getSpdxPackage() throws InvalidSPDXAnalysisException {
        SpdxItem[] retval = this.getDocumentDescribes();
        if (retval.length != 1) {
            throw new InvalidSPDXAnalysisException("More than one SPDX package defined in the document.  Must use getSpdxItems - Likely this application has not been upgraded for SPDX 2.0");
        }
        return (SpdxPackage)retval[0];
    }

    public void addExtractedLicenseInfos(ExtractedLicenseInfo license) throws InvalidSPDXAnalysisException {
        this.documentContainer.addExtractedLicenseInfos(license);
    }
}

