/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.model.ExternalSpdxElement;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.rdfparser.model.SpdxSnippet;

public class SpdxElementFactory {
    private static Map<IModelContainer, Map<Node, SpdxElement>> createdElements = Maps.newHashMap();

    static synchronized void addToCreatedElements(IModelContainer modelContainer, Node node, SpdxElement element) {
        Map<Node, SpdxElement> containerNodes = createdElements.get(modelContainer);
        if (containerNodes == null) {
            containerNodes = Maps.newHashMap();
            createdElements.put(modelContainer, containerNodes);
        }
        containerNodes.put(node, element);
    }

    public static synchronized SpdxElement createElementFromModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        SpdxElement retval;
        Map<Node, SpdxElement> containerNodes = createdElements.get(modelContainer);
        if (containerNodes == null) {
            containerNodes = Maps.newHashMap();
            createdElements.put(modelContainer, containerNodes);
        }
        if ((retval = containerNodes.get(node)) != null) {
            return retval;
        }
        if (!node.isURI() && !node.isBlank()) {
            throw new InvalidSPDXAnalysisException("Can not create an SPDX Element from a literal node");
        }
        if (node.isURI() && !node.getURI().startsWith(modelContainer.getDocumentNamespace())) {
            String[] uriParts = node.getURI().split("#");
            if (uriParts.length != 2) {
                throw new InvalidSPDXAnalysisException("Invalid element URI: " + node.getURI());
            }
            String docId = modelContainer.documentNamespaceToId(uriParts[0]);
            if (docId == null) {
                throw new InvalidSPDXAnalysisException("No external document reference was found for URI " + node.getURI());
            }
            String externalId = docId + ":" + uriParts[1];
            return new ExternalSpdxElement(externalId);
        }
        retval = SpdxElementFactory.getElementByType(modelContainer, node);
        if (retval == null && (retval = SpdxElementFactory.guessElementByProperties(modelContainer, node)) == null) {
            throw new InvalidSPDXAnalysisException("Unable to determine the SPDX element type from the model");
        }
        containerNodes.put(node, retval);
        return retval;
    }

    private static SpdxElement guessElementByProperties(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "licenseConcluded") && SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "copyrightText")) {
            return SpdxElementFactory.guessSpdxItemByProperties(modelContainer, node);
        }
        return new SpdxElement(modelContainer, node);
    }

    private static SpdxElement guessSpdxItemByProperties(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        if (SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "checksum") && SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "fileType")) {
            return new SpdxFile(modelContainer, node);
        }
        if (SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "checksum") && SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "downloadLocation") && SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "licenseInfoFromFiles") && SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "packageVerificationCode")) {
            return new SpdxPackage(modelContainer, node);
        }
        if (SpdxElementFactory.propertyExists(modelContainer, node, "http://spdx.org/rdf/terms#", "snippetFromFile")) {
            return new SpdxSnippet(modelContainer, node);
        }
        return new SpdxItem(modelContainer, node);
    }

    private static boolean propertyExists(IModelContainer modelContainer, Node node, String namespace2, String propertyName) {
        Node p = modelContainer.getModel().getProperty(namespace2, propertyName).asNode();
        Triple m = Triple.createMatch(node, p, null);
        ExtendedIterator<Triple> tripleIter = modelContainer.getModel().getGraph().find(m);
        return tripleIter.hasNext();
    }

    private static SpdxElement getElementByType(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Node rdfTypePredicate = modelContainer.getModel().getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Triple m = Triple.createMatch(node, rdfTypePredicate, null);
        ExtendedIterator<Triple> tripleIter = modelContainer.getModel().getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple triple = (Triple)tripleIter.next();
            if (tripleIter.hasNext()) {
                throw new InvalidSPDXAnalysisException("More than one type associated with an SPDX Element");
            }
            Node typeNode = triple.getObject();
            if (!typeNode.isURI()) {
                throw new InvalidSPDXAnalysisException("Invalid type for an SPDX Element - not a URI");
            }
            String typeUri = typeNode.getURI();
            if (!typeUri.startsWith("http://spdx.org/rdf/terms#")) {
                throw new InvalidSPDXAnalysisException("Invalid type for an SPDX Element - not an SPDX type");
            }
            String type = typeUri.substring("http://spdx.org/rdf/terms#".length());
            if (type.equals("File")) {
                return new SpdxFile(modelContainer, node);
            }
            if (type.equals("Package")) {
                return new SpdxPackage(modelContainer, node);
            }
            if (type.equals("Snippet")) {
                return new SpdxSnippet(modelContainer, node);
            }
            if (type.equals("SpdxItem")) {
                return new SpdxItem(modelContainer, node);
            }
            if (type.equals("SpdxElement")) {
                return new SpdxElement(modelContainer, node);
            }
            if (type.equals("SpdxDocument")) {
                return new SpdxDocumentContainer(modelContainer.getModel()).getSpdxDocument();
            }
            throw new InvalidSPDXAnalysisException("Invalid type for element '" + type + "'");
        }
        return null;
    }
}

