/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.pointer.SinglePointer;

public abstract class CompoundPointer
extends RdfModelObject {
    static final Logger logger = LoggerFactory.getLogger(CompoundPointer.class);
    protected SinglePointer startPointer;

    public CompoundPointer(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    public CompoundPointer(SinglePointer startPointer) {
        this.startPointer = startPointer;
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.startPointer = this.findSinglePointerPropertyValue("http://www.w3.org/2009/pointers#", "startPointer");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "startPointer", this.startPointer);
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = new ArrayList<String>();
        if (this.startPointer == null) {
            retval.add("Missing required start pointer");
        } else {
            retval.addAll(this.startPointer.verify());
        }
        return retval;
    }

    public SinglePointer getStartPointer() throws InvalidSPDXAnalysisException {
        if (this.model != null && this.refreshOnGet) {
            this.startPointer = this.findSinglePointerPropertyValue("http://www.w3.org/2009/pointers#", "startPointer");
        }
        return this.startPointer;
    }

    public void setStartPointer(SinglePointer startPointer) throws InvalidSPDXAnalysisException {
        this.startPointer = startPointer;
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "startPointer", this.startPointer);
    }

    @Override
    public boolean equivalent(IRdfModel o) {
        if (!(o instanceof CompoundPointer)) {
            return false;
        }
        CompoundPointer comp = (CompoundPointer)o;
        try {
            return this.equivalentConsideringNull(this.getStartPointer(), comp.getStartPointer());
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting the start pointer for the comparison", e2);
            return false;
        }
    }
}

