/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxNoneLicense;
import org.spdx.rdfparser.model.Annotation;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxPackage;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.PackageInfoSheet;
import org.spdx.spdxspreadsheet.SPDXSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class PackageInfoSheetV09d3
extends PackageInfoSheet {
    int NUM_COLS = 17;
    int NAME_COL = 0;
    int VERSION_COL = this.NAME_COL + 1;
    int MACHINE_NAME_COL = this.VERSION_COL + 1;
    int SUPPLIER_COL = this.MACHINE_NAME_COL + 1;
    int ORIGINATOR_COL = this.SUPPLIER_COL + 1;
    int URL_COL = this.ORIGINATOR_COL + 1;
    int PACKAGE_SHA_COL = this.URL_COL + 1;
    int FILE_VERIFICATION_VALUE_COL = this.PACKAGE_SHA_COL + 1;
    int VERIFICATION_EXCLUDED_FILES_COL = this.FILE_VERIFICATION_VALUE_COL + 1;
    int SOURCE_INFO_COL = this.VERIFICATION_EXCLUDED_FILES_COL + 1;
    int DECLARED_LICENSE_COL = this.SOURCE_INFO_COL + 1;
    int CONCLUDED_LICENSE_COL = this.DECLARED_LICENSE_COL + 1;
    int LICENSE_INFO_IN_FILES_COL = this.CONCLUDED_LICENSE_COL + 1;
    int LICENSE_COMMENT_COL = this.LICENSE_INFO_IN_FILES_COL + 1;
    int DECLARED_COPYRIGHT_COL = this.LICENSE_COMMENT_COL + 1;
    int SHORT_DESC_COL = this.DECLARED_COPYRIGHT_COL + 1;
    int FULL_DESC_COL = this.SHORT_DESC_COL + 1;
    static final boolean[] REQUIRED = new boolean[]{true, false, true, false, false, true, true, true, true, false, true, true, true, false, true, false, false};
    static final String[] HEADER_TITLES = new String[]{"Package Name", "Package Version", "Package FileName", "Package Supplier", "Package Originator", "Package Download Location", "Package Checksum", "Package Verification Code", "Verification Code Excluded Files", "Source Info", "License Declared", "License Concluded", "License Info From Files", "License Comments", "Package Copyright Text", "Summary", "Description"};
    static final int[] COLUMN_WIDTHS = new int[]{30, 17, 30, 30, 30, 50, 25, 25, 40, 30, 40, 40, 90, 50, 50, 50, 80};

    public PackageInfoSheetV09d3(Workbook workbook, String sheetName, String version2) {
        super(workbook, sheetName, version2);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX Package Info does not exist";
            }
            if (!SPDXSpreadsheet.verifyVersion(this.version)) {
                return "Unsupported version " + this.version;
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < this.NUM_COLS; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Package Info worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX Package Info work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < this.NUM_COLS; ++i) {
            String supplier;
            Cell supplierCell;
            String error;
            Cell cell = row.getCell(i);
            if (cell == null) {
                if (!REQUIRED[i]) continue;
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
            }
            if (i == this.DECLARED_LICENSE_COL || i == this.CONCLUDED_LICENSE_COL) {
                try {
                    LicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue(), null);
                    continue;
                }
                catch (SpreadsheetException ex) {
                    if (i == this.DECLARED_LICENSE_COL) {
                        return "Invalid declared license in row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage();
                    }
                    return "Invalid seen license in row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage();
                }
            }
            if (i == this.LICENSE_INFO_IN_FILES_COL) {
                String[] licenses = row.getCell(this.LICENSE_INFO_IN_FILES_COL).getStringCellValue().split(",");
                if (licenses.length < 1) {
                    return "Missing licenss information in files";
                }
                for (int j = 0; j < licenses.length; ++j) {
                    try {
                        LicenseInfoFactory.parseSPDXLicenseString(cell.getStringCellValue().trim(), null);
                        continue;
                    }
                    catch (SpreadsheetException ex) {
                        return "Invalid license information in row " + String.valueOf(row.getRowNum()) + " detail: " + ex.getMessage();
                    }
                }
                continue;
            }
            if (i == this.ORIGINATOR_COL) {
                String originator;
                Cell origCell = row.getCell(this.ORIGINATOR_COL);
                if (origCell == null || (originator = origCell.getStringCellValue()) == null || originator.isEmpty() || (error = SpdxVerificationHelper.verifyOriginator(originator)) == null || error.isEmpty()) continue;
                return "Invalid originator in row " + String.valueOf(row.getRowNum()) + ": " + error;
            }
            if (i != this.SUPPLIER_COL || (supplierCell = row.getCell(this.SUPPLIER_COL)) == null || (supplier = supplierCell.getStringCellValue()) == null || supplier.isEmpty() || (error = SpdxVerificationHelper.verifySupplier(supplier)) == null || error.isEmpty()) continue;
            return "Invalid supplier in row " + String.valueOf(row.getRowNum()) + ": " + error;
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    @Override
    public void add(SpdxPackage pkgInfo) throws InvalidSPDXAnalysisException {
        AnyLicenseInfo[] licenseInfosInFiles;
        Row row = this.addRow();
        Cell nameCell = row.createCell(this.NAME_COL);
        nameCell.setCellValue(pkgInfo.getName());
        Cell copyrightCell = row.createCell(this.DECLARED_COPYRIGHT_COL);
        copyrightCell.setCellValue(pkgInfo.getCopyrightText());
        Cell DeclaredLicenseCol = row.createCell(this.DECLARED_LICENSE_COL);
        DeclaredLicenseCol.setCellValue(pkgInfo.getLicenseDeclared().toString());
        Cell concludedLicenseCol = row.createCell(this.CONCLUDED_LICENSE_COL);
        concludedLicenseCol.setCellValue(pkgInfo.getLicenseConcluded().toString());
        Cell fileChecksumCell = row.createCell(this.FILE_VERIFICATION_VALUE_COL);
        if (pkgInfo.getPackageVerificationCode() != null) {
            fileChecksumCell.setCellValue(pkgInfo.getPackageVerificationCode().getValue());
            Cell verificationExcludedFilesCell = row.createCell(this.VERIFICATION_EXCLUDED_FILES_COL);
            StringBuilder excFilesStr = new StringBuilder();
            String[] excludedFiles = pkgInfo.getPackageVerificationCode().getExcludedFileNames();
            if (excludedFiles.length > 0) {
                excFilesStr.append(excludedFiles[0]);
                for (int i = 1; i < excludedFiles.length; ++i) {
                    excFilesStr.append(", ");
                    excFilesStr.append(excludedFiles[i]);
                }
            }
            verificationExcludedFilesCell.setCellValue(excFilesStr.toString());
        }
        if (pkgInfo.getDescription() != null) {
            Cell descCell = row.createCell(this.FULL_DESC_COL);
            descCell.setCellValue(pkgInfo.getDescription());
        }
        Cell fileNameCell = row.createCell(this.MACHINE_NAME_COL);
        fileNameCell.setCellValue(pkgInfo.getPackageFileName());
        Cell pkgSha1 = row.createCell(this.PACKAGE_SHA_COL);
        if (pkgInfo.getSha1() != null) {
            pkgSha1.setCellValue(pkgInfo.getSha1());
        }
        if ((licenseInfosInFiles = pkgInfo.getLicenseInfoFromFiles()) != null && licenseInfosInFiles.length > 0) {
            StringBuilder sb = new StringBuilder(licenseInfosInFiles[0].toString());
            for (int i = 1; i < licenseInfosInFiles.length; ++i) {
                sb.append(',');
                sb.append(licenseInfosInFiles[i].toString());
            }
            row.createCell(this.LICENSE_INFO_IN_FILES_COL).setCellValue(sb.toString());
        }
        if (pkgInfo.getLicenseComments() != null) {
            row.createCell(this.LICENSE_COMMENT_COL).setCellValue(pkgInfo.getLicenseComments());
        }
        if (pkgInfo.getSummary() != null) {
            Cell shortDescCell = row.createCell(this.SHORT_DESC_COL);
            shortDescCell.setCellValue(pkgInfo.getSummary());
        }
        if (pkgInfo.getSourceInfo() != null) {
            Cell sourceInfoCell = row.createCell(this.SOURCE_INFO_COL);
            sourceInfoCell.setCellValue(pkgInfo.getSourceInfo());
        }
        Cell urlCell = row.createCell(this.URL_COL);
        urlCell.setCellValue(pkgInfo.getDownloadLocation());
        if (pkgInfo.getVersionInfo() != null) {
            Cell versionInfoCell = row.createCell(this.VERSION_COL);
            versionInfoCell.setCellValue(pkgInfo.getVersionInfo());
        }
        if (pkgInfo.getOriginator() != null) {
            Cell originatorCell = row.createCell(this.ORIGINATOR_COL);
            originatorCell.setCellValue(pkgInfo.getOriginator());
        }
        if (pkgInfo.getSupplier() != null) {
            Cell supplierCell = row.createCell(this.SUPPLIER_COL);
            supplierCell.setCellValue(pkgInfo.getSupplier());
        }
    }

    @Override
    public SpdxPackage[] getPackages(SpdxDocumentContainer container2) throws SpreadsheetException {
        SpdxPackage[] retval = new SpdxPackage[this.getNumDataRows()];
        for (int i = 0; i < retval.length; ++i) {
            retval[i] = this.getPackage(this.getFirstDataRow() + i, container2);
        }
        return retval;
    }

    private SpdxPackage getPackage(int rowNum, SpdxDocumentContainer container2) throws SpreadsheetException {
        Cell versionInfoCell;
        String[] excludedFiles;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell nameCell = row.getCell(this.NAME_COL);
        if (nameCell == null || nameCell.getStringCellValue().isEmpty()) {
            return null;
        }
        String error = this.validateRow(row);
        if (error != null && !error.isEmpty()) {
            throw new SpreadsheetException(error);
        }
        String declaredName = nameCell.getStringCellValue();
        String machineName = row.getCell(this.MACHINE_NAME_COL).getStringCellValue();
        String sha1 = row.getCell(this.PACKAGE_SHA_COL).getStringCellValue();
        Cell sourceInfocol = row.getCell(this.SOURCE_INFO_COL);
        String sourceInfo = sourceInfocol != null ? sourceInfocol.getStringCellValue() : "";
        AnyLicenseInfo declaredLicenses = LicenseInfoFactory.parseSPDXLicenseString(row.getCell(this.DECLARED_LICENSE_COL).getStringCellValue(), container2);
        Cell concludedLicensesCell = row.getCell(this.CONCLUDED_LICENSE_COL);
        AnyLicenseInfo concludedLicense = concludedLicensesCell != null && !concludedLicensesCell.getStringCellValue().isEmpty() ? LicenseInfoFactory.parseSPDXLicenseString(concludedLicensesCell.getStringCellValue(), container2) : new SpdxNoneLicense();
        String[] licenseStrings = row.getCell(this.LICENSE_INFO_IN_FILES_COL).getStringCellValue().split(",");
        AnyLicenseInfo[] licenseInfosFromFiles = new AnyLicenseInfo[licenseStrings.length];
        for (int i = 0; i < licenseStrings.length; ++i) {
            licenseInfosFromFiles[i] = LicenseInfoFactory.parseSPDXLicenseString(licenseStrings[i].trim(), container2);
        }
        Cell licenseCommentCell = row.getCell(this.LICENSE_COMMENT_COL);
        String licenseComment = licenseCommentCell != null && !licenseCommentCell.getStringCellValue().isEmpty() ? licenseCommentCell.getStringCellValue() : "";
        String declaredCopyright = row.getCell(this.DECLARED_COPYRIGHT_COL).getStringCellValue();
        Cell shortDescCell = row.getCell(this.SHORT_DESC_COL);
        String shortDesc = shortDescCell != null && !shortDescCell.getStringCellValue().isEmpty() ? shortDescCell.getStringCellValue() : "";
        Cell descCell = row.getCell(this.FULL_DESC_COL);
        String description = descCell != null && !descCell.getStringCellValue().isEmpty() ? descCell.getStringCellValue() : "";
        String url = row.getCell(this.URL_COL).getStringCellValue();
        String packageVerificationValue = row.getCell(this.FILE_VERIFICATION_VALUE_COL).getStringCellValue();
        String excludedFilesStr = row.getCell(this.VERIFICATION_EXCLUDED_FILES_COL).getStringCellValue();
        if (excludedFilesStr != null && !excludedFilesStr.isEmpty()) {
            excludedFiles = excludedFilesStr.split(",");
            for (int i = 0; i < excludedFiles.length; ++i) {
                excludedFiles[i] = excludedFiles[i].trim();
            }
        } else {
            excludedFiles = new String[]{};
        }
        String versionInfo = (versionInfoCell = row.getCell(this.VERSION_COL)) != null && !versionInfoCell.getStringCellValue().isEmpty() ? versionInfoCell.getStringCellValue() : "";
        Cell supplierCell = row.getCell(this.SUPPLIER_COL);
        String supplier = supplierCell != null && !supplierCell.getStringCellValue().isEmpty() ? supplierCell.getStringCellValue() : "";
        Cell originatorCell = row.getCell(this.ORIGINATOR_COL);
        String originator = originatorCell != null && !originatorCell.getStringCellValue().isEmpty() ? originatorCell.getStringCellValue() : "";
        SpdxPackageVerificationCode verificationCode = new SpdxPackageVerificationCode(packageVerificationValue, excludedFiles);
        Checksum[] checksums = new Checksum[]{new Checksum(Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1, sha1)};
        return new SpdxPackage(declaredName, "", new Annotation[0], new Relationship[0], concludedLicense, licenseInfosFromFiles, declaredCopyright, licenseComment, declaredLicenses, checksums, description, url, new SpdxFile[0], "", originator, machineName, verificationCode, sourceInfo, shortDesc, supplier, versionInfo);
    }
}

