/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licensexml.XmlLicenseProvider;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.license.SpdxListedLicenseException;
import org.spdx.spdxspreadsheet.SPDXLicenseSpreadsheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;
import org.spdx.tools.LicenseGeneratorException;
import org.spdx.tools.licensegenerator.FsfLicenseDataParser;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.ILicenseTester;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;
import org.spdx.tools.licensegenerator.LicenseJsonFormatWriter;
import org.spdx.tools.licensegenerator.LicenseMarkdownFormatWriter;
import org.spdx.tools.licensegenerator.LicenseRdfFormatWriter;
import org.spdx.tools.licensegenerator.LicenseRdfaFormatWriter;
import org.spdx.tools.licensegenerator.LicenseTemplateFormatWriter;
import org.spdx.tools.licensegenerator.LicenseTextFormatWriter;
import org.spdx.tools.licensegenerator.SimpleLicenseTester;
import org.spdx.tools.licensegenerator.SpdxWebsiteFormatWriter;

public class LicenseRDFAGenerator {
    static final Set<Character> INVALID_TEXT_CHARS = Sets.newHashSet();
    static int MIN_ARGS;
    static int MAX_ARGS;
    static final int ERROR_STATUS = 1;
    static final int WARNING_STATUS = 64;
    static final String CSS_TEMPLATE_FILE = "resources/screen.css";
    static final String CSS_FILE_NAME = "screen.css";
    static final String SORTTABLE_JS_FILE = "resources/sorttable.js";
    static final String SORTTABLE_FILE_NAME = "sorttable.js";
    static final String TEXT_FOLDER_NAME = "text";
    static final String TEMPLATE_FOLDER_NAME = "template";
    static final String HTML_FOLDER_NAME = "html";
    static final String RDFA_FOLDER_NAME = "rdfa";
    static final String JSON_FOLDER_NAME = "json";
    private static final String WEBSITE_FOLDER_NAME = "website";
    private static final String RDFXML_FOLDER_NAME = "rdfxml";
    private static final String RDFTURTLE_FOLDER_NAME = "rdfturtle";
    private static final String RDFNT_FOLDER_NAME = "rdfnt";
    private static final String TABLE_OF_CONTENTS_FILE_NAME = "licenses.md";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        File dir;
        File ssFile;
        if (args == null || args.length < MIN_ARGS || args.length > MAX_ARGS) {
            System.out.println("Invalid arguments");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(ssFile = new File(args[0])).exists()) {
            System.out.println("Spreadsheet file " + ssFile.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!(dir = new File(args[1])).exists()) {
            System.out.println("Output directory " + dir.getName() + " does not exist");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        if (!dir.isDirectory()) {
            System.out.println("Output directory " + dir.getName() + " is not a directory");
            LicenseRDFAGenerator.usage();
            System.exit(1);
        }
        String version2 = null;
        if (args.length > 2) {
            version2 = args[2];
        }
        String releaseDate = null;
        if (args.length > 3) {
            releaseDate = args[3];
        }
        File testFileDir = null;
        if (args.length > 4) {
            testFileDir = new File(args[4]);
            if (!testFileDir.exists()) {
                System.out.println("License test directory " + testFileDir.getName() + " does not exist");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
            if (!testFileDir.isDirectory()) {
                System.out.println("License test directory " + testFileDir.getName() + " is not a directory");
                LicenseRDFAGenerator.usage();
                System.exit(1);
            }
        }
        String[] ignoredWarnings = new String[]{};
        if (args.length > 5) {
            CSVReader reader = null;
            try {
                File warningsFile = new File(args[5]);
                reader = warningsFile.exists() ? new CSVReader(new FileReader(warningsFile)) : new CSVReader(new StringReader(args[5]));
                ignoredWarnings = reader.readNext();
            }
            catch (IOException e2) {
                System.out.println("IO Error reading ignored errors: " + e2.getMessage());
                System.exit(1);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e3) {
                        System.out.println("IO Error closing ignored errors string: " + e3.getMessage());
                        System.exit(1);
                    }
                }
            }
        }
        try {
            List<String> warnings = LicenseRDFAGenerator.generateLicenseData(ssFile, dir, version2, releaseDate, testFileDir);
            if (warnings != null && warnings.size() > 0) {
                int numUnexpectedWarnings = warnings.size();
                for (String warning : warnings) {
                    boolean ignore = false;
                    for (String ignoreStr : ignoredWarnings) {
                        if (!warning.equalsIgnoreCase(ignoreStr)) continue;
                        ignore = true;
                        System.out.println("Ignoring warning '" + ignoreStr + "'");
                        break;
                    }
                    if (!ignore) continue;
                    --numUnexpectedWarnings;
                }
                if (numUnexpectedWarnings > 0) {
                    System.exit(64);
                }
            }
        }
        catch (LicenseGeneratorException e4) {
            System.out.println(e4.getMessage());
            System.exit(1);
        }
    }

    public static List<String> generateLicenseData(File ssFile, File dir, String version2, String releaseDate, File testFileDir) throws LicenseGeneratorException {
        ArrayList<String> warnings = Lists.newArrayList();
        ArrayList<ILicenseFormatWriter> writers = Lists.newArrayList();
        ISpdxListedLicenseProvider licenseProvider = null;
        try {
            if (ssFile.getName().toLowerCase().endsWith(".xls")) {
                SPDXLicenseSpreadsheet licenseSpreadsheet = new SPDXLicenseSpreadsheet(ssFile, false, true);
                licenseProvider = licenseSpreadsheet;
                if (version2 == null || version2.trim().isEmpty()) {
                    version2 = licenseSpreadsheet.getLicenseSheet().getVersion();
                }
                if (releaseDate == null || releaseDate.trim().isEmpty()) {
                    releaseDate = licenseSpreadsheet.getLicenseSheet().getReleaseDate();
                }
            } else if (ssFile.isDirectory()) {
                licenseProvider = new XmlLicenseProvider(ssFile);
            } else {
                throw new LicenseGeneratorException("Unsupported file format.  Must be a .xls file");
            }
            File textFolder = new File(dir.getPath() + File.separator + TEXT_FOLDER_NAME);
            if (!textFolder.isDirectory() && !textFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: text folder is not a directory");
            }
            writers.add(new LicenseTextFormatWriter(textFolder));
            File templateFolder = new File(dir.getPath() + File.separator + TEMPLATE_FOLDER_NAME);
            if (!templateFolder.isDirectory() && !templateFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: template folder is not a directory");
            }
            writers.add(new LicenseTemplateFormatWriter(templateFolder));
            File htmlFolder = new File(dir.getPath() + File.separator + HTML_FOLDER_NAME);
            if (!htmlFolder.isDirectory() && !htmlFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: HTML folder is not a directory");
            }
            writers.add(new LicenseHtmlFormatWriter(version2, releaseDate, htmlFolder));
            File rdfaFolder = new File(dir.getPath() + File.separator + RDFA_FOLDER_NAME);
            if (!rdfaFolder.isDirectory() && !rdfaFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: RDFa folder is not a directory");
            }
            writers.add(new LicenseRdfaFormatWriter(version2, releaseDate, rdfaFolder));
            File jsonFolder = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME);
            if (!jsonFolder.isDirectory() && !jsonFolder.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderDetails = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "details");
            if (!jsonFolderDetails.isDirectory() && !jsonFolderDetails.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            File jsonFolderExceptions = new File(dir.getPath() + File.separator + JSON_FOLDER_NAME + File.separator + "exceptions");
            if (!jsonFolderExceptions.isDirectory() && !jsonFolderExceptions.mkdir()) {
                throw new LicenseGeneratorException("Error: JSON folder is not a directory");
            }
            writers.add(new LicenseJsonFormatWriter(version2, releaseDate, jsonFolder, jsonFolderDetails, jsonFolderExceptions));
            File website = new File(dir.getPath() + File.separator + WEBSITE_FOLDER_NAME);
            if (!website.isDirectory() && !website.mkdir()) {
                throw new LicenseGeneratorException("Error: Website folder is not a directory");
            }
            writers.add(new SpdxWebsiteFormatWriter(version2, releaseDate, website));
            File rdfXml = new File(dir.getPath() + File.separator + RDFXML_FOLDER_NAME);
            if (!rdfXml.isDirectory() && !rdfXml.mkdir()) {
                throw new LicenseGeneratorException("Error: RdfXML folder is not a directory");
            }
            File rdfTurtle = new File(dir.getPath() + File.separator + RDFTURTLE_FOLDER_NAME);
            if (!rdfTurtle.isDirectory() && !rdfTurtle.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF Turtle folder is not a directory");
            }
            File rdfNt = new File(dir.getPath() + File.separator + RDFNT_FOLDER_NAME);
            if (!rdfNt.isDirectory() && !rdfNt.mkdir()) {
                throw new LicenseGeneratorException("Error: RDF NT folder is not a directory");
            }
            writers.add(new LicenseRdfFormatWriter(rdfXml, rdfTurtle, rdfNt));
            File markdownFile = new File(dir.getPath() + File.separator + TABLE_OF_CONTENTS_FILE_NAME);
            if (!markdownFile.isFile() && !markdownFile.createNewFile()) {
                throw new LicenseGeneratorException("Error: Unable to create markdown file");
            }
            writers.add(new LicenseMarkdownFormatWriter(version2, releaseDate, markdownFile));
            SimpleLicenseTester tester = null;
            if (testFileDir != null) {
                tester = new SimpleLicenseTester(testFileDir);
            }
            System.out.print("Processing License List");
            LicenseRDFAGenerator.writeLicenseList(version2, releaseDate, licenseProvider, warnings, writers, tester);
            System.out.println();
            System.out.print("Processing Exceptions");
            LicenseRDFAGenerator.writeExceptionList(version2, releaseDate, licenseProvider, warnings, writers, tester);
            System.out.println();
            System.out.print("Writing table of contents");
            for (ILicenseFormatWriter writer : writers) {
                writer.writeToC();
            }
            LicenseRDFAGenerator.writeCssFile(website);
            LicenseRDFAGenerator.writeSortTableFile(website);
            System.out.println();
            warnings.addAll(licenseProvider.getWarnings());
            if (warnings.size() > 0) {
                System.out.println("The following warning(s) were identified:");
                for (String warning : warnings) {
                    System.out.println("\t" + warning);
                }
            }
            System.out.println("Completed processing licenses");
            Iterator iterator = warnings;
            return iterator;
        }
        catch (SpreadsheetException e2) {
            throw new LicenseGeneratorException("\nInvalid spreadsheet: " + e2.getMessage(), e2);
        }
        catch (SpdxListedLicenseException e3) {
            throw new LicenseGeneratorException("\nError reading standard licenses: " + e3.getMessage(), e3);
        }
        catch (LicenseGeneratorException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new LicenseGeneratorException("\nUnhandled exception generating html: " + e5.getMessage(), e5);
        }
        finally {
            if (licenseProvider != null && licenseProvider instanceof SPDXLicenseSpreadsheet) {
                try {
                    SPDXLicenseSpreadsheet spreadsheet = (SPDXLicenseSpreadsheet)licenseProvider;
                    spreadsheet.close();
                }
                catch (SpreadsheetException e6) {
                    System.out.println("Error closing spreadsheet file: " + e6.getMessage());
                }
            }
        }
    }

    private static void writeExceptionList(String version2, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester) throws IOException, LicenseRestrictionException, SpreadsheetException, LicenseGeneratorException, InvalidLicenseTemplateException {
        HashSet<String> licenseIds = Sets.newHashSet();
        try {
            Iterator<SpdxListedLicense> licIter = licenseProvider.getLicenseIterator();
            while (licIter.hasNext()) {
                licenseIds.add(licIter.next().getLicenseId());
            }
        }
        catch (SpdxListedLicenseException e2) {
            System.out.println("Warning - Not able to check for duplicate license and exception ID's");
        }
        Iterator<LicenseException> exceptionIter = licenseProvider.getExceptionIterator();
        HashMap<String, String> addedExceptionsMap = Maps.newHashMap();
        while (exceptionIter.hasNext()) {
            List<String> testResults;
            Map.Entry entry2;
            System.out.print(".");
            LicenseException nextException = exceptionIter.next();
            LicenseRDFAGenerator.addExternalMetaData(nextException);
            if (nextException.getLicenseExceptionId() == null || nextException.getLicenseExceptionId().isEmpty()) continue;
            for (Map.Entry entry2 : addedExceptionsMap.entrySet()) {
                if (!((String)entry2.getValue()).trim().equals(nextException.getLicenseExceptionText().trim())) continue;
                warnings.add("Duplicates exceptions: " + nextException.getLicenseExceptionId() + ", " + (String)entry2.getKey());
            }
            if (licenseIds.contains(nextException.getLicenseExceptionId())) {
                warnings.add("A license ID exists with the same ID as an exception ID: " + nextException.getLicenseExceptionId());
            }
            LicenseRDFAGenerator.checkText(nextException.getLicenseExceptionText(), "License Exception Text for " + nextException.getLicenseExceptionId(), warnings);
            addedExceptionsMap.put(nextException.getLicenseExceptionId(), nextException.getLicenseExceptionText());
            entry2 = writers.iterator();
            while (entry2.hasNext()) {
                ILicenseFormatWriter writer = (ILicenseFormatWriter)entry2.next();
                writer.writeException(nextException, false, null);
            }
            if (tester == null || (testResults = tester.testException(nextException)) == null || testResults.size() <= 0) continue;
            for (String testResult : testResults) {
                warnings.add("Test for exception " + nextException.getLicenseExceptionId() + " failed: " + testResult);
            }
        }
    }

    private static void addExternalMetaData(LicenseException exception) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkText(String text, String textDescription, List<String> warnings) {
        BufferedReader reader = new BufferedReader(new StringReader(text));
        try {
            int lineNumber = 1;
            String line = reader.readLine();
            while (line != null) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!INVALID_TEXT_CHARS.contains(Character.valueOf(line.charAt(i)))) continue;
                    warnings.add("Invalid character in " + textDescription + " at line number " + String.valueOf(lineNumber) + " \"" + line + "\" at character location " + String.valueOf(i));
                }
                ++lineNumber;
                line = reader.readLine();
            }
        }
        catch (IOException e2) {
            warnings.add("IO error reading text");
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e3) {
                warnings.add("IO Error closing string reader");
            }
        }
    }

    private static void writeLicenseList(String version2, String releaseDate, ISpdxListedLicenseProvider licenseProvider, List<String> warnings, List<ILicenseFormatWriter> writers, ILicenseTester tester) throws LicenseGeneratorException, InvalidSPDXAnalysisException, IOException, SpdxListedLicenseException, SpdxCompareException {
        List<String> testResults;
        Object writer;
        Iterator<SpdxListedLicense> licenseIter = licenseProvider.getLicenseIterator();
        HashMap<String, String> addedLicIdTextMap = Maps.newHashMap();
        while (licenseIter.hasNext()) {
            Map.Entry entry2;
            System.out.print(".");
            SpdxListedLicense license = licenseIter.next();
            LicenseRDFAGenerator.addExternalMetaData(license);
            if (license.getLicenseId() == null || license.getLicenseId().isEmpty()) continue;
            for (Map.Entry entry2 : addedLicIdTextMap.entrySet()) {
                if (!LicenseCompareHelper.isLicenseTextEquivalent((String)entry2.getValue(), license.getLicenseText())) continue;
                warnings.add("Duplicates licenses: " + license.getLicenseId() + ", " + (String)entry2.getKey());
            }
            addedLicIdTextMap.put(license.getLicenseId(), license.getLicenseText());
            LicenseRDFAGenerator.checkText(license.getLicenseText(), "License text for " + license.getLicenseId(), warnings);
            entry2 = writers.iterator();
            while (entry2.hasNext()) {
                writer = (ILicenseFormatWriter)entry2.next();
                writer.writeLicense(license, false, null);
            }
            if (tester == null || (testResults = tester.testLicense(license)) == null || testResults.size() <= 0) continue;
            for (String testResult : testResults) {
                warnings.add("Test for license " + license.getLicenseId() + " failed: " + testResult);
            }
        }
        Iterator<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> depIter = licenseProvider.getDeprecatedLicenseIterator();
        while (depIter.hasNext()) {
            System.out.print(".");
            SPDXLicenseSpreadsheet.DeprecatedLicenseInfo deprecatedLicense = depIter.next();
            testResults = writers.iterator();
            while (testResults.hasNext()) {
                writer = testResults.next();
                writer.writeLicense(deprecatedLicense.getLicense(), true, deprecatedLicense.getDeprecatedVersion());
            }
            if (tester == null || (testResults = tester.testLicense(deprecatedLicense.getLicense())) == null || testResults.size() <= 0) continue;
            for (String testResult : testResults) {
                warnings.add("Test for license " + deprecatedLicense.getLicense().getLicenseId() + " failed: " + testResult);
            }
        }
    }

    private static void addExternalMetaData(SpdxListedLicense license) throws LicenseGeneratorException {
        license.setFsfLibre(FsfLicenseDataParser.getFsfLicenseDataParser().isSpdxLicenseFsfLibre(license.getLicenseId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyResourceFile(String resourceFileName, File destination) throws IOException {
        File resourceFile = new File(resourceFileName);
        if (resourceFile.exists()) {
            Files.copy(resourceFile, destination);
        } else {
            InputStream is = LicenseRDFAGenerator.class.getClassLoader().getResourceAsStream(resourceFileName);
            InputStreamReader reader = new InputStreamReader(is);
            FileWriter writer = new FileWriter(destination);
            try {
                char[] buf = new char[2048];
                int len = reader.read(buf);
                while (len > 0) {
                    writer.write(buf, 0, len);
                    len = reader.read(buf);
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                reader.close();
            }
        }
    }

    private static void writeCssFile(File dir) throws IOException {
        File cssFile = new File(dir.getPath() + File.separator + CSS_FILE_NAME);
        if (cssFile.exists() && !cssFile.delete()) {
            throw new IOException("Unable to delete old file");
        }
        LicenseRDFAGenerator.copyResourceFile(CSS_TEMPLATE_FILE, cssFile);
    }

    private static void writeSortTableFile(File dir) throws IOException {
        File sortTableFile = new File(dir.getPath() + File.separator + SORTTABLE_FILE_NAME);
        if (sortTableFile.exists()) {
            return;
        }
        LicenseRDFAGenerator.copyResourceFile(SORTTABLE_JS_FILE, sortTableFile);
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("LicenseRDFAGenerator input outputDirectory [version] [releasedate] [testfiles] [ignoredwarnings]");
        System.out.println("   Input - either a spreadsheet containing license information or a directory of license XML files");
        System.out.println("   outputDirectory - Directory to store the output from the license generator");
        System.out.println("   [version] - Version of the SPDX license list");
        System.out.println("   [releasedate] - Release date of the SPDX license list");
        System.out.println("   [testfiles] - Directory of original text files to compare the generated licenses against");
        System.out.println("   [ignoredwarnings] - Either a file name or a comma separated list of warnings to be ignored");
    }

    static {
        INVALID_TEXT_CHARS.add(Character.valueOf('\ufffd'));
        MIN_ARGS = 2;
        MAX_ARGS = 6;
    }
}

