/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.tools.LicenseGeneratorException;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;
import org.spdx.tools.licensegenerator.LicenseHtmlFormatWriter;

public class LicenseTemplateFormatWriter
implements ILicenseFormatWriter {
    private File templateFolder;
    private Charset utf8 = Charset.forName("UTF-8");

    public LicenseTemplateFormatWriter(File templateFolder) {
        this.templateFolder = templateFolder;
    }

    public File getTemplateFolder() {
        return this.templateFolder;
    }

    public void setTemplateFolder(File templateFolder) {
        this.templateFolder = templateFolder;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException {
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(license.getLicenseId());
        if (deprecated) {
            licBaseHtmlFileName = "deprecated_" + licBaseHtmlFileName;
        }
        File templateFile = new File(this.templateFolder.getPath() + File.separator + licBaseHtmlFileName + ".template.txt");
        if (license.getStandardLicenseTemplate() != null && !license.getStandardLicenseTemplate().trim().isEmpty()) {
            Files.write(license.getStandardLicenseTemplate(), templateFile, this.utf8);
        } else {
            Files.write(license.getLicenseText(), templateFile, this.utf8);
        }
    }

    @Override
    public void writeToC() throws IOException, LicenseGeneratorException {
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException, LicenseGeneratorException {
        String licBaseHtmlFileName = LicenseHtmlFormatWriter.formLicenseHTMLFileName(exception.getLicenseExceptionId());
        if (deprecated) {
            licBaseHtmlFileName = "deprecated_" + licBaseHtmlFileName;
        }
        File templateFile = new File(this.templateFolder.getPath() + File.separator + licBaseHtmlFileName + ".template.txt");
        Files.write(exception.getLicenseExceptionTemplate(), templateFile, this.utf8);
    }
}

