/*
 * Decompiled with CFR 0.152.
 */
package org.stringtemplate.v4;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.stringtemplate.v4.STWriter;

public class AutoIndentWriter
implements STWriter {
    public List<String> indents = new ArrayList<String>();
    public int[] anchors = new int[10];
    public int anchors_sp = -1;
    public String newline;
    public Writer out = null;
    public boolean atStartOfLine = true;
    public int charPosition = 0;
    public int charIndex = 0;
    public int lineWidth = -1;

    public AutoIndentWriter(Writer out, String newline) {
        this.out = out;
        this.indents.add(null);
        this.newline = newline;
    }

    public AutoIndentWriter(Writer out) {
        this(out, System.getProperty("line.separator"));
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public void pushIndentation(String indent) {
        this.indents.add(indent);
    }

    @Override
    public String popIndentation() {
        return this.indents.remove(this.indents.size() - 1);
    }

    @Override
    public void pushAnchorPoint() {
        if (this.anchors_sp + 1 >= this.anchors.length) {
            int[] a = new int[this.anchors.length * 2];
            System.arraycopy(this.anchors, 0, a, 0, this.anchors.length - 1);
            this.anchors = a;
        }
        ++this.anchors_sp;
        this.anchors[this.anchors_sp] = this.charPosition;
    }

    @Override
    public void popAnchorPoint() {
        --this.anchors_sp;
    }

    @Override
    public int index() {
        return this.charIndex;
    }

    @Override
    public int write(String str2) throws IOException {
        int n = 0;
        int nll = this.newline.length();
        int sl = str2.length();
        for (int i = 0; i < sl; ++i) {
            char c = str2.charAt(i);
            if (c == '\r') continue;
            if (c == '\n') {
                this.atStartOfLine = true;
                this.charPosition = -nll;
                this.out.write(this.newline);
                this.charIndex += nll;
                this.charPosition += (n += nll);
                continue;
            }
            if (this.atStartOfLine) {
                n += this.indent();
                this.atStartOfLine = false;
            }
            ++n;
            this.out.write(c);
            ++this.charPosition;
            ++this.charIndex;
        }
        return n;
    }

    @Override
    public int writeSeparator(String str2) throws IOException {
        return this.write(str2);
    }

    @Override
    public int write(String str2, String wrap) throws IOException {
        int n = this.writeWrap(wrap);
        return n + this.write(str2);
    }

    @Override
    public int writeWrap(String wrap) throws IOException {
        int n = 0;
        if (this.lineWidth != -1 && wrap != null && !this.atStartOfLine && this.charPosition >= this.lineWidth) {
            for (int i = 0; i < wrap.length(); ++i) {
                char c = wrap.charAt(i);
                if (c == '\r') continue;
                if (c == '\n') {
                    this.out.write(this.newline);
                    n += this.newline.length();
                    this.charPosition = 0;
                    this.charIndex += this.newline.length();
                    n += this.indent();
                    continue;
                }
                ++n;
                this.out.write(c);
                ++this.charPosition;
                ++this.charIndex;
            }
        }
        return n;
    }

    public int indent() throws IOException {
        int n = 0;
        for (String ind : this.indents) {
            if (ind == null) continue;
            n += ind.length();
            this.out.write(ind);
        }
        int indentWidth = n;
        if (this.anchors_sp >= 0 && this.anchors[this.anchors_sp] > indentWidth) {
            int remainder = this.anchors[this.anchors_sp] - indentWidth;
            for (int i = 1; i <= remainder; ++i) {
                this.out.write(32);
            }
            n += remainder;
        }
        this.charPosition += n;
        this.charIndex += n;
        return n;
    }
}

