/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.rootdev.javardfa.jena.RDFaReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.NoListedLicenseRdfModel;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.IRdfModel;

public class ListedLicenses
implements IModelContainer {
    public static final String DEFAULT_LICENSE_LIST_VERSION = "2.0";
    static final Logger logger = LoggerFactory.getLogger((String)ListedLicenses.class.getName());
    static final String LISTED_LICENSE_ID_URL = "http://spdx.org/licenses/";
    public static final String LISTED_LICENSE_URI_PREFIX = "http://spdx.org/licenses/";
    private static final String LISTED_LICENSE_RDF_LOCAL_DIR = "resources/stdlicenses";
    private static final String LISTED_LICENSE_RDF_LOCAL_FILENAME = "resources/stdlicenses/index.html";
    private static final String LISTED_LICENSE_PROPERTIES_FILENAME = "resources/stdlicenses/licenses.properties";
    private Model listedLicenseModel = null;
    Set<String> listdLicenseIds = null;
    Map<String, SpdxListedLicense> listedLicenseCache = null;
    Map<IModelContainer, Map<Node, SpdxListedLicense>> listedLicenseNodeCache = Maps.newHashMap();
    Properties licenseProperties = ListedLicenses.loadLicenseProperties();
    boolean onlyUseLocalLicenses = Boolean.parseBoolean(System.getProperty("SPDXParser.OnlyUseLocalLicenses", this.licenseProperties.getProperty("OnlyUseLocalLicenses", "false")));
    String licenseListVersion = "2.0";
    private static volatile ListedLicenses listedLicenses = null;
    private static final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();
    int nextId = 0;

    private ListedLicenses() {
        this.loadListedLicenseIDs();
    }

    public static ListedLicenses getListedLicenses() {
        if (listedLicenses == null) {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (listedLicenses == null) {
                    listedLicenses = new ListedLicenses();
                }
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
        return listedLicenses;
    }

    public static ListedLicenses resetListedLicenses() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses();
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    static void readRdfaIntoModel(Model model, InputStream is, String rootUri) {
        new RDFaReader.HTMLRDFaReader().read(model, is, rootUri);
    }

    @Override
    public Model getModel() {
        return this.listedLicenseModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SpdxListedLicense getLicenseFromUri(String uri) throws InvalidSPDXAnalysisException {
        SpdxListedLicense retval;
        URL licenseUrl = null;
        try {
            licenseUrl = new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new InvalidSPDXAnalysisException("Invalid listed license URL: " + e.getMessage());
        }
        String id = this.urlToId(licenseUrl);
        listedLicenseModificationLock.readLock().lock();
        try {
            if (this.listedLicenseCache.containsKey(id)) {
                SpdxListedLicense spdxListedLicense = this.listedLicenseCache.get(id);
                return spdxListedLicense;
            }
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        String base = "http://spdx.org/licenses/" + id;
        final Model localLicenseModel = this.getLicenseModel(uri, base);
        if (localLicenseModel == null) {
            throw new InvalidSPDXAnalysisException("No listed license was found at " + uri);
        }
        Resource licResource = localLicenseModel.getResource(base);
        if (licResource == null || !localLicenseModel.containsResource(localLicenseModel.asRDFNode(licResource.asNode()))) {
            throw new InvalidSPDXAnalysisException("No listed license was found at " + uri);
        }
        final String localLicenseNamespace = this.getDocumentNamespace();
        IModelContainer localLicenseContainer = new IModelContainer(){

            @Override
            public Model getModel() {
                return localLicenseModel;
            }

            @Override
            public String getDocumentNamespace() {
                return localLicenseNamespace;
            }

            @Override
            public String getNextSpdxElementRef() {
                return null;
            }

            @Override
            public boolean spdxElementRefExists(String elementRef) {
                return false;
            }

            @Override
            public void addSpdxElementRef(String elementRef) {
            }

            @Override
            public String documentNamespaceToId(String externalNamespace) {
                return null;
            }

            @Override
            public String externalDocumentIdToNamespace(String docId) {
                return null;
            }

            @Override
            public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
                return null;
            }

            @Override
            public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
                return true;
            }
        };
        if (this.getModel().equals((Object)localLicenseModel)) {
            retval = new SpdxListedLicense(localLicenseContainer, licResource.asNode());
        } else {
            SpdxListedLicense localLicense = new SpdxListedLicense(localLicenseContainer, licResource.asNode());
            retval = (SpdxListedLicense)localLicense.clone();
            retval.createResource(this);
        }
        listedLicenseModificationLock.writeLock().lock();
        try {
            this.listedLicenseCache.put(id, retval);
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
        return retval;
    }

    private String urlToId(URL licenseUrl) {
        String[] pathParts = licenseUrl.getFile().split("/");
        String id = pathParts[pathParts.length - 1];
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getLicenseModel(String uri, String base) throws NoListedLicenseRdfModel {
        Model retval = ModelFactory.createDefaultModel();
        InputStream in = null;
        try {
            block31: {
                try {
                    if (this.onlyUseLocalLicenses && uri.startsWith("http://spdx.org/licenses/")) break block31;
                    String actualUrl = StringUtils.replaceOnce((String)uri, (String)"http://", (String)"https://");
                    in = FileManager.get().open(actualUrl);
                    try {
                        ListedLicenses.readRdfaIntoModel(retval, in, base);
                        Property p = retval.getProperty("http://spdx.org/rdf/terms#", "licenseId");
                        if (!retval.isEmpty() && retval.contains(null, p)) break block31;
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            logger.warn("Error closing listed license input");
                        }
                        in = null;
                    }
                    catch (Exception ex) {
                        if (in != null) {
                            in.close();
                            in = null;
                        }
                    }
                }
                catch (Exception ex) {
                    in = null;
                    logger.warn("Unable to open SPDX listed license model.  Using local file copy for SPDX listed licenses");
                }
            }
            if (in == null) {
                String id = uri.substring("http://spdx.org/licenses/".length());
                String fileName = "resources/stdlicenses/" + id;
                in = LicenseInfoFactory.class.getResourceAsStream("/" + fileName);
                if (in == null) {
                    throw new NoListedLicenseRdfModel("SPDX listed license " + uri + " could not be read.");
                }
                try (InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));){
                    ListedLicenses.readRdfaIntoModel(retval, in, uri);
                }
                catch (Exception ex) {
                    throw new NoListedLicenseRdfModel("Error reading the spdx listed licenses: " + ex.getMessage(), ex);
                }
            }
            Model model = retval;
            return model;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close model input stream");
                }
            }
        }
    }

    private Model getListedLicenseModel() throws InvalidSPDXAnalysisException {
        if (this.listedLicenseModel == null) {
            this.loadListedLicenseModel();
        }
        return this.listedLicenseModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadListedLicenseModel() throws InvalidSPDXAnalysisException {
        InputStream licRdfInput;
        Model myStdLicModel;
        block21: {
            myStdLicModel = ModelFactory.createDefaultModel();
            if (this.onlyUseLocalLicenses) {
                licRdfInput = null;
            } else {
                licRdfInput = null;
                try {
                    licRdfInput = FileManager.get().open("http://spdx.org/licenses/index.html");
                    ListedLicenses.readRdfaIntoModel(myStdLicModel, licRdfInput, "http://spdx.org/licenses/");
                    Property p = myStdLicModel.getProperty("http://spdx.org/rdf/terms#", "licenseId");
                    if (!myStdLicModel.isEmpty() && myStdLicModel.contains(null, p)) break block21;
                    try {
                        licRdfInput.close();
                    }
                    catch (IOException e) {
                        logger.warn("Error closing listed license input");
                    }
                    licRdfInput = null;
                }
                catch (Exception ex) {
                    logger.warn("Unable to access the SPDX listed licenses at http://www.spdx.org/licenses.  Using local file copy of SPDX listed licenses");
                    if (licRdfInput == null) break block21;
                    try {
                        licRdfInput.close();
                    }
                    catch (IOException e) {
                        logger.warn("Error closing listed license input");
                    }
                    licRdfInput = null;
                }
            }
        }
        try {
            if (licRdfInput == null) {
                licRdfInput = FileManager.get().open(LISTED_LICENSE_RDF_LOCAL_FILENAME);
                if (licRdfInput == null) {
                    licRdfInput = LicenseInfoFactory.class.getResourceAsStream("/resources/stdlicenses/index.html");
                }
                if (licRdfInput == null) {
                    throw new NoListedLicenseRdfModel("Unable to open SPDX listed license from website or from local file");
                }
                try {
                    ListedLicenses.readRdfaIntoModel(myStdLicModel, licRdfInput, "http://spdx.org/licenses/");
                }
                catch (Exception ex) {
                    throw new NoListedLicenseRdfModel("Unable to read the SPDX listed license model", ex);
                }
            }
            this.listedLicenseModel = myStdLicModel;
        }
        finally {
            if (licRdfInput != null) {
                try {
                    licRdfInput.close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close license RDF Input Stream");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadListedLicenseIDs() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            Triple t;
            this.listedLicenseCache = Maps.newHashMap();
            this.listdLicenseIds = Sets.newHashSet();
            Model stdLicenseModel = this.getListedLicenseModel();
            Node p = stdLicenseModel.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
            Triple m = Triple.createMatch(null, (Node)p, null);
            ExtendedIterator tripleIter = stdLicenseModel.getGraph().find(m);
            while (tripleIter.hasNext()) {
                t = (Triple)tripleIter.next();
                this.listdLicenseIds.add(t.getObject().toString(false));
            }
            p = stdLicenseModel.getProperty("http://spdx.org/rdf/terms#", "licenseListVersion").asNode();
            m = Triple.createMatch(null, (Node)p, null);
            tripleIter = stdLicenseModel.getGraph().find(m);
            if (tripleIter.hasNext()) {
                t = (Triple)tripleIter.next();
                String licenseListVersionPropertyValue = t.getObject().toString(false);
                this.licenseListVersion = StringUtils.substringBefore((String)licenseListVersionPropertyValue, (String)" ");
            }
        }
        catch (Exception ex) {
            logger.error("Error loading SPDX listed license ID's from model.");
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public boolean isSpdxListedLicenseID(String licenseID) {
        try {
            listedLicenseModificationLock.readLock().lock();
            boolean bl = this.listdLicenseIds.contains(licenseID);
            return bl;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadLicenseProperties() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            Properties licenseProperties = new Properties();
            InputStream in = null;
            try {
                in = LicenseInfoFactory.class.getResourceAsStream("/resources/stdlicenses/licenses.properties");
                if (in != null) {
                    licenseProperties.load(in);
                }
            }
            catch (IOException e) {
                logger.warn("IO Exception reading listed license properties file: " + e.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close listed license properties file: " + e.getMessage());
                    }
                }
            }
            Properties properties = licenseProperties;
            return properties;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public String[] getSpdxListedLicenseIds() {
        listedLicenseModificationLock.readLock().lock();
        try {
            String[] stringArray = this.listdLicenseIds.toArray(new String[this.listdLicenseIds.size()]);
            return stringArray;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.licenseListVersion;
    }

    public SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return this.getLicenseFromUri("http://spdx.org/licenses/" + licenseId);
    }

    public AnyLicenseInfo getLicenseFromStdLicModel(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        HashMap modelNodeCache = this.listedLicenseNodeCache.get(modelContainer);
        if (modelNodeCache == null) {
            modelNodeCache = Maps.newHashMap();
            this.listedLicenseNodeCache.put(modelContainer, modelNodeCache);
        }
        if (modelNodeCache.containsKey(node)) {
            return (AnyLicenseInfo)modelNodeCache.get(node);
        }
        SpdxListedLicense retval = new SpdxListedLicense(modelContainer, node);
        if (!this.equals(modelContainer)) {
            String licenseId = retval.getLicenseId();
            if (licenseId == null) {
                URL licenseUrl;
                try {
                    licenseUrl = new URL(node.getURI());
                }
                catch (MalformedURLException e) {
                    throw new InvalidSPDXAnalysisException("Invalid license URL");
                }
                licenseId = this.urlToId(licenseUrl);
            }
            try {
                SpdxListedLicense licenseFromModel = this.getListedLicenseById(licenseId);
                retval.copyFrom(licenseFromModel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        modelNodeCache.put(node, retval);
        return retval;
    }

    @Override
    public String getDocumentNamespace() {
        return "http://spdx.org/licenses/";
    }

    @Override
    public synchronized String getNextSpdxElementRef() {
        ++this.nextId;
        return "SpdxLicenseGeneratedId-" + String.valueOf(this.nextId);
    }

    @Override
    public boolean spdxElementRefExists(String elementRef) {
        return this.listdLicenseIds.contains(elementRef);
    }

    @Override
    public void addSpdxElementRef(String elementRef) {
        this.listdLicenseIds.add(elementRef);
    }

    @Override
    public String documentNamespaceToId(String externalNamespace) {
        return null;
    }

    @Override
    public String externalDocumentIdToNamespace(String docId) {
        return null;
    }

    @Override
    public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
        if (duplicate != null) {
            return duplicate;
        }
        if (uri == null) {
            return this.listedLicenseModel.createResource(this.getType(this.listedLicenseModel));
        }
        return this.listedLicenseModel.createResource(uri, this.getType(this.listedLicenseModel));
    }

    private Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#License");
    }

    @Override
    public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
        return true;
    }
}

