/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.LicenseSheet;

public class LicenseExceptionSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger((String)LicenseSheet.class.getName());
    static final int NUM_COLS = 6;
    static final int COL_NAME = 0;
    static final int COL_ID = 1;
    static final int COL_SOURCE_URL = 2;
    static final int COL_NOTES = 3;
    static final int COL_EXAMPLES = 4;
    static final int COL_TEXT = 5;
    static final boolean[] REQUIRED = new boolean[]{true, true, false, false, true, true};
    static final String[] HEADER_TITLES = new String[]{"Full name of Exception", "Exception Identifier", "Source/url", "Notes", "Example of use", "Exception Text"};

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public LicenseExceptionSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    public void add(LicenseException exception) {
        Row row = this.addRow();
        Cell nameCell = row.createCell(0);
        nameCell.setCellValue(exception.getName());
        Cell idCell = row.createCell(1);
        idCell.setCellValue(exception.getLicenseExceptionId());
        if (exception.getSeeAlso() != null && exception.getSeeAlso().length > 0) {
            Cell sourceUrlCell = row.createCell(2);
            StringBuilder sb = new StringBuilder();
            sb.append(exception.getSeeAlso()[0]);
            for (int i = 1; i < exception.getSeeAlso().length; ++i) {
                sb.append(' ');
                sb.append(exception.getSeeAlso()[i]);
            }
            sourceUrlCell.setCellValue(sb.toString());
        }
        Cell textCell = row.createCell(5);
        String text = exception.getLicenseExceptionText();
        if (text != null) {
            textCell.setCellValue(text);
        }
        String notes = exception.getComment();
        Cell notesCell = row.createCell(3);
        if (notes != null) {
            notesCell.setCellValue(notes);
        }
        String examples = exception.getExample();
        Cell examplesCell = row.createCell(4);
        examplesCell.setCellValue(examples);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for SPDX License Exceptions does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 6; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for SPDX Licenses worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying SPDX License Exception work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 6; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null || !REQUIRED[i]) continue;
            return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
        }
        return null;
    }

    public LicenseException getException(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        String id = null;
        Cell idCell = row.getCell(1);
        if (idCell != null) {
            id = idCell.getStringCellValue();
        }
        String name = null;
        Cell nameCell = row.getCell(0);
        if (nameCell != null) {
            name = nameCell.getStringCellValue();
        }
        String notes = null;
        Cell notesCell = row.getCell(3);
        if (notesCell != null) {
            notes = notesCell.getStringCellValue();
        }
        String[] sourceURL = null;
        Cell sourceURLCell = row.getCell(2);
        if (sourceURLCell != null) {
            try {
                String stSourceURL = sourceURLCell.getStringCellValue();
                sourceURL = stSourceURL.split("\\s");
                for (int i = 0; i < sourceURL.length; ++i) {
                    sourceURL[i] = sourceURL[i].trim();
                }
            }
            catch (Exception ex) {
                sourceURL = new String[]{"Exception getting URL: " + ex.getMessage()};
            }
        }
        String text = null;
        Cell textCell = row.getCell(5);
        if (textCell != null) {
            text = textCell.getStringCellValue();
        }
        String examples = null;
        Cell examplesCell = row.getCell(4);
        if (examplesCell != null) {
            examples = examplesCell.getStringCellValue();
        }
        return new LicenseException(id, name, text, sourceURL, notes, examples);
    }
}

