/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.IOException;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.tools.MarkdownTable;
import org.spdx.tools.licensegenerator.ILicenseFormatWriter;

public class LicenseMarkdownFormatWriter
implements ILicenseFormatWriter {
    private File markdownFile;
    private MarkdownTable markdownTable;

    public LicenseMarkdownFormatWriter(String version, String releaseDate, File markdownFile) {
        this.markdownFile = markdownFile;
        this.markdownTable = new MarkdownTable(version);
    }

    public File getMarkdownFile() {
        return this.markdownFile;
    }

    public void setMarkdownFile(File markdownFile) {
        this.markdownFile = markdownFile;
    }

    @Override
    public void writeLicense(SpdxListedLicense license, boolean deprecated, String deprecatedVersion) throws IOException {
        this.markdownTable.addLicense(license, deprecated);
    }

    @Override
    public void writeToC() throws IOException {
        this.markdownTable.writeToFile(this.markdownFile);
    }

    @Override
    public void writeException(LicenseException exception, boolean deprecated, String deprecatedVersion) throws IOException {
        this.markdownTable.addException(exception, deprecated);
    }
}

