/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.GuardedWrapper;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionWrapper
extends GuardedWrapper {
    protected int scopeIndex;
    protected Wrapper[] wrappers;
    private final ObjectHandler oh;
    protected final Method method;
    protected final Field field;
    protected final Object[] arguments;

    public ReflectionWrapper(int scopeIndex, Wrapper[] wrappers, Predicate<Object[]>[] guard, AccessibleObject method, Object[] arguments, ObjectHandler oh) {
        super(guard);
        this.wrappers = wrappers;
        this.oh = oh;
        if (method instanceof Field) {
            this.method = null;
            this.field = (Field)method;
        } else {
            this.method = (Method)method;
            this.field = null;
        }
        this.arguments = arguments;
        this.scopeIndex = scopeIndex;
    }

    public ReflectionWrapper(ReflectionWrapper rw) {
        this(rw.scopeIndex, rw.wrappers, rw.guard, rw.method == null ? rw.field : rw.method, rw.arguments, rw.oh);
    }

    @Override
    public Object call(Object[] scopes) throws GuardException {
        try {
            this.guardCall(scopes);
            Object scope = this.unwrap(scopes);
            if (scope == null) {
                return null;
            }
            if (this.method == null) {
                return this.field.get(scope);
            }
            return this.method.invoke(scope, this.arguments);
        }
        catch (InvocationTargetException e2) {
            throw new MustacheException("Failed to execute method: " + this.method, e2.getTargetException());
        }
        catch (IllegalAccessException e3) {
            throw new MustacheException("Failed to execute method: " + this.method, e3);
        }
    }

    protected Object unwrap(Object[] scopes) throws GuardException {
        Object scope = this.oh.coerce(scopes[this.scopeIndex]);
        if (this.wrappers != null) {
            for (Wrapper wrapper : this.wrappers) {
                scope = this.oh.coerce(wrapper.call(new Object[]{scope}));
            }
        }
        return scope;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.field == null) {
            sb.append(this.method.toString());
            if (this.arguments != null) {
                for (Object arg : this.arguments) {
                    sb.append(",").append(arg);
                }
            }
        } else {
            sb.append(this.field);
        }
        return sb.toString();
    }
}

