/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah32;

import com.googlecode.javaewah32.BitmapStorage32;
import com.googlecode.javaewah32.EWAHCompressedBitmap32;
import com.googlecode.javaewah32.IteratingBufferedRunningLengthWord32;
import com.googlecode.javaewah32.IteratingRLW32;
import com.googlecode.javaewah32.IteratorAggregation32;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.PriorityQueue;

public final class FastAggregation32 {
    private FastAggregation32() {
    }

    public static EWAHCompressedBitmap32 bufferedand(int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedandWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    /*
     * WARNING - void declaration
     */
    public static void bufferedandWithContainer(BitmapStorage32 container2, int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        void var6_9;
        LinkedList<IteratingBufferedRunningLengthWord32> al = new LinkedList<IteratingBufferedRunningLengthWord32>();
        EWAHCompressedBitmap32[] eWAHCompressedBitmap32Array = bitmaps;
        int n = eWAHCompressedBitmap32Array.length;
        boolean bl = false;
        while (var6_9 < n) {
            EWAHCompressedBitmap32 eWAHCompressedBitmap32 = eWAHCompressedBitmap32Array[var6_9];
            al.add(new IteratingBufferedRunningLengthWord32(eWAHCompressedBitmap32));
            ++var6_9;
        }
        int[] hardbitmap = new int[bufSize * bitmaps.length];
        for (IteratingRLW32 iteratingRLW32 : al) {
            if (iteratingRLW32.size() != 0) continue;
            al.clear();
            break;
        }
        block2: while (!al.isEmpty()) {
            void var6_13;
            Arrays.fill(hardbitmap, -1);
            int effective = Integer.MAX_VALUE;
            for (IteratingRLW32 iteratingRLW32 : al) {
                int eff = IteratorAggregation32.inplaceand(hardbitmap, iteratingRLW32);
                if (eff >= effective) continue;
                effective = eff;
            }
            boolean bl2 = false;
            while (var6_13 < effective) {
                container2.addWord(hardbitmap[var6_13]);
                ++var6_13;
            }
            for (IteratingRLW32 iteratingRLW32 : al) {
                if (iteratingRLW32.size() != 0) continue;
                al.clear();
                continue block2;
            }
        }
    }

    public static EWAHCompressedBitmap32 bufferedor(int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedorWithContainer(BitmapStorage32 container2, int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap32[] sbitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return b.sizeInBits() - a.sizeInBits();
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord32> al = new ArrayList<IteratingBufferedRunningLengthWord32>();
        for (EWAHCompressedBitmap32 bitmap : sbitmaps) {
            if (bitmap.sizeInBits() > range) {
                range = bitmap.sizeInBits();
            }
            al.add(new IteratingBufferedRunningLengthWord32(bitmap));
        }
        int[] hardbitmap = new int[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            int effective = 0;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord32)al.get(k)).size() > 0) {
                    int eff = IteratorAggregation32.inplaceor(hardbitmap, (IteratingRLW32)al.get(k));
                    if (eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            for (k = 0; k < effective; ++k) {
                container2.addWord(hardbitmap[k]);
            }
            Arrays.fill(hardbitmap, 0);
        }
        container2.setSizeInBitsWithinLastWord(range);
    }

    public static EWAHCompressedBitmap32 bufferedxor(int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        EWAHCompressedBitmap32 answer = new EWAHCompressedBitmap32();
        FastAggregation32.bufferedxorWithContainer(answer, bufSize, bitmaps);
        return answer;
    }

    public static void bufferedxorWithContainer(BitmapStorage32 container2, int bufSize, EWAHCompressedBitmap32 ... bitmaps) {
        int range = 0;
        EWAHCompressedBitmap32[] sbitmaps = (EWAHCompressedBitmap32[])bitmaps.clone();
        Arrays.sort(sbitmaps, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return b.sizeInBits() - a.sizeInBits();
            }
        });
        ArrayList<IteratingBufferedRunningLengthWord32> al = new ArrayList<IteratingBufferedRunningLengthWord32>();
        for (EWAHCompressedBitmap32 bitmap : sbitmaps) {
            if (bitmap.sizeInBits() > range) {
                range = bitmap.sizeInBits();
            }
            al.add(new IteratingBufferedRunningLengthWord32(bitmap));
        }
        int[] hardbitmap = new int[bufSize];
        int maxr = al.size();
        while (maxr > 0) {
            int k;
            int effective = 0;
            for (k = 0; k < maxr; ++k) {
                if (((IteratingBufferedRunningLengthWord32)al.get(k)).size() > 0) {
                    int eff = IteratorAggregation32.inplacexor(hardbitmap, (IteratingRLW32)al.get(k));
                    if (eff <= effective) continue;
                    effective = eff;
                    continue;
                }
                maxr = k;
            }
            for (k = 0; k < effective; ++k) {
                container2.addWord(hardbitmap[k]);
            }
            Arrays.fill(hardbitmap, 0);
        }
        container2.setSizeInBitsWithinLastWord(range);
    }

    public static void orToContainer(BitmapStorage32 container2, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        pq.poll().orToContainer(pq.poll(), container2);
    }

    public static EWAHCompressedBitmap32 or(EWAHCompressedBitmap32 ... bitmaps) {
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap32();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap32 xor(EWAHCompressedBitmap32 ... bitmaps) {
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap32();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap32 or(Iterator<EWAHCompressedBitmap32> bitmaps) {
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(32, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add(bitmaps.next());
        }
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap32();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static EWAHCompressedBitmap32 xor(Iterator<EWAHCompressedBitmap32> bitmaps) {
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(32, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        while (bitmaps.hasNext()) {
            pq.add(bitmaps.next());
        }
        if (pq.isEmpty()) {
            return new EWAHCompressedBitmap32();
        }
        while (pq.size() > 1) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    public static void xorToContainer(BitmapStorage32 container2, EWAHCompressedBitmap32 ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("We need at least two bitmaps");
        }
        PriorityQueue<EWAHCompressedBitmap32> pq = new PriorityQueue<EWAHCompressedBitmap32>(bitmaps.length, new Comparator<EWAHCompressedBitmap32>(){

            @Override
            public int compare(EWAHCompressedBitmap32 a, EWAHCompressedBitmap32 b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 2) {
            EWAHCompressedBitmap32 x1 = pq.poll();
            EWAHCompressedBitmap32 x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        pq.poll().xorToContainer(pq.poll(), container2);
    }
}

