/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import antlr.CharScanner;
import antlr.CommonAST;
import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import antlr.collections.ASTEnumeration;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.AttributeRenderer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateWriter;
import org.antlr.stringtemplate.language.ASTExpr;
import org.antlr.stringtemplate.language.ActionLexer;
import org.antlr.stringtemplate.language.ActionParser;
import org.antlr.stringtemplate.language.ConditionalExpr;
import org.antlr.stringtemplate.language.Expr;
import org.antlr.stringtemplate.language.FormalArgument;
import org.antlr.stringtemplate.language.NewlineRef;
import org.antlr.stringtemplate.language.StringTemplateAST;
import org.antlr.stringtemplate.language.TemplateParser;

public class StringTemplate {
    public static final String VERSION = "3.2.1";
    public static final int REGION_IMPLICIT = 1;
    public static final int REGION_EMBEDDED = 2;
    public static final int REGION_EXPLICIT = 3;
    public static final String ANONYMOUS_ST_NAME = "anonymous";
    static boolean lintMode = false;
    protected List referencedAttributes = null;
    protected String name = "anonymous";
    private static int templateCounter = 0;
    protected int templateID = StringTemplate.getNextTemplateCounter();
    protected StringTemplate enclosingInstance = null;
    protected Map argumentContext = null;
    protected StringTemplateAST argumentsAST = null;
    protected LinkedHashMap formalArguments = FormalArgument.UNKNOWN;
    protected int numberOfDefaultArgumentValues = 0;
    protected boolean passThroughAttributes = false;
    protected StringTemplateGroup nativeGroup;
    protected StringTemplateGroup group = defaultGroup;
    protected int groupFileLine;
    StringTemplateErrorListener listener = null;
    protected String pattern;
    protected Map attributes;
    protected Map attributeRenderers;
    protected List chunks;
    protected int regionDefType;
    protected boolean isRegion;
    protected Set regions;
    public static StringTemplateGroup defaultGroup = new StringTemplateGroup("defaultGroup", ".");

    private static synchronized int getNextTemplateCounter() {
        return ++templateCounter;
    }

    public static void resetTemplateCounter() {
        templateCounter = 0;
    }

    public StringTemplate() {
    }

    public StringTemplate(String template) {
        this(null, template);
    }

    public StringTemplate(String template, Class lexer) {
        this();
        this.setGroup(new StringTemplateGroup("defaultGroup", lexer));
        this.setTemplate(template);
    }

    public StringTemplate(StringTemplateGroup group, String template) {
        this();
        if (group != null) {
            this.setGroup(group);
        }
        this.setTemplate(template);
    }

    public StringTemplate(StringTemplateGroup group, String template, HashMap attributes) {
        this(group, template);
        this.attributes = attributes;
    }

    protected void dup(StringTemplate from, StringTemplate to) {
        to.attributeRenderers = from.attributeRenderers;
        to.pattern = from.pattern;
        to.chunks = from.chunks;
        to.formalArguments = from.formalArguments;
        to.numberOfDefaultArgumentValues = from.numberOfDefaultArgumentValues;
        to.name = from.name;
        to.group = from.group;
        to.nativeGroup = from.nativeGroup;
        to.listener = from.listener;
        to.regions = from.regions;
        to.isRegion = from.isRegion;
        to.regionDefType = from.regionDefType;
    }

    public StringTemplate getInstanceOf() {
        StringTemplate t = null;
        t = this.nativeGroup != null ? this.nativeGroup.createStringTemplate() : this.group.createStringTemplate();
        this.dup(this, t);
        return t;
    }

    public StringTemplate getEnclosingInstance() {
        return this.enclosingInstance;
    }

    public StringTemplate getOutermostEnclosingInstance() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostEnclosingInstance();
        }
        return this;
    }

    public void setEnclosingInstance(StringTemplate enclosingInstance) {
        if (this == enclosingInstance) {
            throw new IllegalArgumentException("cannot embed template " + this.getName() + " in itself");
        }
        this.enclosingInstance = enclosingInstance;
    }

    public Map getArgumentContext() {
        return this.argumentContext;
    }

    public void setArgumentContext(Map ac) {
        this.argumentContext = ac;
    }

    public StringTemplateAST getArgumentsAST() {
        return this.argumentsAST;
    }

    public void setArgumentsAST(StringTemplateAST argumentsAST) {
        this.argumentsAST = argumentsAST;
    }

    public String getName() {
        return this.name;
    }

    public String getOutermostName() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getOutermostName();
        }
        return this.getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public StringTemplateGroup getGroup() {
        return this.group;
    }

    public void setGroup(StringTemplateGroup group) {
        this.group = group;
    }

    public StringTemplateGroup getNativeGroup() {
        return this.nativeGroup;
    }

    public void setNativeGroup(StringTemplateGroup nativeGroup) {
        this.nativeGroup = nativeGroup;
    }

    public int getGroupFileLine() {
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getGroupFileLine();
        }
        return this.groupFileLine;
    }

    public void setGroupFileLine(int groupFileLine) {
        this.groupFileLine = groupFileLine;
    }

    public void setTemplate(String template) {
        this.pattern = template;
        this.breakTemplateIntoChunks();
    }

    public String getTemplate() {
        return this.pattern;
    }

    public void setErrorListener(StringTemplateErrorListener listener) {
        this.listener = listener;
    }

    public StringTemplateErrorListener getErrorListener() {
        if (this.listener == null) {
            return this.group.getErrorListener();
        }
        return this.listener;
    }

    public void reset() {
        this.attributes = new HashMap();
    }

    public void setPredefinedAttributes() {
        if (!StringTemplate.inLintMode()) {
            return;
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    public void setAttribute(String name, Object value) {
        if (value == null || name == null) {
            return;
        }
        if (name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in attribute names");
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        if (value instanceof StringTemplate) {
            ((StringTemplate)value).setEnclosingInstance(this);
        } else {
            value = ASTExpr.convertArrayToList(value);
        }
        Object o = this.attributes.get(name);
        if (o == null) {
            this.rawSetAttribute(this.attributes, name, value);
            return;
        }
        STAttributeList v = null;
        if (o.getClass() == STAttributeList.class) {
            v = (STAttributeList)o;
        } else if (o instanceof List) {
            List listAttr = (List)o;
            v = new STAttributeList(listAttr.size());
            v.addAll(listAttr);
            this.rawSetAttribute(this.attributes, name, v);
        } else {
            v = new STAttributeList();
            this.rawSetAttribute(this.attributes, name, v);
            v.add(o);
        }
        if (value instanceof List) {
            if (v != value) {
                v.addAll((List)value);
            }
        } else {
            v.add(value);
        }
    }

    public void setAttribute(String name, int value) {
        this.setAttribute(name, new Integer(value));
    }

    public void setAttribute(String aggrSpec, Object v1, Object v2) {
        this.setAttribute(aggrSpec, new Object[]{v1, v2});
    }

    public void setAttribute(String aggrSpec, Object v1, Object v2, Object v3) {
        this.setAttribute(aggrSpec, new Object[]{v1, v2, v3});
    }

    public void setAttribute(String aggrSpec, Object v1, Object v2, Object v3, Object v4) {
        this.setAttribute(aggrSpec, new Object[]{v1, v2, v3, v4});
    }

    public void setAttribute(String aggrSpec, Object v1, Object v2, Object v3, Object v4, Object v5) {
        this.setAttribute(aggrSpec, new Object[]{v1, v2, v3, v4, v5});
    }

    protected void setAttribute(String aggrSpec, Object[] values) {
        ArrayList properties = new ArrayList();
        String aggrName = this.parseAggregateAttributeSpec(aggrSpec, properties);
        if (values == null || properties.size() == 0) {
            throw new IllegalArgumentException("missing properties or values for '" + aggrSpec + "'");
        }
        if (values.length != properties.size()) {
            throw new IllegalArgumentException("number of properties in '" + aggrSpec + "' != number of values");
        }
        Aggregate aggr = new Aggregate();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            if (value instanceof StringTemplate) {
                ((StringTemplate)value).setEnclosingInstance(this);
            } else {
                value = ASTExpr.convertArrayToList(value);
            }
            aggr.put((String)properties.get(i), value);
        }
        this.setAttribute(aggrName, aggr);
    }

    protected String parseAggregateAttributeSpec(String aggrSpec, List properties) {
        int dot = aggrSpec.indexOf(46);
        if (dot <= 0) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        String aggrName = aggrSpec.substring(0, dot);
        String propString = aggrSpec.substring(dot + 1, aggrSpec.length());
        boolean error = true;
        StringTokenizer tokenizer = new StringTokenizer(propString, "{,}", true);
        if (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if ((token = token.trim()).equals("{")) {
                token = tokenizer.nextToken();
                token = token.trim();
                properties.add(token);
                token = tokenizer.nextToken();
                token = token.trim();
                while (token.equals(",")) {
                    token = tokenizer.nextToken();
                    token = token.trim();
                    properties.add(token);
                    token = tokenizer.nextToken();
                    token = token.trim();
                }
                if (token.equals("}")) {
                    error = false;
                }
            }
        }
        if (error) {
            throw new IllegalArgumentException("invalid aggregate attribute format: " + aggrSpec);
        }
        return aggrName;
    }

    protected void rawSetAttribute(Map attributes, String name, Object value) {
        if (this.formalArguments != FormalArgument.UNKNOWN && this.getFormalArgument(name) == null) {
            throw new NoSuchElementException("no such attribute: " + name + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (value == null) {
            return;
        }
        attributes.put(name, value);
    }

    public void rawSetArgumentAttribute(StringTemplate embedded, Map attributes, String name, Object value) {
        if (embedded.formalArguments != FormalArgument.UNKNOWN && embedded.getFormalArgument(name) == null) {
            throw new NoSuchElementException("template " + embedded.getName() + " has no such attribute: " + name + " in template context " + this.getEnclosingInstanceStackString());
        }
        if (value == null) {
            return;
        }
        attributes.put(name, value);
    }

    public Object getAttribute(String name) {
        Object v = this.get(this, name);
        if (v == null) {
            this.checkNullAttributeAgainstFormalArguments(this, name);
        }
        return v;
    }

    public int write(StringTemplateWriter out) throws IOException {
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStartDebugString(this, out);
        }
        int n = 0;
        boolean missing = true;
        this.setPredefinedAttributes();
        this.setDefaultArgumentValues();
        for (int i = 0; this.chunks != null && i < this.chunks.size(); ++i) {
            Expr a = (Expr)this.chunks.get(i);
            int chunkN = a.write(this, out);
            if (chunkN <= 0 && i == 0 && i + 1 < this.chunks.size() && this.chunks.get(i + 1) instanceof NewlineRef) {
                ++i;
                continue;
            }
            if (chunkN <= 0 && i - 1 >= 0 && this.chunks.get(i - 1) instanceof NewlineRef && i + 1 < this.chunks.size() && this.chunks.get(i + 1) instanceof NewlineRef) {
                ++i;
            }
            if (chunkN == -1) continue;
            n += chunkN;
            missing = false;
        }
        if (this.group.debugTemplateOutput) {
            this.group.emitTemplateStopDebugString(this, out);
        }
        if (lintMode) {
            this.checkForTrouble();
        }
        if (missing && this.chunks != null && this.chunks.size() > 0) {
            return -1;
        }
        return n;
    }

    public Object get(StringTemplate self, String attribute) {
        Map argContext;
        if (self == null) {
            return null;
        }
        if (lintMode) {
            self.trackAttributeReference(attribute);
        }
        Object o = null;
        if (self.attributes != null) {
            o = self.attributes.get(attribute);
        }
        if (o == null && (argContext = self.getArgumentContext()) != null) {
            o = argContext.get(attribute);
        }
        if (o == null && !self.passThroughAttributes && self.getFormalArgument(attribute) != null) {
            return null;
        }
        if (o == null && self.enclosingInstance != null) {
            Object valueFromEnclosing;
            o = valueFromEnclosing = this.get(self.enclosingInstance, attribute);
        } else if (o == null && self.enclosingInstance == null) {
            o = self.group.getMap(attribute);
        }
        return o;
    }

    protected void breakTemplateIntoChunks() {
        if (this.pattern == null) {
            return;
        }
        try {
            Class lexerClass = this.group.getTemplateLexerClass();
            Constructor ctor = lexerClass.getConstructor(StringTemplate.class, Reader.class);
            CharScanner chunkStream = (CharScanner)ctor.newInstance(this, new StringReader(this.pattern));
            chunkStream.setTokenObjectClass("org.antlr.stringtemplate.language.ChunkToken");
            TemplateParser chunkifier = new TemplateParser(chunkStream);
            chunkifier.template(this);
        }
        catch (Exception e2) {
            String name = "<unknown>";
            String outerName = this.getOutermostName();
            if (this.getName() != null) {
                name = this.getName();
            }
            if (outerName != null && !name.equals(outerName)) {
                name = name + " nested in " + outerName;
            }
            this.error("problem parsing template '" + name + "'", e2);
        }
    }

    public ASTExpr parseAction(String action) {
        ActionLexer lexer = new ActionLexer(new StringReader(action.toString()));
        ActionParser parser = new ActionParser((TokenStream)lexer, this);
        parser.setASTNodeClass("org.antlr.stringtemplate.language.StringTemplateAST");
        lexer.setTokenObjectClass("org.antlr.stringtemplate.language.StringTemplateToken");
        ASTExpr a = null;
        try {
            Map options = parser.action();
            AST tree = parser.getAST();
            if (tree != null) {
                a = tree.getType() == 8 ? new ConditionalExpr(this, tree) : new ASTExpr(this, tree, options);
            }
        }
        catch (RecognitionException re) {
            this.error("Can't parse chunk: " + action.toString(), re);
        }
        catch (TokenStreamException tse) {
            this.error("Can't parse chunk: " + action.toString(), tse);
        }
        return a;
    }

    public int getTemplateID() {
        return this.templateID;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public List getChunks() {
        return this.chunks;
    }

    public void addChunk(Expr e2) {
        if (this.chunks == null) {
            this.chunks = new ArrayList();
        }
        this.chunks.add(e2);
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public Map getFormalArguments() {
        return this.formalArguments;
    }

    public void setFormalArguments(LinkedHashMap args) {
        this.formalArguments = args;
    }

    public void setDefaultArgumentValues() {
        if (this.numberOfDefaultArgumentValues == 0) {
            return;
        }
        if (this.argumentContext == null) {
            this.argumentContext = new HashMap();
        }
        if (this.formalArguments != FormalArgument.UNKNOWN) {
            Set argNames = this.formalArguments.keySet();
            Iterator it = argNames.iterator();
            while (it.hasNext()) {
                ASTExpr e2;
                Object a;
                Object existingValue;
                String argName = (String)it.next();
                FormalArgument arg = (FormalArgument)this.formalArguments.get(argName);
                if (arg.defaultValueST == null || (existingValue = this.getAttribute(argName)) != null) continue;
                Object defaultValue = arg.defaultValueST;
                int nchunks = arg.defaultValueST.chunks.size();
                if (nchunks == 1 && (a = arg.defaultValueST.chunks.get(0)) instanceof ASTExpr && (e2 = (ASTExpr)a).getAST().getType() == 9) {
                    defaultValue = e2.evaluateExpression(this, e2.getAST());
                }
                this.argumentContext.put(argName, defaultValue);
            }
        }
    }

    public FormalArgument lookupFormalArgument(String name) {
        FormalArgument arg = this.getFormalArgument(name);
        if (arg == null && this.enclosingInstance != null) {
            arg = this.enclosingInstance.lookupFormalArgument(name);
        }
        return arg;
    }

    public FormalArgument getFormalArgument(String name) {
        return (FormalArgument)this.formalArguments.get(name);
    }

    public void defineEmptyFormalArgumentList() {
        this.setFormalArguments(new LinkedHashMap());
    }

    public void defineFormalArgument(String name) {
        this.defineFormalArgument(name, null);
    }

    public void defineFormalArguments(List names) {
        if (names == null) {
            return;
        }
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.get(i);
            this.defineFormalArgument(name);
        }
    }

    public void defineFormalArgument(String name, StringTemplate defaultValue) {
        if (defaultValue != null) {
            ++this.numberOfDefaultArgumentValues;
        }
        FormalArgument a = new FormalArgument(name, defaultValue);
        if (this.formalArguments == FormalArgument.UNKNOWN) {
            this.formalArguments = new LinkedHashMap();
        }
        this.formalArguments.put(name, a);
    }

    public void setPassThroughAttributes(boolean passThroughAttributes) {
        this.passThroughAttributes = passThroughAttributes;
    }

    public void setAttributeRenderers(Map renderers) {
        this.attributeRenderers = renderers;
    }

    public void registerRenderer(Class attributeClassType, AttributeRenderer renderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = new HashMap();
        }
        this.attributeRenderers.put(attributeClassType, renderer);
    }

    public AttributeRenderer getAttributeRenderer(Class attributeClassType) {
        AttributeRenderer renderer = null;
        if (this.attributeRenderers != null) {
            renderer = (AttributeRenderer)this.attributeRenderers.get(attributeClassType);
        }
        if (renderer != null) {
            return renderer;
        }
        if (this.enclosingInstance != null) {
            return this.enclosingInstance.getAttributeRenderer(attributeClassType);
        }
        return this.group.getAttributeRenderer(attributeClassType);
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void warning(String msg) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().warning(msg);
        } else {
            System.err.println("StringTemplate: warning: " + msg);
        }
    }

    public void error(String msg, Throwable e2) {
        if (this.getErrorListener() != null) {
            this.getErrorListener().error(msg, e2);
        } else if (e2 != null) {
            System.err.println("StringTemplate: error: " + msg + ": " + e2.toString());
            if (e2 instanceof InvocationTargetException) {
                e2 = ((InvocationTargetException)e2).getTargetException();
            }
            e2.printStackTrace(System.err);
        } else {
            System.err.println("StringTemplate: error: " + msg);
        }
    }

    public static void setLintMode(boolean lint) {
        lintMode = lint;
    }

    public static boolean inLintMode() {
        return lintMode;
    }

    protected void trackAttributeReference(String name) {
        if (this.referencedAttributes == null) {
            this.referencedAttributes = new ArrayList();
        }
        this.referencedAttributes.add(name);
    }

    public static boolean isRecursiveEnclosingInstance(StringTemplate st) {
        if (st == null) {
            return false;
        }
        StringTemplate p = st.enclosingInstance;
        if (p == st) {
            return true;
        }
        while (p != null) {
            if (p == st) {
                return true;
            }
            p = p.enclosingInstance;
        }
        return false;
    }

    public String getEnclosingInstanceStackTrace() {
        StringBuffer buf = new StringBuffer();
        HashSet<StringTemplate> seen = new HashSet<StringTemplate>();
        StringTemplate p = this;
        while (p != null) {
            if (seen.contains(p)) {
                buf.append(p.getTemplateDeclaratorString());
                buf.append(" (start of recursive cycle)");
                buf.append("\n");
                buf.append("...");
                break;
            }
            seen.add(p);
            buf.append(p.getTemplateDeclaratorString());
            if (p.attributes != null) {
                buf.append(", attributes=[");
                int i = 0;
                Iterator iter = p.attributes.keySet().iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    if (i > 0) {
                        buf.append(", ");
                    }
                    ++i;
                    buf.append(attrName);
                    Object o = p.attributes.get(attrName);
                    if (o instanceof StringTemplate) {
                        StringTemplate st = (StringTemplate)o;
                        buf.append("=");
                        buf.append("<");
                        buf.append(st.getName());
                        buf.append("()@");
                        buf.append(String.valueOf(st.getTemplateID()));
                        buf.append(">");
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    buf.append("=List[..");
                    List list = (List)o;
                    int n = 0;
                    for (int j = 0; j < list.size(); ++j) {
                        Object listValue = list.get(j);
                        if (!(listValue instanceof StringTemplate)) continue;
                        if (n > 0) {
                            buf.append(", ");
                        }
                        ++n;
                        StringTemplate st = (StringTemplate)listValue;
                        buf.append("<");
                        buf.append(st.getName());
                        buf.append("()@");
                        buf.append(String.valueOf(st.getTemplateID()));
                        buf.append(">");
                    }
                    buf.append("..]");
                }
                buf.append("]");
            }
            if (p.referencedAttributes != null) {
                buf.append(", references=");
                buf.append(p.referencedAttributes);
            }
            buf.append(">\n");
            p = p.enclosingInstance;
        }
        return buf.toString();
    }

    public String getTemplateDeclaratorString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.getName());
        buf.append("(");
        buf.append(this.formalArguments.keySet());
        buf.append(")@");
        buf.append(String.valueOf(this.getTemplateID()));
        buf.append(">");
        return buf.toString();
    }

    protected String getTemplateHeaderString(boolean showAttributes) {
        if (showAttributes) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getName());
            if (this.attributes != null) {
                buf.append(this.attributes.keySet());
            }
            return buf.toString();
        }
        return this.getName();
    }

    protected void checkNullAttributeAgainstFormalArguments(StringTemplate self, String attribute) {
        if (self.getFormalArguments() == FormalArgument.UNKNOWN) {
            if (self.enclosingInstance != null) {
                this.checkNullAttributeAgainstFormalArguments(self.enclosingInstance, attribute);
            }
            return;
        }
        FormalArgument formalArg = self.lookupFormalArgument(attribute);
        if (formalArg == null) {
            throw new NoSuchElementException("no such attribute: " + attribute + " in template context " + this.getEnclosingInstanceStackString());
        }
    }

    protected void checkForTrouble() {
        if (this.attributes == null) {
            return;
        }
        Set names = this.attributes.keySet();
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (this.referencedAttributes == null || this.referencedAttributes.contains(name)) continue;
            this.warning(this.getName() + ": set but not used: " + name);
        }
    }

    public String getEnclosingInstanceStackString() {
        LinkedList<String> names = new LinkedList<String>();
        StringTemplate p = this;
        while (p != null) {
            String name = p.getName();
            names.add(0, name + (p.passThroughAttributes ? "(...)" : ""));
            p = p.enclosingInstance;
        }
        return ((Object)names).toString().replaceAll(",", "");
    }

    public boolean isRegion() {
        return this.isRegion;
    }

    public void setIsRegion(boolean isRegion) {
        this.isRegion = isRegion;
    }

    public void addRegionName(String name) {
        if (this.regions == null) {
            this.regions = new HashSet();
        }
        this.regions.add(name);
    }

    public boolean containsRegionName(String name) {
        if (this.regions == null) {
            return false;
        }
        return this.regions.contains(name);
    }

    public int getRegionDefType() {
        return this.regionDefType;
    }

    public void setRegionDefType(int regionDefType) {
        this.regionDefType = regionDefType;
    }

    public String toDebugString() {
        StringBuffer buf = new StringBuffer();
        buf.append("template-" + this.getTemplateDeclaratorString() + ":");
        buf.append("chunks=");
        if (this.chunks != null) {
            buf.append(this.chunks.toString());
        }
        buf.append("attributes=[");
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            int n = 0;
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                if (n > 0) {
                    buf.append(',');
                }
                String name = (String)iter.next();
                buf.append(name + "=");
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    buf.append(((StringTemplate)value).toDebugString());
                } else {
                    buf.append(value);
                }
                ++n;
            }
            buf.append("]");
        }
        return buf.toString();
    }

    public String toStructureString() {
        return this.toStructureString(0);
    }

    public String toStructureString(int indent) {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i <= indent; ++i) {
            buf.append("  ");
        }
        buf.append(this.getName());
        buf.append(this.attributes.keySet());
        buf.append(":\n");
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    buf.append(((StringTemplate)value).toStructureString(indent + 1));
                    continue;
                }
                if (value instanceof List) {
                    List alist = (List)value;
                    for (int i = 0; i < alist.size(); ++i) {
                        Object o = alist.get(i);
                        if (!(o instanceof StringTemplate)) continue;
                        buf.append(((StringTemplate)o).toStructureString(indent + 1));
                    }
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map m = (Map)value;
                Collection mvalues = m.values();
                Iterator iterator = mvalues.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!(o instanceof StringTemplate)) continue;
                    buf.append(((StringTemplate)o).toStructureString(indent + 1));
                }
            }
        }
        return buf.toString();
    }

    public StringTemplate getDOTForDependencyGraph(boolean showAttributes) {
        String structure = "digraph StringTemplateDependencyGraph {\nnode [shape=$shape$, $if(width)$width=$width$,$endif$      $if(height)$height=$height$,$endif$ fontsize=$fontsize$];\n$edges:{e|\"$e.src$\" -> \"$e.trg$\"\n}$}\n";
        StringTemplate graphST = new StringTemplate(structure);
        HashMap edges = new HashMap();
        this.getDependencyGraph(edges, showAttributes);
        Set sourceNodes = edges.keySet();
        Iterator it = sourceNodes.iterator();
        while (it.hasNext()) {
            String src = (String)it.next();
            Set targetNodes = (Set)edges.get(src);
            Iterator it2 = targetNodes.iterator();
            while (it2.hasNext()) {
                String trg = (String)it2.next();
                graphST.setAttribute("edges.{src,trg}", src, trg);
            }
        }
        graphST.setAttribute("shape", "none");
        graphST.setAttribute("fontsize", "11");
        graphST.setAttribute("height", "0");
        return graphST;
    }

    public void getDependencyGraph(Map edges, boolean showAttributes) {
        String srcNode = this.getTemplateHeaderString(showAttributes);
        if (this.attributes != null) {
            Set attrNames = this.attributes.keySet();
            Iterator iter = attrNames.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Object value = this.attributes.get(name);
                if (value instanceof StringTemplate) {
                    String targetNode = ((StringTemplate)value).getTemplateHeaderString(showAttributes);
                    this.putToMultiValuedMap(edges, srcNode, targetNode);
                    ((StringTemplate)value).getDependencyGraph(edges, showAttributes);
                    continue;
                }
                if (value instanceof List) {
                    List alist = (List)value;
                    for (int i = 0; i < alist.size(); ++i) {
                        Object o = alist.get(i);
                        if (!(o instanceof StringTemplate)) continue;
                        String targetNode = ((StringTemplate)o).getTemplateHeaderString(showAttributes);
                        this.putToMultiValuedMap(edges, srcNode, targetNode);
                        ((StringTemplate)o).getDependencyGraph(edges, showAttributes);
                    }
                    continue;
                }
                if (!(value instanceof Map)) continue;
                Map m = (Map)value;
                Collection mvalues = m.values();
                Iterator iterator = mvalues.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (!(o instanceof StringTemplate)) continue;
                    String targetNode = ((StringTemplate)o).getTemplateHeaderString(showAttributes);
                    this.putToMultiValuedMap(edges, srcNode, targetNode);
                    ((StringTemplate)o).getDependencyGraph(edges, showAttributes);
                }
            }
        }
        for (int i = 0; this.chunks != null && i < this.chunks.size(); ++i) {
            Expr expr = (Expr)this.chunks.get(i);
            if (!(expr instanceof ASTExpr)) continue;
            ASTExpr e2 = (ASTExpr)expr;
            AST tree = e2.getAST();
            CommonAST includeAST = new CommonAST(new CommonToken(7, "include"));
            ASTEnumeration it = tree.findAllPartial(includeAST);
            while (it.hasMoreNodes()) {
                AST t = it.nextNode();
                String templateInclude = t.getFirstChild().getText();
                System.out.println("found include " + templateInclude);
                this.putToMultiValuedMap(edges, srcNode, templateInclude);
                StringTemplateGroup group = this.getGroup();
                if (group == null) continue;
                StringTemplate st = group.getInstanceOf(templateInclude);
                st.getDependencyGraph(edges, showAttributes);
            }
        }
    }

    protected void putToMultiValuedMap(Map map, Object key, Object value) {
        HashSet<Object> bag2 = (HashSet<Object>)map.get(key);
        if (bag2 == null) {
            bag2 = new HashSet<Object>();
            map.put(key, bag2);
        }
        bag2.add(value);
    }

    public void printDebugString() {
        System.out.println("template-" + this.getName() + ":");
        System.out.print("chunks=");
        System.out.println(this.chunks.toString());
        if (this.attributes == null) {
            return;
        }
        System.out.print("attributes=[");
        Set attrNames = this.attributes.keySet();
        int n = 0;
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String name;
            Object value;
            if (n > 0) {
                System.out.print(',');
            }
            if ((value = this.attributes.get(name = (String)iter.next())) instanceof StringTemplate) {
                System.out.print(name + "=");
                ((StringTemplate)value).printDebugString();
            } else if (value instanceof List) {
                ArrayList alist = (ArrayList)value;
                for (int i = 0; i < alist.size(); ++i) {
                    Object o = alist.get(i);
                    System.out.print(name + "[" + i + "] is " + o.getClass().getName() + "=");
                    if (o instanceof StringTemplate) {
                        ((StringTemplate)o).printDebugString();
                        continue;
                    }
                    System.out.println(o);
                }
            } else {
                System.out.print(name + "=");
                System.out.println(value);
            }
            ++n;
        }
        System.out.print("]\n");
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int lineWidth) {
        StringWriter out = new StringWriter();
        StringTemplateWriter wr = this.group.getStringTemplateWriter(out);
        wr.setLineWidth(lineWidth);
        try {
            this.write(wr);
        }
        catch (IOException io) {
            this.error("Got IOException writing to writer " + wr.getClass().getName());
        }
        wr.setLineWidth(-1);
        return out.toString();
    }

    public static final class STAttributeList
    extends ArrayList {
        public STAttributeList(int size) {
            super(size);
        }

        public STAttributeList() {
        }
    }

    public static final class Aggregate {
        protected HashMap properties = new HashMap();

        protected void put(String propName, Object propValue) {
            this.properties.put(propName, propValue);
        }

        public Object get(String propName) {
            return this.properties.get(propName);
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

