/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.lang.BlankNodeAllocator;
import org.apache.jena.riot.lang.BlankNodeAllocatorFixedSeedHash;
import org.apache.jena.riot.lang.BlankNodeAllocatorHash;
import org.apache.jena.riot.lang.BlankNodeAllocatorLabel;
import org.apache.jena.riot.lang.BlankNodeAllocatorLabelEncoded;
import org.apache.jena.riot.lang.BlankNodeAllocatorTraditional;
import org.apache.jena.riot.system.MapWithScope;

public class LabelToNode
extends MapWithScope<String, Node, Node> {
    public static LabelToNode createScopeByDocumentHash() {
        return new LabelToNode(new AllocScopePolicy(), LabelToNode.nodeAllocatorHash());
    }

    public static LabelToNode createScopeByDocumentHash(UUID seed) {
        return new LabelToNode(new AllocScopePolicy(), LabelToNode.nodeAllocatorHash(seed));
    }

    public static LabelToNode createScopeByDocumentOld() {
        return new LabelToNode(new SingleScopePolicy(), LabelToNode.nodeAllocatorTraditional());
    }

    public static LabelToNode createScopeByGraph() {
        return new LabelToNode(new GraphScopePolicy(), LabelToNode.nodeAllocatorByGraph());
    }

    public static LabelToNode createUseLabelAsGiven() {
        return new LabelToNode(new AllocScopePolicy(), LabelToNode.nodeAllocatorRawLabel());
    }

    public static LabelToNode createUseLabelEncoded() {
        return new LabelToNode(new AllocScopePolicy(), LabelToNode.nodeAllocatorEncoded());
    }

    public static LabelToNode createIncremental() {
        return new LabelToNode(new SingleScopePolicy(), LabelToNode.nodeAllocatorDeterministic());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorHash() {
        return new Alloc(new BlankNodeAllocatorHash());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorHash(UUID seed) {
        return new Alloc(new BlankNodeAllocatorFixedSeedHash(seed));
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorDeterministic() {
        return new Alloc(new BlankNodeAllocatorLabel());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorTraditional() {
        return new Alloc(new BlankNodeAllocatorTraditional());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorEncoded() {
        return new Alloc(new BlankNodeAllocatorLabelEncoded());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorRawLabel() {
        return new Alloc(new BlankNodeAllocatorLabel());
    }

    private static MapWithScope.Allocator<String, Node, Node> nodeAllocatorByGraph() {
        return new AllocByGraph();
    }

    public LabelToNode(MapWithScope.ScopePolicy<String, Node, Node> scopePolicy, MapWithScope.Allocator<String, Node, Node> allocator) {
        super(scopePolicy, allocator);
    }

    private static class AllocByGraph
    implements MapWithScope.Allocator<String, Node, Node> {
        BlankNodeAllocator dft = this.make();
        Map<Node, BlankNodeAllocator> graphs = new HashMap<Node, BlankNodeAllocator>();

        private AllocByGraph() {
        }

        @Override
        public Node alloc(Node scope, String label) {
            if (scope == null) {
                return this.dft.alloc(label);
            }
            BlankNodeAllocator alloc = this.graphs.get(scope);
            if (alloc == null) {
                alloc = this.make();
                this.graphs.put(scope, alloc);
            }
            return alloc.alloc(label);
        }

        @Override
        public Node create() {
            return this.dft.create();
        }

        @Override
        public void reset() {
            this.graphs.clear();
            this.dft.reset();
        }

        private BlankNodeAllocator make() {
            return new BlankNodeAllocatorHash();
        }
    }

    private static class Alloc
    implements MapWithScope.Allocator<String, Node, Node> {
        final BlankNodeAllocator alloc;

        Alloc(BlankNodeAllocator alloc) {
            this.alloc = alloc;
        }

        @Override
        public Node alloc(Node scope, String label) {
            return this.alloc.alloc(label);
        }

        @Override
        public Node create() {
            return this.alloc.create();
        }

        @Override
        public void reset() {
            this.alloc.reset();
        }
    }

    private static class AllocScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private AllocScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return null;
        }

        @Override
        public void clear() {
        }
    }

    private static class GraphScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> dftMap = new HashMap<String, Node>();
        private Map<Node, Map<String, Node>> map = new HashMap<Node, Map<String, Node>>();

        private GraphScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            if (scope == null) {
                return this.dftMap;
            }
            Map<String, Node> x = this.map.get(scope);
            if (x == null) {
                x = new HashMap<String, Node>();
                this.map.put(scope, x);
            }
            return x;
        }

        @Override
        public void clear() {
            this.dftMap.clear();
            this.map.clear();
        }
    }

    private static class SingleScopePolicy
    implements MapWithScope.ScopePolicy<String, Node, Node> {
        private Map<String, Node> map = new HashMap<String, Node>();

        private SingleScopePolicy() {
        }

        @Override
        public Map<String, Node> getScope(Node scope) {
            return this.map;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

