/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.apache.jena.iri.impl.PatternCompiler;
import org.apache.jena.riot.RiotException;

public abstract class IRIResolver {
    public static final IRIFactory iriFactory;
    private static boolean showExceptions;
    private static final boolean ShowResolverSetup = false;
    private static String globalBase;
    private static IRIResolver globalResolver;
    private static final int CacheSize = 1000;

    private static void setErrorWarning(IRIFactory factory, int code, boolean isError, boolean isWarning) {
        factory.setIsError(code, isError);
        factory.setIsWarning(code, isWarning);
    }

    private static void printSetting(IRIFactory factory) {
        PrintStream ps = System.out;
        IRIResolver.printErrorWarning(ps, iriFactory, 44);
        IRIResolver.printErrorWarning(ps, iriFactory, 46);
        IRIResolver.printErrorWarning(ps, iriFactory, 47);
        IRIResolver.printErrorWarning(ps, iriFactory, 4);
        IRIResolver.printErrorWarning(ps, iriFactory, 49);
        IRIResolver.printErrorWarning(ps, iriFactory, 56);
        IRIResolver.printErrorWarning(ps, iriFactory, 11);
        IRIResolver.printErrorWarning(ps, iriFactory, 1);
        IRIResolver.printErrorWarning(ps, iriFactory, 61);
        ps.println();
    }

    private static void printErrorWarning(PrintStream ps, IRIFactory factory, int code) {
        String x = PatternCompiler.errorCodeName(code);
        ps.printf("%-40s : E:%-5s W:%-5s\n", x, factory.isError(code), factory.isWarning(code));
    }

    public static boolean checkIRI(String iriStr) {
        IRI iri = IRIResolver.parseIRI(iriStr);
        return iri.hasViolation(false);
    }

    public static void validateIRI(String iriStr) throws IRIException {
        IRIResolver.parseIRIex(iriStr);
    }

    public static IRI parseIRI(String iriStr) {
        return iriFactory.create(iriStr);
    }

    public static IRI parseIRIex(String iriStr) throws IRIException {
        return iriFactory.construct(iriStr);
    }

    public static String resolveFileURL(String filename) throws IRIException {
        IRI r = globalResolver.resolve(filename);
        if (!r.getScheme().equalsIgnoreCase("file")) {
            return IRIResolver.resolveFileURL("./" + filename);
        }
        return r.toString();
    }

    public static IRI resolve(String relStr, String baseStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr, baseStr));
    }

    public static String resolveString(String relStr, String baseStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(relStr, baseStr)).toString();
    }

    public static String resolveString(String uriStr) throws RiotException {
        return IRIResolver.exceptions(IRIResolver.resolveIRI(uriStr)).toString();
    }

    public static String resolveStringSilent(String uriStr) throws RiotException {
        return globalResolver.resolveSilent(uriStr).toString();
    }

    public static IRI resolveIRI(String uriStr) {
        return IRIResolver.exceptions(globalResolver.resolve(uriStr));
    }

    private static IRI resolveIRI(String relStr, String baseStr) {
        IRI i = iriFactory.create(relStr);
        if (i.isAbsolute()) {
            return globalResolver.getBaseIRI().create(i);
        }
        IRI base = iriFactory.create(baseStr);
        if ("file".equalsIgnoreCase(base.getScheme())) {
            return globalResolver.getBaseIRI().create(i);
        }
        return base.create(i);
    }

    public static IRIResolver create() {
        return new IRIResolverNormal();
    }

    public static IRIResolver create(String baseStr) {
        return new IRIResolverNormal(baseStr);
    }

    public static IRIResolver create(IRI baseIRI) {
        return new IRIResolverNormal(baseIRI);
    }

    public static IRIResolver createNoResolve() {
        return new IRIResolverNoOp();
    }

    public static void suppressExceptions() {
        showExceptions = false;
    }

    public static IRI chooseBaseURI() {
        return globalResolver.getBaseIRI();
    }

    public String getBaseIRIasString() {
        IRI iri = this.getBaseIRI();
        if (iri == null) {
            return null;
        }
        return iri.toString();
    }

    protected abstract IRI getBaseIRI();

    public IRI resolve(String uriStr) {
        return IRIResolver.exceptions(this.resolveSilent(uriStr));
    }

    public abstract IRI resolveSilent(String var1);

    public String resolveToString(String uriStr) {
        return this.resolve(uriStr).toString();
    }

    public String resolveToStringSilent(String uriStr) {
        return this.resolveSilent(uriStr).toString();
    }

    protected IRIResolver() {
    }

    private static IRI exceptions(IRI iri) {
        if (!showExceptions) {
            return iri;
        }
        if (!iri.hasViolation(false)) {
            return iri;
        }
        String msg = iri.violations(false).next().getShortMessage();
        throw new RiotException(msg);
    }

    static {
        IRI cwd;
        iriFactory = new IRIFactory();
        showExceptions = true;
        iriFactory.useSpecificationIRI(true);
        iriFactory.useSchemeSpecificRules("*", true);
        iriFactory.setSameSchemeRelativeReferences("file");
        IRIResolver.setErrorWarning(iriFactory, 44, false, false);
        IRIResolver.setErrorWarning(iriFactory, 49, false, false);
        globalBase = IRILib.filenameToIRI("./");
        try {
            cwd = iriFactory.construct(globalBase);
        }
        catch (IRIException e2) {
            System.err.println("Unexpected IRIException in initializer: " + e2.getMessage());
            cwd = iriFactory.create("file:///");
            e2.printStackTrace(System.err);
        }
        globalResolver = new IRIResolverSync(IRIResolver.create(cwd));
    }

    static class IRIResolverSync
    extends IRIResolver {
        private final IRIResolver other;

        IRIResolverSync(IRIResolver other) {
            this.other = other;
        }

        @Override
        protected synchronized IRI getBaseIRI() {
            return this.other.getBaseIRI();
        }

        @Override
        public synchronized IRI resolve(String uriStr) {
            return this.other.resolve(uriStr);
        }

        @Override
        public synchronized IRI resolveSilent(String uriStr) {
            return this.other.resolveSilent(uriStr);
        }
    }

    static class IRIResolverNormal
    extends IRIResolver {
        private final IRI base;
        private Cache<String, IRI> resolvedIRIs = CacheFactory.createCache(1000);

        public IRIResolverNormal() {
            this((String)null);
        }

        public IRIResolverNormal(String baseStr) {
            this.base = baseStr == null ? IRIResolverNormal.chooseBaseURI() : globalResolver.resolveSilent(baseStr);
        }

        public IRIResolverNormal(IRI baseIRI) {
            if (baseIRI == null) {
                baseIRI = IRIResolverNormal.chooseBaseURI();
            }
            this.base = baseIRI;
        }

        @Override
        protected IRI getBaseIRI() {
            return this.base;
        }

        @Override
        public IRI resolveSilent(String uriStr) {
            if (this.resolvedIRIs == null) {
                return this.resolveSilentNoCache(uriStr);
            }
            return this.resolveSilentCache(uriStr);
        }

        private IRI resolveSilentNoCache(String uriStr) {
            IRI x = iriFactory.create(uriStr);
            return this.base.create(x);
        }

        private IRI resolveSilentCache(String uriStr) {
            Callable<IRI> filler = () -> this.resolveSilentNoCache(uriStr);
            return this.resolvedIRIs.getOrFill(uriStr, filler);
        }
    }

    static class IRIResolverNoOp
    extends IRIResolver {
        private Cache<String, IRI> resolvedIRIs = CacheFactory.createCache(1000);

        protected IRIResolverNoOp() {
        }

        @Override
        protected IRI getBaseIRI() {
            return null;
        }

        @Override
        public IRI resolveSilent(String uriStr) {
            if (this.resolvedIRIs == null) {
                return iriFactory.create(uriStr);
            }
            Callable<IRI> filler = () -> iriFactory.create(uriStr);
            IRI iri = this.resolvedIRIs.getOrFill(uriStr, filler);
            return iri;
        }

        @Override
        public String resolveToString(String uriStr) {
            return uriStr;
        }
    }
}

