/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.setup;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderLib;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.sse.SSEParseException;
import org.apache.jena.tdb.TDB;
import org.apache.jena.tdb.TDBException;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.file.BufferChannel;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.index.BuilderStdIndex;
import org.apache.jena.tdb.index.IndexParams;
import org.apache.jena.tdb.lib.ColumnMap;
import org.apache.jena.tdb.setup.BlockMgrBuilder;
import org.apache.jena.tdb.setup.Build;
import org.apache.jena.tdb.setup.BuilderStdDB;
import org.apache.jena.tdb.setup.DatasetBuilder;
import org.apache.jena.tdb.setup.NodeTableBuilder;
import org.apache.jena.tdb.setup.StoreParams;
import org.apache.jena.tdb.setup.StoreParamsBuilder;
import org.apache.jena.tdb.setup.StoreParamsCodec;
import org.apache.jena.tdb.setup.TupleIndexBuilder;
import org.apache.jena.tdb.solver.OpExecutorTDB1;
import org.apache.jena.tdb.store.DatasetGraphTDB;
import org.apache.jena.tdb.store.DatasetPrefixesTDB;
import org.apache.jena.tdb.store.QuadTable;
import org.apache.jena.tdb.store.StorageConfig;
import org.apache.jena.tdb.store.TripleTable;
import org.apache.jena.tdb.store.nodetable.NodeTable;
import org.apache.jena.tdb.store.nodetupletable.NodeTupleTableConcrete;
import org.apache.jena.tdb.store.tupletable.TupleIndex;
import org.apache.jena.tdb.sys.DatasetControl;
import org.apache.jena.tdb.sys.DatasetControlMRSW;
import org.apache.jena.tdb.sys.FileRef;
import org.apache.jena.tdb.sys.SystemTDB;
import org.apache.jena.tdb.sys.TDBInternal;
import org.slf4j.Logger;

public class DatasetBuilderStd
implements DatasetBuilder {
    private static final Logger log = TDB.logInfo;
    private NodeTableBuilder nodeTableBuilder;
    private TupleIndexBuilder tupleIndexBuilder;
    private Recorder recorder = null;
    private static String DB_CONFIG_FILE = "tdb.cfg";
    private static boolean warnAboutOptimizer = true;

    public static DatasetGraphTDB create(Location location) {
        return DatasetBuilderStd.create(location, null);
    }

    public static DatasetGraphTDB create(Location location, StoreParams appParams) {
        StoreParams locParams = StoreParamsCodec.read(location);
        StoreParams dftParams = StoreParams.getDftStoreParams();
        boolean newArea = TDBInternal.isNewDatabaseArea(location);
        StoreParams params = Build.decideStoreParams(location, newArea, appParams, locParams, dftParams);
        DatasetBuilderStd x = new DatasetBuilderStd();
        x.standardSetup();
        DatasetGraphTDB dsg = x.build(location, params);
        return dsg;
    }

    public static DatasetGraphTDB create(StoreParams params) {
        return DatasetBuilderStd.create(Location.mem(), params);
    }

    public static DatasetBuilderStd stdBuilder() {
        DatasetBuilderStd x = new DatasetBuilderStd();
        x.standardSetup();
        return x;
    }

    protected DatasetBuilderStd() {
    }

    public DatasetBuilderStd(BlockMgrBuilder blockMgrBuilder, NodeTableBuilder nodeTableBuilder) {
        this.set(blockMgrBuilder, nodeTableBuilder);
    }

    protected void set(NodeTableBuilder nodeTableBuilder, TupleIndexBuilder tupleIndexBuilder) {
        this.nodeTableBuilder = nodeTableBuilder;
        this.tupleIndexBuilder = tupleIndexBuilder;
    }

    protected void set(BlockMgrBuilder blockMgrBuilder, NodeTableBuilder nodeTableBuilder) {
        this.recorder = new Recorder();
        BlockMgrBuilderRecorder blockMgrBuilderRec = new BlockMgrBuilderRecorder(blockMgrBuilder, this.recorder);
        BuilderStdIndex.IndexBuilderStd indexBuilder = new BuilderStdIndex.IndexBuilderStd(blockMgrBuilderRec, blockMgrBuilderRec);
        BuilderStdIndex.RangeIndexBuilderStd rangeIndexBuilder = new BuilderStdIndex.RangeIndexBuilderStd(blockMgrBuilderRec, blockMgrBuilderRec);
        this.nodeTableBuilder = nodeTableBuilder;
        nodeTableBuilder = new NodeTableBuilderRecorder(nodeTableBuilder, this.recorder);
        BuilderStdDB.TupleIndexBuilderStd tupleIndexBuilder = new BuilderStdDB.TupleIndexBuilderStd(rangeIndexBuilder);
        this.set(nodeTableBuilder, tupleIndexBuilder);
    }

    private static void checkLocation(Location location) {
        if (location.isMem()) {
            return;
        }
        String dirname = location.getDirectoryPath();
        File dir = new File(dirname);
        if (!dir.exists()) {
            DatasetBuilderStd.error(log, "Does not exist: " + dirname);
        }
        if (!dir.isDirectory()) {
            DatasetBuilderStd.error(log, "Not a directory: " + dirname);
        }
        if (!dir.canRead()) {
            DatasetBuilderStd.error(log, "Directory not readable: " + dirname);
        }
        if (!dir.canWrite()) {
            DatasetBuilderStd.error(log, "Directory not writeable: " + dirname);
        }
    }

    private void standardSetup() {
        BuilderStdDB.ObjectFileBuilderStd objectFileBuilder = new BuilderStdDB.ObjectFileBuilderStd();
        BuilderStdIndex.BlockMgrBuilderStd blockMgrBuilder = new BuilderStdIndex.BlockMgrBuilderStd();
        BuilderStdIndex.IndexBuilderStd indexBuilderNT = new BuilderStdIndex.IndexBuilderStd(blockMgrBuilder, blockMgrBuilder);
        BuilderStdDB.NodeTableBuilderStd nodeTableBuilder = new BuilderStdDB.NodeTableBuilderStd(indexBuilderNT, objectFileBuilder);
        this.set(blockMgrBuilder, nodeTableBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatasetGraphTDB build(Location location, StoreParams params) {
        Class<DatasetBuilderStd> clazz = DatasetBuilderStd.class;
        synchronized (DatasetBuilderStd.class) {
            log.debug("Build database: " + location.getDirectoryPath());
            DatasetBuilderStd.checkLocation(location);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this._build(location, params, true, null);
        }
    }

    public DatasetGraphTDB _build(Location location, StoreParams params, boolean writeable, ReorderTransformation _transform) {
        return this.buildWorker(location, writeable, _transform, params);
    }

    private synchronized DatasetGraphTDB buildWorker(Location location, boolean writeable, ReorderTransformation _transform, StoreParams params) {
        this.recorder.start();
        DatasetControl policy = this.createConcurrencyPolicy();
        NodeTable nodeTable = this.makeNodeTable(location, params);
        TripleTable tripleTable = this.makeTripleTable(location, nodeTable, policy, params);
        QuadTable quadTable = this.makeQuadTable(location, nodeTable, policy, params);
        DatasetPrefixesTDB prefixes = this.makePrefixTable(location, policy, params);
        ReorderTransformation transform = _transform == null ? this.chooseReorderTransformation(location) : _transform;
        StorageConfig storageConfig = new StorageConfig(location, params, writeable, this.recorder.blockMgrs, this.recorder.bufferChannels, this.recorder.nodeTables);
        this.recorder.finish();
        DatasetGraphTDB dsg = new DatasetGraphTDB(tripleTable, quadTable, prefixes, transform, storageConfig);
        dsg.getContext().set(ARQ.optFilterPlacementBGP, false);
        QC.setFactory(dsg.getContext(), OpExecutorTDB1.OpExecFactoryTDB);
        return dsg;
    }

    private static <X, Y> Map<X, Y> freeze(Map<X, Y> map) {
        return Collections.unmodifiableMap(new HashMap<X, Y>(map));
    }

    protected DatasetControl createConcurrencyPolicy() {
        return new DatasetControlMRSW();
    }

    protected TripleTable makeTripleTable(Location location, NodeTable nodeTable, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexTriples();
        String[] indexes = params.getTripleIndexes();
        log.debug("Triple table: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(location, primary, indexes, params);
        if (tripleIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable, policy);
        return tripleTable;
    }

    protected QuadTable makeQuadTable(Location location, NodeTable nodeTable, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexQuads();
        String[] indexes = params.getQuadIndexes();
        log.debug("Quad table: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        TupleIndex[] quadIndexes = this.makeTupleIndexes(location, primary, indexes, params);
        if (quadIndexes.length != indexes.length) {
            DatasetBuilderStd.error(log, "Wrong number of quad table tuples indexes: " + quadIndexes.length);
        }
        QuadTable quadTable = new QuadTable(quadIndexes, nodeTable, policy);
        return quadTable;
    }

    protected DatasetPrefixesTDB makePrefixTable(Location location, DatasetControl policy, StoreParams params) {
        String primary = params.getPrimaryIndexPrefix();
        String[] indexes = params.getPrefixIndexes();
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(location, primary, indexes, new String[]{params.getIndexPrefix()}, params);
        if (prefixIndexes.length != 1) {
            DatasetBuilderStd.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        String pnNode2Id = params.getPrefixNode2Id();
        String pnId2Node = params.getPrefixId2Node();
        NodeTable prefixNodes = this.makeNodeTableNoCache(location, pnNode2Id, pnId2Node, params);
        NodeTupleTableConcrete prefixTable = new NodeTupleTableConcrete(primary.length(), prefixIndexes, prefixNodes, policy);
        DatasetPrefixesTDB prefixes = new DatasetPrefixesTDB(prefixTable);
        log.debug("Prefixes: " + primary + " :: " + StrUtils.strjoin(",", indexes));
        return prefixes;
    }

    protected ReorderTransformation chooseReorderTransformation(Location location) {
        return DatasetBuilderStd.chooseOptimizer(location);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, StoreParams params) {
        return this.makeTupleIndexes(location, primary, indexNames, indexNames, params);
    }

    private TupleIndex[] makeTupleIndexes(Location location, String primary, String[] indexNames, String[] filenames, StoreParams params) {
        if (primary.length() != 3 && primary.length() != 4) {
            DatasetBuilderStd.error(log, "Bad primary key length: " + primary.length());
        }
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = this.makeTupleIndex(location, filenames[i], primary, indexNames[i], params);
        }
        return indexes;
    }

    protected TupleIndex makeTupleIndex(Location location, String name, String primary, String indexOrder, StoreParams params) {
        FileSet fs = new FileSet(location, name);
        ColumnMap colMap = new ColumnMap(primary, indexOrder);
        return this.tupleIndexBuilder.buildTupleIndex(fs, colMap, indexOrder, params);
    }

    public NodeTable makeNodeTable(Location location, StoreParams params) {
        FileSet fsNodeToId = new FileSet(location, params.getIndexNode2Id());
        FileSet fsId2Node = new FileSet(location, params.getIndexId2Node());
        NodeTable nt = this.nodeTableBuilder.buildNodeTable(fsNodeToId, fsId2Node, params);
        return nt;
    }

    private NodeTable makeNodeTable$(Location location, String indexNode2Id, String indexId2Node, StoreParams params) {
        FileSet fsNodeToId = new FileSet(location, indexNode2Id);
        FileSet fsId2Node = new FileSet(location, indexId2Node);
        NodeTable nt = this.nodeTableBuilder.buildNodeTable(fsNodeToId, fsId2Node, params);
        return nt;
    }

    protected NodeTable makeNodeTableNoCache(Location location, String indexNode2Id, String indexId2Node, StoreParams params) {
        StoreParamsBuilder spb = StoreParams.builder(params).node2NodeIdCacheSize(-1).nodeId2NodeCacheSize(-1).nodeMissCacheSize(-1);
        return this.makeNodeTable$(location, indexNode2Id, indexId2Node, spb.build());
    }

    private static void error(Logger log2, String msg) {
        if (log2 != null) {
            log2.error(msg);
        }
        throw new TDBException(msg);
    }

    private static int parseInt(String str2, String messageBase) {
        try {
            return Integer.parseInt(str2);
        }
        catch (NumberFormatException ex) {
            DatasetBuilderStd.error(log, messageBase + ": " + str2);
            return -1;
        }
    }

    public static void setOptimizerWarningFlag(boolean b) {
        warnAboutOptimizer = b;
    }

    public static ReorderTransformation chooseOptimizer(Location location) {
        if (location == null) {
            return ReorderLib.identity();
        }
        ReorderTransformation reorder = null;
        if (location.exists("stats.opt")) {
            try {
                reorder = ReorderLib.weighted(location.getPath("stats.opt"));
                log.debug("Statistics-based BGP optimizer");
            }
            catch (SSEParseException ex) {
                log.warn("Error in stats file: " + ex.getMessage());
                reorder = null;
            }
        }
        if (reorder == null && location.exists("fixed.opt")) {
            reorder = ReorderLib.fixed();
            log.debug("Fixed pattern BGP optimizer");
        }
        if (location.exists("none.opt")) {
            reorder = ReorderLib.identity();
            log.debug("Optimizer explicitly turned off");
        }
        if (reorder == null) {
            reorder = SystemTDB.defaultReorderTransform;
        }
        if (reorder == null && warnAboutOptimizer) {
            ARQ.getExecLogger().warn("No BGP optimizer");
        }
        return reorder;
    }

    static class Recorder
    implements RecordBlockMgr,
    RecordNodeTable {
        Map<FileRef, BlockMgr> blockMgrs = null;
        Map<FileRef, BufferChannel> bufferChannels = null;
        Map<FileRef, NodeTable> nodeTables = null;
        boolean recording = false;

        Recorder() {
        }

        void start() {
            if (this.recording) {
                throw new TDBException("Recorder already recording");
            }
            this.recording = true;
            this.blockMgrs = new HashMap<FileRef, BlockMgr>();
            this.bufferChannels = new HashMap<FileRef, BufferChannel>();
            this.nodeTables = new HashMap<FileRef, NodeTable>();
        }

        void finish() {
            if (!this.recording) {
                throw new TDBException("Recorder not recording");
            }
            this.blockMgrs = null;
            this.bufferChannels = null;
            this.nodeTables = null;
            this.recording = false;
        }

        @Override
        public void record(FileRef fileRef, BlockMgr blockMgr) {
            if (this.recording) {
                this.blockMgrs.put(fileRef, blockMgr);
            }
        }

        @Override
        public void record(FileRef fileRef, NodeTable nodeTable) {
            if (this.recording) {
                this.nodeTables.put(fileRef, nodeTable);
            }
        }
    }

    static class BlockMgrBuilderRecorder
    implements BlockMgrBuilder {
        private BlockMgrBuilder builder;
        private RecordBlockMgr recorder;

        BlockMgrBuilderRecorder(BlockMgrBuilder blkMgrBuilder, RecordBlockMgr recorder) {
            this.builder = blkMgrBuilder;
            this.recorder = recorder;
        }

        @Override
        public BlockMgr buildBlockMgr(FileSet fileSet, String ext, IndexParams params) {
            BlockMgr blkMgr = this.builder.buildBlockMgr(fileSet, ext, params);
            FileRef ref = FileRef.create(fileSet, ext);
            this.recorder.record(ref, blkMgr);
            return blkMgr;
        }
    }

    static class NodeTableBuilderRecorder
    implements NodeTableBuilder {
        private NodeTableBuilder builder;
        private RecordNodeTable recorder;

        NodeTableBuilderRecorder(NodeTableBuilder ntb, RecordNodeTable recorder) {
            this.builder = ntb;
            this.recorder = recorder;
        }

        @Override
        public NodeTable buildNodeTable(FileSet fsIndex, FileSet fsObjectFile, StoreParams params) {
            NodeTable nt = this.builder.buildNodeTable(fsIndex, fsObjectFile, params);
            FileRef ref = FileRef.create(fsObjectFile.filename("dat"));
            this.recorder.record(ref, nt);
            return nt;
        }
    }

    static interface RecordNodeTable {
        public void record(FileRef var1, NodeTable var2);
    }

    static interface RecordBlockMgr {
        public void record(FileRef var1, BlockMgr var2);
    }
}

