/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.SchemaDateTimeException;

public class TimeDV
extends AbstractDateTimeDV {
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "time"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        date2.year = 2000;
        date2.month = 1;
        date2.day = 15;
        this.getTime(str2, 0, len, date2);
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 2;
        return date2;
    }

    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuffer message = new StringBuffer(16);
        this.append(message, date2.hour, 2);
        message.append(':');
        this.append(message, date2.minute, 2);
        message.append(':');
        this.append(message, date2.second);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date2) {
        return datatypeFactory.newXMLGregorianCalendar(null, Integer.MIN_VALUE, Integer.MIN_VALUE, date2.unNormHour, date2.unNormMinute, (int)date2.unNormSecond, date2.unNormSecond != 0.0 ? this.getFractionalSecondsAsBigDecimal(date2) : null, date2.hasTimeZone() ? date2.timezoneHr * 60 + date2.timezoneMin : Integer.MIN_VALUE);
    }
}

