/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevWalk;

public class DescribeCommand
extends GitCommand<String> {
    private final RevWalk w;
    private RevCommit target;
    private int maxCandidates = 10;
    private boolean longDesc;

    protected DescribeCommand(Repository repo) {
        super(repo);
        this.w = new RevWalk(repo);
        this.w.setRetainBody(false);
    }

    public DescribeCommand setTarget(ObjectId target) throws IOException {
        this.target = this.w.parseCommit(target);
        return this;
    }

    public DescribeCommand setTarget(String rev) throws IOException, RefNotFoundException {
        ObjectId id = this.repo.resolve(rev);
        if (id == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, rev));
        }
        return this.setTarget(id);
    }

    public DescribeCommand setLong(boolean longDesc) {
        this.longDesc = longDesc;
        return this;
    }

    private String longDescription(Ref tag, int depth, ObjectId tip) throws IOException {
        return String.format("%s-%d-g%s", tag.getName().substring("refs/tags/".length()), depth, this.w.getObjectReader().abbreviate(tip).name());
    }

    @Override
    public String call() throws GitAPIException {
        try {
            Object t;
            RevCommit c;
            this.checkCallable();
            if (this.target == null) {
                this.setTarget("HEAD");
            }
            HashMap<ObjectId, Ref> tags = new HashMap<ObjectId, Ref>();
            for (Ref r : this.repo.getRefDatabase().getRefs("refs/tags/").values()) {
                ObjectId key = this.repo.peel(r).getPeeledObjectId();
                if (key == null) {
                    key = r.getObjectId();
                }
                tags.put(key, r);
            }
            final RevFlagSet allFlags = new RevFlagSet();
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag) {
                    this.tag = tag;
                    this.flag = DescribeCommand.this.w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    DescribeCommand.this.w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                String describe(ObjectId tip) throws IOException {
                    return DescribeCommand.this.longDescription(this.tag, this.depth, tip);
                }
            }
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            Ref lucky = (Ref)tags.get(this.target);
            if (lucky != null) {
                String string = this.longDesc ? this.longDescription(lucky, 0, this.target) : lucky.getName().substring("refs/tags/".length());
                return string;
            }
            this.w.markStart(this.target);
            int seen = 0;
            while ((c = this.w.next()) != null) {
                Candidate cd;
                if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                    cd = new Candidate(c, (Ref)t);
                    candidates.add(cd);
                    cd.depth = seen;
                }
                t = candidates.iterator();
                while (t.hasNext()) {
                    cd = (Candidate)t.next();
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= this.maxCandidates) break;
                ++seen;
            }
            while ((c = this.w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                t = null;
                return t;
            }
            Candidate best = Collections.min(candidates, new Comparator<Candidate>(){

                @Override
                public int compare(Candidate o1, Candidate o2) {
                    return o1.depth - o2.depth;
                }
            });
            String string = best.describe(this.target);
            return string;
        }
        catch (IOException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
        finally {
            this.setCallable(false);
            this.w.close();
        }
    }
}

