/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.RawCharUtil;

public abstract class RawTextComparator
extends SequenceComparator<RawText> {
    public static final RawTextComparator DEFAULT = new RawTextComparator(){

        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            int be;
            int as = a.lines.get(++ai);
            int bs = b.lines.get(++bi);
            int ae = a.lines.get(ai + 1);
            if (ae - as != (be = b.lines.get(bi + 1)) - bs) {
                return false;
            }
            while (as < ae) {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            while (ptr < end) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_ALL = new RawTextComparator(){

        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            int bs;
            int as = a.lines.get(++ai);
            int ae = a.lines.get(ai + 1);
            int be = b.lines.get(bi + 1);
            ae = RawCharUtil.trimTrailingWhitespace(a.content, as, ae);
            be = RawCharUtil.trimTrailingWhitespace(b.content, bs, be);
            for (bs = b.lines.get(++bi); as < ae && bs < be; ++as, ++bs) {
                byte ac = a.content[as];
                byte bc = b.content[bs];
                while (as < ae - 1 && RawCharUtil.isWhitespace(ac)) {
                    ac = a.content[++as];
                }
                while (bs < be - 1 && RawCharUtil.isWhitespace(bc)) {
                    bc = b.content[++bs];
                }
                if (ac == bc) continue;
                return false;
            }
            return as == ae && bs == be;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            while (ptr < end) {
                byte c = raw[ptr];
                if (!RawCharUtil.isWhitespace(c)) {
                    hash = (hash << 5) + hash + (c & 0xFF);
                }
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_LEADING = new RawTextComparator(){

        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            int as = a.lines.get(++ai);
            int bs = b.lines.get(++bi);
            int ae = a.lines.get(ai + 1);
            int be = b.lines.get(bi + 1);
            if (ae - (as = RawCharUtil.trimLeadingWhitespace(a.content, as, ae)) != be - (bs = RawCharUtil.trimLeadingWhitespace(b.content, bs, be))) {
                return false;
            }
            while (as < ae) {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            for (ptr = RawCharUtil.trimLeadingWhitespace(raw, ptr, end); ptr < end; ++ptr) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_TRAILING = new RawTextComparator(){

        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            int as = a.lines.get(++ai);
            int bs = b.lines.get(++bi);
            int ae = a.lines.get(ai + 1);
            int be = b.lines.get(bi + 1);
            if ((ae = RawCharUtil.trimTrailingWhitespace(a.content, as, ae)) - as != (be = RawCharUtil.trimTrailingWhitespace(b.content, bs, be)) - bs) {
                return false;
            }
            while (as < ae) {
                if (a.content[as++] == b.content[bs++]) continue;
                return false;
            }
            return true;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            end = RawCharUtil.trimTrailingWhitespace(raw, ptr, end);
            while (ptr < end) {
                hash = (hash << 5) + hash + (raw[ptr] & 0xFF);
                ++ptr;
            }
            return hash;
        }
    };
    public static final RawTextComparator WS_IGNORE_CHANGE = new RawTextComparator(){

        @Override
        public boolean equals(RawText a, int ai, RawText b, int bi) {
            int as = a.lines.get(++ai);
            int bs = b.lines.get(++bi);
            int ae = a.lines.get(ai + 1);
            int be = b.lines.get(bi + 1);
            ae = RawCharUtil.trimTrailingWhitespace(a.content, as, ae);
            be = RawCharUtil.trimTrailingWhitespace(b.content, bs, be);
            while (as < ae && bs < be) {
                byte ac = a.content[as];
                byte bc = b.content[bs];
                if (ac != bc) {
                    return false;
                }
                as = RawCharUtil.isWhitespace(ac) ? RawCharUtil.trimLeadingWhitespace(a.content, as, ae) : ++as;
                if (RawCharUtil.isWhitespace(bc)) {
                    bs = RawCharUtil.trimLeadingWhitespace(b.content, bs, be);
                    continue;
                }
                ++bs;
            }
            return as == ae && bs == be;
        }

        @Override
        protected int hashRegion(byte[] raw, int ptr, int end) {
            int hash = 5381;
            end = RawCharUtil.trimTrailingWhitespace(raw, ptr, end);
            while (ptr < end) {
                byte c = raw[ptr];
                hash = (hash << 5) + hash + (c & 0xFF);
                if (RawCharUtil.isWhitespace(c)) {
                    ptr = RawCharUtil.trimLeadingWhitespace(raw, ptr, end);
                    continue;
                }
                ++ptr;
            }
            return hash;
        }
    };

    @Override
    public int hash(RawText seq2, int lno) {
        int begin = seq2.lines.get(lno + 1);
        int end = seq2.lines.get(lno + 2);
        return this.hashRegion(seq2.content, begin, end);
    }

    @Override
    public Edit reduceCommonStartEnd(RawText a, RawText b, Edit e2) {
        boolean partialA;
        int bPtr;
        if (e2.beginA == e2.endA || e2.beginB == e2.endB) {
            return e2;
        }
        byte[] aRaw = a.content;
        byte[] bRaw = b.content;
        int aPtr = a.lines.get(e2.beginA + 1);
        int aEnd = a.lines.get(e2.endA + 1);
        int bEnd = b.lines.get(e2.endB + 1);
        if (aPtr < 0 || bPtr < 0 || aEnd > aRaw.length || bEnd > bRaw.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (bPtr = a.lines.get(e2.beginB + 1); aPtr < aEnd && bPtr < bEnd && aRaw[aPtr] == bRaw[bPtr]; ++aPtr, ++bPtr) {
        }
        while (aPtr < aEnd && bPtr < bEnd && aRaw[aEnd - 1] == bRaw[bEnd - 1]) {
            --aEnd;
            --bEnd;
        }
        e2.beginA = RawTextComparator.findForwardLine(a.lines, e2.beginA, aPtr);
        e2.beginB = RawTextComparator.findForwardLine(b.lines, e2.beginB, bPtr);
        e2.endA = RawTextComparator.findReverseLine(a.lines, e2.endA, aEnd);
        boolean bl = partialA = aEnd < a.lines.get(e2.endA + 1);
        if (partialA) {
            bEnd += a.lines.get(e2.endA + 1) - aEnd;
        }
        e2.endB = RawTextComparator.findReverseLine(b.lines, e2.endB, bEnd);
        if (!partialA && bEnd < b.lines.get(e2.endB + 1)) {
            ++e2.endA;
        }
        return super.reduceCommonStartEnd(a, b, e2);
    }

    private static int findForwardLine(IntList lines, int idx, int ptr) {
        int end = lines.size() - 2;
        while (idx < end && lines.get(idx + 2) < ptr) {
            ++idx;
        }
        return idx;
    }

    private static int findReverseLine(IntList lines, int idx, int ptr) {
        while (0 < idx && ptr <= lines.get(idx)) {
            --idx;
        }
        return idx;
    }

    protected abstract int hashRegion(byte[] var1, int var2, int var3);
}

