/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import org.eclipse.jgit.internal.storage.dfs.DfsPackKey;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;

final class DeltaBaseCache {
    private static final int TABLE_BITS = 10;
    private static final int MASK_BITS = 22;
    private int maxByteCount;
    private int curByteCount;
    private final Entry[] table;
    private Entry lruHead;
    private Entry lruTail;

    private static int hash(long position) {
        return (int)position << 22 >>> 22;
    }

    DeltaBaseCache(DfsReader reader) {
        this(reader.getOptions().getDeltaBaseCacheLimit());
    }

    DeltaBaseCache(int maxBytes) {
        this.maxByteCount = maxBytes;
        this.table = new Entry[1024];
    }

    Entry get(DfsPackKey key, long position) {
        Entry e2 = this.table[DeltaBaseCache.hash(position)];
        while (e2 != null) {
            if (e2.offset == position && key.equals(e2.pack)) {
                this.moveToHead(e2);
                return e2;
            }
            e2 = e2.tableNext;
        }
        return null;
    }

    void put(DfsPackKey key, long offset, int objectType, byte[] data) {
        if (data.length > this.maxByteCount) {
            return;
        }
        this.curByteCount += data.length;
        this.releaseMemory();
        int tableIdx = DeltaBaseCache.hash(offset);
        Entry e2 = new Entry(key, offset, objectType, data);
        e2.tableNext = this.table[tableIdx];
        this.table[tableIdx] = e2;
        this.lruPushHead(e2);
    }

    private void releaseMemory() {
        while (this.curByteCount > this.maxByteCount && this.lruTail != null) {
            Entry e2 = this.lruTail;
            this.curByteCount -= e2.data.length;
            this.lruRemove(e2);
            this.removeFromTable(e2);
        }
    }

    private void removeFromTable(Entry e2) {
        int tableIdx = DeltaBaseCache.hash(e2.offset);
        Entry p = this.table[tableIdx];
        if (p == e2) {
            this.table[tableIdx] = e2.tableNext;
            return;
        }
        while (p != null) {
            if (p.tableNext == e2) {
                p.tableNext = e2.tableNext;
                return;
            }
            p = p.tableNext;
        }
        throw new IllegalStateException(String.format("entry for %s:%d not in table", e2.pack, e2.offset));
    }

    private void moveToHead(Entry e2) {
        if (e2 != this.lruHead) {
            this.lruRemove(e2);
            this.lruPushHead(e2);
        }
    }

    private void lruRemove(Entry e2) {
        Entry p = e2.lruPrev;
        Entry n = e2.lruNext;
        if (p != null) {
            p.lruNext = n;
        } else {
            this.lruHead = n;
        }
        if (n != null) {
            n.lruPrev = p;
        } else {
            this.lruTail = p;
        }
    }

    private void lruPushHead(Entry e2) {
        Entry n;
        e2.lruNext = n = this.lruHead;
        if (n != null) {
            n.lruPrev = e2;
        } else {
            this.lruTail = e2;
        }
        e2.lruPrev = null;
        this.lruHead = e2;
    }

    int getMemoryUsed() {
        return this.curByteCount;
    }

    int getMemoryUsedByLruChainForTest() {
        int r = 0;
        Entry e2 = this.lruHead;
        while (e2 != null) {
            r += e2.data.length;
            e2 = e2.lruNext;
        }
        return r;
    }

    int getMemoryUsedByTableForTest() {
        int r = 0;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e2 = this.table[i];
            while (e2 != null) {
                r += e2.data.length;
                e2 = e2.tableNext;
            }
        }
        return r;
    }

    static class Entry {
        final DfsPackKey pack;
        final long offset;
        final int type;
        final byte[] data;
        Entry tableNext;
        Entry lruPrev;
        Entry lruNext;

        Entry(DfsPackKey key, long offset, int type, byte[] data) {
            this.pack = key;
            this.offset = offset;
            this.type = type;
            this.data = data;
        }
    }
}

