/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.pack;

import java.io.IOException;
import java.util.Set;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BitmapIndex;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;

final class PackWriterBitmapWalker {
    private final ObjectWalk walker;
    private final BitmapIndex bitmapIndex;
    private final ProgressMonitor pm;
    private long countOfBitmapIndexMisses;

    PackWriterBitmapWalker(ObjectWalk walker, BitmapIndex bitmapIndex, ProgressMonitor pm) {
        this.walker = walker;
        this.bitmapIndex = bitmapIndex;
        this.pm = pm == null ? NullProgressMonitor.INSTANCE : pm;
    }

    long getCountOfBitmapIndexMisses() {
        return this.countOfBitmapIndexMisses;
    }

    BitmapIndex.BitmapBuilder findObjects(Set<? extends ObjectId> start, BitmapIndex.BitmapBuilder seen, boolean ignoreMissingStart) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        BitmapIndex.BitmapBuilder bitmapResult = this.bitmapIndex.newBitmapBuilder();
        for (ObjectId objectId : start) {
            BitmapIndex.Bitmap bitmap = this.bitmapIndex.getBitmap(objectId);
            if (bitmap == null) continue;
            bitmapResult.or(bitmap);
        }
        boolean marked = false;
        for (ObjectId objectId : start) {
            try {
                if (bitmapResult.contains(objectId)) continue;
                this.walker.markStart(this.walker.parseAny(objectId));
                marked = true;
            }
            catch (MissingObjectException e2) {
                if (ignoreMissingStart) continue;
                throw e2;
            }
        }
        if (marked) {
            RevObject revObject;
            if (seen == null) {
                this.walker.setRevFilter(new AddToBitmapFilter(bitmapResult));
            } else {
                this.walker.setRevFilter(new AddUnseenToBitmapFilter(seen, bitmapResult));
            }
            while (this.walker.next() != null) {
                this.pm.update(1);
                ++this.countOfBitmapIndexMisses;
            }
            while ((revObject = this.walker.nextObject()) != null) {
                bitmapResult.addObject(revObject, revObject.getType());
                this.pm.update(1);
            }
        }
        return bitmapResult;
    }

    void reset() {
        this.walker.reset();
    }

    static class AddToBitmapFilter
    extends RevFilter {
        private final BitmapIndex.BitmapBuilder bitmap;

        AddToBitmapFilter(BitmapIndex.BitmapBuilder bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public final boolean include(RevWalk walker, RevCommit cmit) {
            if (!this.bitmap.contains(cmit)) {
                BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
                if (visitedBitmap != null) {
                    this.bitmap.or(visitedBitmap);
                } else {
                    this.bitmap.addObject(cmit, 1);
                    return true;
                }
            }
            for (RevCommit p : cmit.getParents()) {
                p.add(RevFlag.SEEN);
            }
            return false;
        }

        @Override
        public final RevFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }

    static class AddUnseenToBitmapFilter
    extends RevFilter {
        private final BitmapIndex.BitmapBuilder seen;
        private final BitmapIndex.BitmapBuilder bitmap;

        AddUnseenToBitmapFilter(BitmapIndex.BitmapBuilder seen, BitmapIndex.BitmapBuilder bitmapResult) {
            this.seen = seen;
            this.bitmap = bitmapResult;
        }

        @Override
        public final boolean include(RevWalk walker, RevCommit cmit) {
            if (!this.seen.contains(cmit) && !this.bitmap.contains(cmit)) {
                BitmapIndex.Bitmap visitedBitmap = this.bitmap.getBitmapIndex().getBitmap(cmit);
                if (visitedBitmap != null) {
                    this.bitmap.or(visitedBitmap);
                } else {
                    this.bitmap.addObject(cmit, 1);
                    return true;
                }
            }
            for (RevCommit p : cmit.getParents()) {
                p.add(RevFlag.SEEN);
            }
            return false;
        }

        @Override
        public final RevFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }
    }
}

