/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.RawParseUtils;

public class PushCertificateIdent {
    private final String raw;
    private final String userId;
    private final long when;
    private final int tzOffset;

    public static PushCertificateIdent parse(String str2) {
        boolean hasWhen;
        MutableInteger p = new MutableInteger();
        byte[] raw = str2.getBytes(StandardCharsets.UTF_8);
        int tzBegin = raw.length - 1;
        if ((tzBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', tzBegin)) < 0 || raw[tzBegin] != 32) {
            return new PushCertificateIdent(str2, str2, 0L, 0);
        }
        int whenBegin = tzBegin++;
        int tz = RawParseUtils.parseTimeZoneOffset(raw, tzBegin, p);
        boolean hasTz = p.value != tzBegin;
        if ((whenBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', whenBegin)) < 0 || raw[whenBegin] != 32) {
            return new PushCertificateIdent(str2, str2, 0L, 0);
        }
        int idEnd = whenBegin++;
        long when = RawParseUtils.parseLongBase10(raw, whenBegin, p);
        boolean bl = hasWhen = p.value != whenBegin;
        if (hasTz && hasWhen) {
            idEnd = whenBegin - 1;
        } else {
            tz = 0;
            when = 0L;
            idEnd = hasTz && !hasWhen ? tzBegin - 1 : raw.length;
        }
        String id = new String(raw, 0, idEnd, StandardCharsets.UTF_8);
        return new PushCertificateIdent(str2, id, when * 1000L, tz);
    }

    public PushCertificateIdent(String userId, long when, int tzOffset) {
        this.userId = userId;
        this.when = when;
        this.tzOffset = tzOffset;
        StringBuilder sb = new StringBuilder(userId).append(' ').append(when / 1000L).append(' ');
        PersonIdent.appendTimezone(sb, tzOffset);
        this.raw = sb.toString();
    }

    private PushCertificateIdent(String raw, String userId, long when, int tzOffset) {
        this.raw = raw;
        this.userId = userId;
        this.when = when;
        this.tzOffset = tzOffset;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getName() {
        int nameBegin;
        int nameEnd = this.userId.indexOf(60);
        if (nameEnd < 0 || this.userId.indexOf(62, nameEnd) < 0) {
            nameEnd = this.userId.length();
        }
        --nameEnd;
        while (nameEnd >= 0 && this.userId.charAt(nameEnd) == ' ') {
            --nameEnd;
        }
        for (nameBegin = 0; nameBegin < nameEnd && this.userId.charAt(nameBegin) == ' '; ++nameBegin) {
        }
        return this.userId.substring(nameBegin, nameEnd + 1);
    }

    public String getEmailAddress() {
        int emailBegin = this.userId.indexOf(60);
        if (emailBegin < 0) {
            return null;
        }
        int emailEnd = this.userId.indexOf(62, emailBegin);
        if (emailEnd < 0) {
            return null;
        }
        return this.userId.substring(emailBegin + 1, emailEnd);
    }

    public Date getWhen() {
        return new Date(this.when);
    }

    public TimeZone getTimeZone() {
        return PersonIdent.getTimeZone(this.tzOffset);
    }

    public int getTimeZoneOffset() {
        return this.tzOffset;
    }

    public boolean equals(Object o) {
        return o instanceof PushCertificateIdent && this.raw.equals(((PushCertificateIdent)o).raw);
    }

    public int hashCode() {
        return this.raw.hashCode();
    }

    public String toString() {
        SimpleDateFormat fmt = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy Z", Locale.US);
        fmt.setTimeZone(this.getTimeZone());
        return this.getClass().getSimpleName() + "[raw=\"" + this.raw + "\", userId=\"" + this.userId + "\", " + fmt.format(this.when) + "]";
    }
}

