/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import java.util.Map;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.SpdxElement;

public class ElementContext {
    private String name;
    private String id;
    private String elementLink;
    String error = null;

    public ElementContext(InvalidSPDXAnalysisException e2) {
        this.error = e2.getMessage();
    }

    public ElementContext(SpdxElement element, Map<String, String> spdxIdToUrl) {
        if (element == null) {
            return;
        }
        this.name = element.getName();
        this.id = element.getId();
        this.elementLink = spdxIdToUrl.get(this.id);
    }

    public String getName() {
        if (this.error != null) {
            return this.error;
        }
        return this.name;
    }

    public String getId() {
        if (this.error != null) {
            return this.error;
        }
        return this.id;
    }

    public String getElementLink() {
        if (this.error != null) {
            return null;
        }
        return this.elementLink;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setElementLink(String elementLink) {
        this.elementLink = elementLink;
    }
}

