/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.NonNumericLicenseIdException;
import org.spdx.rdfparser.SPDXChecksum;
import org.spdx.rdfparser.SPDXCreatorInformation;
import org.spdx.rdfparser.SPDXFile;
import org.spdx.rdfparser.SPDXPackageInfo;
import org.spdx.rdfparser.SPDXReview;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.SpdxRdfConstants;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.license.AnyLicenseInfo;
import org.spdx.rdfparser.license.ExtractedLicenseInfo;
import org.spdx.rdfparser.license.LicenseInfoFactory;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.spdxspreadsheet.InvalidLicenseStringException;

@Deprecated
public class SPDXDocument
implements SpdxRdfConstants,
IModelContainer {
    public static final String POINT_EIGHT_SPDX_VERSION = "SPDX-0.8";
    public static final String POINT_NINE_SPDX_VERSION = "SPDX-0.9";
    public static final String ONE_DOT_ZERO_SPDX_VERSION = "SPDX-1.0";
    public static final String ONE_DOT_ONE_SPDX_VERSION = "SPDX-1.1";
    public static final String ONE_DOT_TWO_SPDX_VERSION = "SPDX-1.2";
    public static final String TWO_DOT_ZERO_DOT_ZERO_VERSION = "2.0.0";
    public static final String CURRENT_SPDX_VERSION = "SPDX-2.0";
    public static final String CURRENT_IMPLEMENTATION_VERSION = "2.0.2";
    static Set<String> SUPPORTED_SPDX_VERSIONS = Sets.newHashSet();
    private AtomicInteger nextLicenseRef = new AtomicInteger(1);
    Model model;
    SPDXPackage spdxPackage = null;
    private String documentNamespace;
    private AtomicInteger nextElementRef = new AtomicInteger(0);

    public SPDXDocument(Model model) throws InvalidSPDXAnalysisException {
        this.model = model;
        this.initialize();
    }

    private List<String> initialize() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode != null) {
            if (!spdxDocNode.isURI()) {
                throw new InvalidSPDXAnalysisException("SPDX Documents must have a unique URI");
            }
            String docUri = spdxDocNode.getURI();
            this.documentNamespace = this.formDocNamespace(docUri);
            List<String> errors = this.verify();
            this.initializeNextLicenseRef();
            this.initializeNextElementRef();
            return errors;
        }
        return Lists.newArrayList();
    }

    private void initializeNextElementRef() {
        int highestElementRef = 0;
        Triple m = Triple.createMatch(null, null, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            String objectUri;
            int elementRefNum;
            String elementRef;
            String subjectUri;
            Triple trip = (Triple)tripleIter.next();
            if (trip.getSubject().isURI() && (subjectUri = trip.getSubject().getURI()).startsWith(this.documentNamespace + "SPDXRef-") && SPDX_ELEMENT_REF_PATTERN.matcher(elementRef = subjectUri.substring(this.documentNamespace.length())).matches() && (elementRefNum = SPDXDocument.getElementRefNumber(elementRef)) > highestElementRef) {
                highestElementRef = elementRefNum;
            }
            if (!trip.getObject().isURI() || !(objectUri = trip.getObject().getURI()).startsWith(this.documentNamespace + "SPDXRef-") || !SPDX_ELEMENT_REF_PATTERN.matcher(elementRef = objectUri.substring(this.documentNamespace.length())).matches() || (elementRefNum = SPDXDocument.getElementRefNumber(elementRef)) <= highestElementRef) continue;
            highestElementRef = elementRefNum;
        }
        this.nextElementRef.set(highestElementRef + 1);
    }

    public static int getElementRefNumber(String elementReference) {
        String numPart = elementReference.substring("SPDXRef-".length());
        try {
            return Integer.parseInt(numPart);
        }
        catch (Exception ex) {
            return -1;
        }
    }

    protected void initializeNextLicenseRef() throws InvalidSPDXAnalysisException {
        this.initializeNextLicenseRef(this.getExtractedLicenseInfos());
    }

    protected void initializeNextLicenseRef(ExtractedLicenseInfo[] existingLicenses) throws InvalidSPDXAnalysisException {
        int highestNonStdLicense = 0;
        for (int i = 0; i < existingLicenses.length; ++i) {
            try {
                int idNum = this.getLicenseRefNum(existingLicenses[i].getLicenseId());
                if (idNum <= highestNonStdLicense) continue;
                highestNonStdLicense = idNum;
                continue;
            }
            catch (NonNumericLicenseIdException nonNumericLicenseIdException) {
                // empty catch block
            }
        }
        this.nextLicenseRef.set(highestNonStdLicense + 1);
    }

    public int getLicenseRefNum(String licenseID) throws NonNumericLicenseIdException {
        Matcher matcher = LICENSE_ID_PATTERN_NUMERIC.matcher(licenseID);
        if (!matcher.matches()) {
            throw new NonNumericLicenseIdException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        int numGroups = matcher.groupCount();
        if (numGroups != 1) {
            throw new NonNumericLicenseIdException("Invalid license ID found in the non-standard licenses: '" + licenseID + "'");
        }
        int idNum = Integer.decode(matcher.group(1));
        return idNum;
    }

    public static String formNonStandardLicenseID(int idNum) {
        return "LicenseRef-" + String.valueOf(idNum);
    }

    public String verifySpdxVersion(String spdxVersion) {
        if (!spdxVersion.startsWith("SPDX-")) {
            return "Invalid spdx version - must start with 'SPDX-'";
        }
        Matcher docSpecVersionMatcher = SpdxRdfConstants.SPDX_VERSION_PATTERN.matcher(spdxVersion);
        if (!docSpecVersionMatcher.matches()) {
            return "Invalid spdx version format - must match 'SPDX-M.N'";
        }
        return null;
    }

    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String docSpecVersion = "";
        try {
            docSpecVersion = this.getSpdxVersion();
            if (docSpecVersion == null || docSpecVersion.isEmpty()) {
                retval.add("Missing required SPDX version");
            } else {
                String verify = this.verifySpdxVersion(docSpecVersion);
                if (verify != null) {
                    retval.add(verify);
                } else if (!SUPPORTED_SPDX_VERSIONS.contains(docSpecVersion)) {
                    retval.add("Version " + docSpecVersion + " is not supported by this version of the rdf parser");
                }
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval.add("Invalid spec version: " + e2.getMessage());
        }
        try {
            SPDXCreatorInformation creator = this.getCreatorInfo();
            if (creator == null) {
                retval.add("Missing required Creator");
            } else {
                List<String> creatorVerification = creator.verify();
                retval.addAll(creatorVerification);
            }
        }
        catch (InvalidSPDXAnalysisException e3) {
            retval.add("Invalid creator information: " + e3.getMessage());
        }
        try {
            SPDXPackage sPkg = this.getSpdxPackage();
            if (sPkg == null) {
                retval.add("Missing required SPDX Package");
            } else {
                List<String> packageVerification = sPkg.verify();
                retval.addAll(packageVerification);
            }
        }
        catch (InvalidSPDXAnalysisException e4) {
            retval.add("Invalid SPDX Package: " + e4.getMessage());
        }
        try {
            SPDXReview[] reviews = this.getReviewers();
            if (reviews != null) {
                for (int i = 0; i < reviews.length; ++i) {
                    List<String> reviewerVerification = reviews[i].verify();
                    retval.addAll(reviewerVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e5) {
            retval.add("Invalid reviewers: " + e5.getMessage());
        }
        try {
            ExtractedLicenseInfo[] extractedLicInfos = this.getExtractedLicenseInfos();
            if (extractedLicInfos != null) {
                for (int i = 0; i < extractedLicInfos.length; ++i) {
                    List<String> extractedLicInfoVerification = extractedLicInfos[i].verify();
                    retval.addAll(extractedLicInfoVerification);
                }
            }
        }
        catch (InvalidSPDXAnalysisException e6) {
            retval.add("Invalid extracted licensing info: " + e6.getMessage());
        }
        if (docSpecVersion != null && !docSpecVersion.equals(POINT_EIGHT_SPDX_VERSION) && !docSpecVersion.equals(POINT_NINE_SPDX_VERSION)) {
            try {
                SpdxListedLicense dataLicense = this.getDataLicense();
                if (dataLicense == null) {
                    retval.add("Missing required data license");
                } else if (docSpecVersion.equals(ONE_DOT_ZERO_SPDX_VERSION)) {
                    if (!dataLicense.getLicenseId().equals("PDDL-1.0")) {
                        retval.add("Incorrect data license for SPDX version 1.0 document - found " + dataLicense.getLicenseId() + ", expected " + "PDDL-1.0");
                    }
                } else if (!dataLicense.getLicenseId().equals("CC0-1.0")) {
                    retval.add("Incorrect data license for SPDX document - found " + dataLicense.getLicenseId() + ", expected " + "CC0-1.0");
                }
            }
            catch (InvalidSPDXAnalysisException e7) {
                retval.add("Invalid data license: " + e7.getMessage());
            }
        }
        try {
            String[] comments = this.findDocPropertieStringValues(this.getSpdxDocNode(), "http://www.w3.org/2000/01/rdf-schema#", "comment");
            if (comments.length > 1) {
                retval.add("More than one document comment exists for the SPDX Package");
            }
        }
        catch (Exception e8) {
            retval.add("Invalid document comment: " + e8.getMessage());
        }
        return retval;
    }

    private String[] findDocPropertieStringValues(Node subject, String propertyName) {
        return this.findDocPropertieStringValues(subject, "http://spdx.org/rdf/terms#", propertyName);
    }

    private String[] findDocPropertieStringValues(Node subject, String nameSpace, String propertyName) {
        if (subject == null || propertyName == null) {
            return null;
        }
        ArrayList<String> alResult = Lists.newArrayList();
        Node p = this.model.getProperty(nameSpace, propertyName).asNode();
        Triple m = Triple.createMatch(subject, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (t.getObject().isURI()) {
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#none")) {
                    alResult.add("NONE");
                    continue;
                }
                if (t.getObject().getURI().equals("http://spdx.org/rdf/terms#noassertion")) {
                    alResult.add("NOASSERTION");
                    continue;
                }
                alResult.add(t.getObject().toString(false));
                continue;
            }
            alResult.add(t.getObject().toString(false));
        }
        String[] retval = new String[alResult.size()];
        return alResult.toArray(retval);
    }

    private void removeProperties(Node subject, String propertyName) throws InvalidSPDXAnalysisException {
        this.removeProperties(subject, "http://spdx.org/rdf/terms#", propertyName);
    }

    private void removeProperties(Node subject, String nameSpace, String propertyName) throws InvalidSPDXAnalysisException {
        Property p = this.model.getProperty(nameSpace, propertyName);
        Resource s = this.getResource(subject);
        this.model.removeAll(s, p, null);
    }

    private Resource getResource(Node node) throws InvalidSPDXAnalysisException {
        Resource s;
        if (node.isURI()) {
            s = this.model.createResource(node.getURI());
        } else if (node.isBlank()) {
            s = this.model.createResource(new AnonId(node.getBlankNodeId()));
        } else {
            throw new InvalidSPDXAnalysisException("Node can not be a literal");
        }
        return s;
    }

    private void addProperty(Node subject, String propertyName, String[] propertyValue) throws InvalidSPDXAnalysisException {
        this.addProperty(subject, "http://spdx.org/rdf/terms#", propertyName, propertyValue);
    }

    private void addProperty(Node subject, String nameSpace, String propertyName, String[] propertyValue) throws InvalidSPDXAnalysisException {
        Resource s = this.getResource(subject);
        for (int i = 0; i < propertyValue.length; ++i) {
            Resource r;
            Property p = this.model.createProperty(nameSpace, propertyName);
            if (propertyValue[i].equals("NONE")) {
                r = this.model.createResource("http://spdx.org/rdf/terms#none");
                s.addProperty(p, r);
                continue;
            }
            if (propertyValue[i].equals("NOASSERTION")) {
                r = this.model.createResource("http://spdx.org/rdf/terms#noassertion");
                s.addProperty(p, r);
                continue;
            }
            s.addProperty(p, propertyValue[i]);
        }
    }

    public String getSpdxVersion() throws InvalidSPDXAnalysisException {
        String[] versions = this.findDocPropertieStringValues(this.getSpdxDocNode(), "specVersion");
        if (versions == null || versions.length == 0) {
            return null;
        }
        if (versions.length > 1) {
            throw new InvalidSPDXAnalysisException("More than one version exists for the SPDX Document");
        }
        return versions[0];
    }

    public void setDocumentComment(String comment) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting spdxVersion");
        }
        this.removeProperties(spdxDocNode, "http://www.w3.org/2000/01/rdf-schema#", "comment");
        if (comment != null && !comment.isEmpty()) {
            this.addProperty(spdxDocNode, "http://www.w3.org/2000/01/rdf-schema#", "comment", new String[]{comment});
        }
    }

    public String getDocumentComment() throws InvalidSPDXAnalysisException {
        String[] comments = this.findDocPropertieStringValues(this.getSpdxDocNode(), "http://www.w3.org/2000/01/rdf-schema#", "comment");
        if (comments == null || comments.length == 0) {
            return null;
        }
        if (comments.length > 1) {
            throw new InvalidSPDXAnalysisException("More than one document comment exists for the SPDX Document");
        }
        return comments[0];
    }

    public void setSpdxVersion(String spdxVersion) throws InvalidSPDXAnalysisException {
        String versionVerify = this.verifySpdxVersion(spdxVersion);
        if (versionVerify != null && !versionVerify.isEmpty()) {
            throw new InvalidSPDXAnalysisException(versionVerify);
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting spdxVersion");
        }
        this.removeProperties(spdxDocNode, "specVersion");
        this.addProperty(spdxDocNode, "specVersion", new String[]{spdxVersion});
    }

    public SpdxListedLicense getDataLicense() throws InvalidSPDXAnalysisException {
        ArrayList<AnyLicenseInfo> alLic = Lists.newArrayList();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "dataLicense").asNode();
        Triple m = Triple.createMatch(this.getSpdxDocNode(), p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(this, t.getObject()));
        }
        if (alLic.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many data licenses");
        }
        if (alLic.size() == 0) {
            return null;
        }
        if (!(alLic.get(0) instanceof SpdxListedLicense)) {
            throw new InvalidSPDXAnalysisException("Incorrect license for datalicense - must be a standard SPDX license type");
        }
        return (SpdxListedLicense)alLic.get(0);
    }

    public void setDataLicense(SpdxListedLicense dataLicense) throws InvalidSPDXAnalysisException {
        String spdxVersion = this.getSpdxVersion();
        if (spdxVersion == null) {
            throw new InvalidSPDXAnalysisException("Can not set a data license - document does not contain a version.  Set the SPDX version property before setting the data license.");
        }
        if (spdxVersion.equals(ONE_DOT_ZERO_SPDX_VERSION)) {
            if (!dataLicense.getLicenseId().equals("PDDL-1.0")) {
                throw new InvalidSPDXAnalysisException("Invalid data license for version 1 SPDX document - license must have ID PDDL-1.0");
            }
        } else if (!dataLicense.getLicenseId().equals("CC0-1.0")) {
            throw new InvalidSPDXAnalysisException("Invalid data license for SPDX document - license must have ID CC0-1.0");
        }
        this.removeProperties(this.getSpdxDocNode(), "dataLicense");
        Resource s = this.getResource(this.getSpdxDocNode());
        Property p = this.model.createProperty("http://spdx.org/rdf/terms#", "dataLicense");
        Resource lic = dataLicense.createResource(this);
        s.addProperty(p, lic);
    }

    public SPDXFile[] getFileReferences() throws InvalidSPDXAnalysisException {
        ArrayList<SPDXFile> alFiles = Lists.newArrayList();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "referencesFile").asNode();
        Triple m = Triple.createMatch(this.getSpdxDocNode(), p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alFiles.add(new SPDXFile(this, t.getObject()));
        }
        SPDXFile[] retval = new SPDXFile[alFiles.size()];
        return alFiles.toArray(retval);
    }

    @Deprecated
    public String[] getCreators() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null && creator.getCreators() != null) {
            return creator.getCreators();
        }
        return null;
    }

    public SPDXCreatorInformation getCreatorInfo() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("No SPDX Document was found.  Can not access the creator information");
        }
        ArrayList<SPDXCreatorInformation> als = Lists.newArrayList();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "creationInfo").asNode();
        Triple m = Triple.createMatch(spdxDocNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            als.add(new SPDXCreatorInformation(this.model, t.getObject()));
        }
        if (als.size() > 1) {
            throw new InvalidSPDXAnalysisException("Too many creation information for document.  Only one is allowed.");
        }
        if (als.size() > 0) {
            return (SPDXCreatorInformation)als.get(0);
        }
        return null;
    }

    public void setCreationInfo(SPDXCreatorInformation creator) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to set creationInfo");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "creationInfo");
        Resource s = this.getResource(spdxDocNode);
        this.model.removeAll(s, p, null);
        p = this.model.createProperty("http://spdx.org/rdf/terms#", "creationInfo");
        s.addProperty(p, creator.createResource(this.model));
    }

    @Deprecated
    public String getCreatorComment() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null) {
            return creator.getComment();
        }
        return null;
    }

    public SPDXReview[] getReviewers() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to get reviewers");
        }
        ArrayList<SPDXReview> als = Lists.newArrayList();
        als.clear();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "reviewed").asNode();
        Triple m = Triple.createMatch(spdxDocNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            als.add(new SPDXReview(this.model, t.getObject()));
        }
        SPDXReview[] reviewers = new SPDXReview[als.size()];
        reviewers = als.toArray(reviewers);
        return reviewers;
    }

    public void setReviewers(SPDXReview[] reviewers) throws InvalidSPDXAnalysisException {
        Node spdxDocNode;
        if (reviewers.length > 0) {
            ArrayList<String> errors = Lists.newArrayList();
            for (int i = 0; i < reviewers.length; ++i) {
                errors.addAll(reviewers[i].verify());
            }
            if (errors.size() > 0) {
                StringBuilder sb = new StringBuilder("Invalid reviewers due to the following errors in validation:\n");
                for (int i = 0; i < errors.size(); ++i) {
                    sb.append((String)errors.get(i));
                    sb.append('\n');
                }
                throw new InvalidSPDXAnalysisException(sb.toString());
            }
        }
        if ((spdxDocNode = this.getSpdxDocNode()) == null) {
            throw new InvalidSPDXAnalysisException("Must have an SPDX document to set reviewers");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "reviewed");
        Resource s = this.getResource(spdxDocNode);
        this.model.removeAll(s, p, null);
        for (int i = 0; i < reviewers.length; ++i) {
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "reviewed");
            s.addProperty(p, reviewers[i].createResource(this.model));
        }
    }

    @Deprecated
    public String getCreated() throws InvalidSPDXAnalysisException {
        SPDXCreatorInformation creator = this.getCreatorInfo();
        if (creator != null) {
            return creator.getCreated();
        }
        return null;
    }

    public SPDXPackage getSpdxPackage() throws InvalidSPDXAnalysisException {
        if (this.spdxPackage != null) {
            return this.spdxPackage;
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must set an SPDX doc before getting an SPDX package");
        }
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "describesPackage").asNode();
        Triple m = Triple.createMatch(spdxDocNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        SPDXPackage newSpdxPackage = null;
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            newSpdxPackage = new SPDXPackage(t.getObject(), this);
        }
        this.spdxPackage = newSpdxPackage;
        return newSpdxPackage;
    }

    public SPDXPackage createSpdxPackage(String uri) throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before creating an SPDX Package");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "describesPackage");
        Resource s = this.getResource(this.getSpdxDocNode());
        this.model.removeAll(s, p, null);
        p = this.model.createProperty("http://spdx.org/rdf/terms#", "describesPackage");
        Resource pkgType = this.model.createResource("http://spdx.org/rdf/terms#Package");
        Resource spdxPkg = this.model.createResource(uri, pkgType);
        s.addProperty(p, spdxPkg);
        this.spdxPackage = new SPDXPackage(spdxPkg.asNode(), this);
        return this.spdxPackage;
    }

    public void createSpdxPackage() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before creating an SPDX Package");
        }
        this.createSpdxPackage(this.documentNamespace + this.getNextSpdxElementRef());
    }

    public ExtractedLicenseInfo[] getExtractedLicenseInfos() throws InvalidSPDXAnalysisException {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("No SPDX Document - can not get the Non Standard Licenses");
        }
        ArrayList<ExtractedLicenseInfo> alLic = Lists.newArrayList();
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo").asNode();
        Triple m = Triple.createMatch(spdxDocNode, p, null);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            alLic.add(new ExtractedLicenseInfo(this, t.getObject()));
        }
        ExtractedLicenseInfo[] nonStandardLicenses = new ExtractedLicenseInfo[alLic.size()];
        nonStandardLicenses = alLic.toArray(nonStandardLicenses);
        return nonStandardLicenses;
    }

    public void setExtractedLicenseInfos(ExtractedLicenseInfo[] nonStandardLicenses) throws InvalidSPDXAnalysisException {
        ArrayList<String> errors = Lists.newArrayList();
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            errors.addAll(nonStandardLicenses[i].verify());
        }
        if (errors.size() > 0) {
            StringBuilder sb = new StringBuilder("Invalid extracted license information due to the following verification failures:\n");
            for (int i = 0; i < errors.size(); ++i) {
                sb.append((String)errors.get(i));
                sb.append('\n');
            }
            throw new InvalidSPDXAnalysisException(sb.toString());
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            throw new InvalidSPDXAnalysisException("Must create the SPDX document before setting Non-Standard Licenses");
        }
        this.initializeNextLicenseRef(nonStandardLicenses);
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        Resource s = this.getResource(this.getSpdxDocNode());
        this.model.removeAll(s, p, null);
        for (int i = 0; i < nonStandardLicenses.length; ++i) {
            p = this.model.createProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
            s.addProperty(p, nonStandardLicenses[i].createResource(this));
        }
    }

    public ExtractedLicenseInfo addNewExtractedLicenseInfo(String licenseText) throws InvalidSPDXAnalysisException {
        String licenseID = this.getNextLicenseRef();
        ExtractedLicenseInfo retval = new ExtractedLicenseInfo(licenseID, licenseText);
        this.addNewExtractedLicenseInfo(retval);
        return retval;
    }

    public void addNewExtractedLicenseInfo(ExtractedLicenseInfo license) throws InvalidSPDXAnalysisException {
        if (this.extractedLicenseExists(license.getLicenseId())) {
            throw new InvalidSPDXAnalysisException("Can not add license - ID " + license.getLicenseId() + " already exists.");
        }
        Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "hasExtractedLicensingInfo");
        Resource s = this.getResource(this.getSpdxDocNode());
        s.addProperty(p, license.createResource(this));
    }

    protected boolean extractedLicenseExists(String id) throws InvalidSPDXAnalysisException {
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseId").asNode();
        Node o = NodeFactory.createLiteral(id);
        Triple m = Triple.createMatch(null, p, o);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        return tripleIter.hasNext();
    }

    public synchronized String getNextLicenseRef() {
        int nextLicNum = this.nextLicenseRef.getAndIncrement();
        return SPDXDocument.formNonStandardLicenseID(nextLicNum);
    }

    @Override
    public String getNextSpdxElementRef() {
        int nextSpdxElementNum = this.nextElementRef.getAndIncrement();
        return SPDXDocument.formSpdxElementRef(nextSpdxElementNum);
    }

    public static String formSpdxElementRef(int refNum) {
        return "SPDXRef-" + String.valueOf(refNum);
    }

    public String getSpdxDocUri() {
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode == null) {
            return null;
        }
        return spdxDocNode.toString(false);
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) throws InvalidSPDXAnalysisException {
        Model oldModel = this.model;
        this.model = model;
        try {
            List<String> errors = this.initialize();
            if (errors != null && errors.size() > 0) {
                this.model = oldModel;
                throw new InvalidSPDXAnalysisException("New model contains verification errors");
            }
        }
        catch (InvalidSPDXAnalysisException e2) {
            this.model = oldModel;
            throw e2;
        }
    }

    public void createSpdxAnalysis(String uri) throws InvalidSPDXAnalysisException {
        this.createSpdxAnalysis(uri, CURRENT_SPDX_VERSION);
    }

    public void createSpdxAnalysis(String uri, String spdxVersion) throws InvalidSPDXAnalysisException {
        String v = this.verifySpdxVersion(spdxVersion);
        if (v != null) {
            throw new InvalidSPDXAnalysisException("Invalid SPDX Version: " + v);
        }
        Node spdxDocNode = this.getSpdxDocNode();
        if (spdxDocNode != null) {
            this.model.removeAll();
        }
        this.model.setNsPrefix("spdx", "http://spdx.org/rdf/terms#");
        this.model.setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        this.model.setNsPrefix("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        this.model.setNsPrefix("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        this.documentNamespace = this.formDocNamespace(uri);
        this.model.setNsPrefix("", this.documentNamespace);
        Resource spdxAnalysisType = this.model.createResource("http://spdx.org/rdf/terms#SpdxDocument");
        this.model.createResource(uri, spdxAnalysisType);
        this.setSpdxVersion(spdxVersion);
        this.nextElementRef.set(1);
        this.nextLicenseRef.set(1);
        if (!spdxVersion.equals(POINT_EIGHT_SPDX_VERSION) && !spdxVersion.equals(POINT_NINE_SPDX_VERSION)) {
            try {
                SpdxListedLicense dataLicense = spdxVersion.equals(ONE_DOT_ZERO_SPDX_VERSION) ? (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString("PDDL-1.0") : (SpdxListedLicense)LicenseInfoFactory.parseSPDXLicenseString("CC0-1.0");
                this.setDataLicense(dataLicense);
            }
            catch (InvalidLicenseStringException e2) {
                throw new InvalidSPDXAnalysisException("Unable to create data license", e2);
            }
        }
    }

    private String formDocNamespace(String docUriString) {
        int fragmentIndex = docUriString.indexOf(35);
        if (fragmentIndex <= 0) {
            return docUriString + "#";
        }
        return docUriString.substring(0, fragmentIndex) + "#";
    }

    private Node getSpdxDocNode() {
        Node spdxDocNode = null;
        Node rdfTypePredicate = this.model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type").asNode();
        Node spdxDocObject = this.model.getProperty("http://spdx.org/rdf/terms#", "SpdxDocument").asNode();
        Triple m = Triple.createMatch(null, rdfTypePredicate, spdxDocObject);
        ExtendedIterator<Triple> tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple docTriple = (Triple)tripleIter.next();
            spdxDocNode = docTriple.getSubject();
        }
        return spdxDocNode;
    }

    @Override
    public String getDocumentNamespace() {
        return this.documentNamespace;
    }

    protected SPDXDocument getDocument() {
        return this;
    }

    public SPDXDocument getSpdxDocument() {
        return this;
    }

    @Override
    public boolean spdxElementRefExists(String elementRef) {
        return false;
    }

    @Override
    public void addSpdxElementRef(String elementRef) throws InvalidSPDXAnalysisException {
    }

    @Override
    public String documentNamespaceToId(String externalNamespace) {
        return null;
    }

    @Override
    public String externalDocumentIdToNamespace(String docId) {
        return null;
    }

    @Override
    public Resource createResource(Resource duplicate, String uri, Resource type, IRdfModel modelObject) {
        if (duplicate != null) {
            return duplicate;
        }
        if (uri == null) {
            return this.model.createResource(type);
        }
        return this.model.createResource(uri, type);
    }

    @Override
    public boolean addCheckNodeObject(Node node, IRdfModel rdfModelObject) {
        return false;
    }

    static {
        SUPPORTED_SPDX_VERSIONS.add(CURRENT_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(POINT_EIGHT_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(POINT_NINE_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ZERO_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_ONE_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(ONE_DOT_TWO_SPDX_VERSION);
        SUPPORTED_SPDX_VERSIONS.add(TWO_DOT_ZERO_DOT_ZERO_VERSION);
    }

    @Deprecated
    public class SPDXPackage {
        private SPDXDocument enclosingSpdxDocument;
        private Node node = null;

        public SPDXPackage(Node pkgNode, SPDXDocument enclosingSpdxDocument) {
            this.node = pkgNode;
            this.enclosingSpdxDocument = enclosingSpdxDocument;
        }

        public String getDeclaredName() throws InvalidSPDXAnalysisException {
            String[] declaredNames = SPDXDocument.this.findDocPropertieStringValues(this.node, "name");
            if (declaredNames == null || declaredNames.length == 0) {
                return null;
            }
            if (declaredNames.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one declared name for a package");
            }
            return declaredNames[0];
        }

        public void setDeclaredName(String declaredName) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "name");
            if (declaredName != null) {
                SPDXDocument.this.addProperty(this.node, "name", new String[]{declaredName});
            }
        }

        public String getFileName() throws InvalidSPDXAnalysisException {
            String[] fileNames = SPDXDocument.this.findDocPropertieStringValues(this.node, "packageFileName");
            if (fileNames == null || fileNames.length == 0) {
                return null;
            }
            if (fileNames.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one machine name for a package");
            }
            return fileNames[0];
        }

        public void setFileName(String fileName) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "packageFileName");
            if (fileName != null) {
                SPDXDocument.this.addProperty(this.node, "packageFileName", new String[]{fileName});
            }
        }

        public String getSha1() throws InvalidSPDXAnalysisException {
            String retval = null;
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "checksum").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                SPDXChecksum cksum = new SPDXChecksum(SPDXDocument.this.model, t.getObject());
                if (!cksum.getAlgorithm().equals("SHA1")) continue;
                retval = cksum.getValue();
            }
            return retval;
        }

        public void setSha1(String sha1) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "checksum");
            if (sha1 != null) {
                SPDXChecksum cksum = new SPDXChecksum("SHA1", sha1);
                Resource cksumResource = cksum.createResource(SPDXDocument.this.model);
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "checksum");
                s.addProperty(p, cksumResource);
            }
        }

        public String getSourceInfo() throws InvalidSPDXAnalysisException {
            String[] sourceInfos = SPDXDocument.this.findDocPropertieStringValues(this.node, "sourceInfo");
            if (sourceInfos == null || sourceInfos.length == 0) {
                return null;
            }
            if (sourceInfos.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one source info for an SPDX package");
            }
            return sourceInfos[0];
        }

        public void setSourceInfo(String sourceInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "sourceInfo");
            if (sourceInfo != null) {
                SPDXDocument.this.addProperty(this.node, "sourceInfo", new String[]{sourceInfo});
            }
        }

        public String getVersionInfo() throws InvalidSPDXAnalysisException {
            String[] versionInfos = SPDXDocument.this.findDocPropertieStringValues(this.node, "versionInfo");
            if (versionInfos == null || versionInfos.length == 0) {
                return null;
            }
            if (versionInfos.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one version info for an SPDX package");
            }
            return versionInfos[0];
        }

        public void setVersionInfo(String versionInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "versionInfo");
            if (versionInfo != null) {
                SPDXDocument.this.addProperty(this.node, "versionInfo", new String[]{versionInfo});
            }
        }

        public AnyLicenseInfo getDeclaredLicense() throws InvalidSPDXAnalysisException {
            ArrayList<AnyLicenseInfo> alLic = Lists.newArrayList();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseDeclared").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(this.enclosingSpdxDocument, t.getObject()));
            }
            if (alLic.size() > 1) {
                throw new InvalidSPDXAnalysisException("Too many declared licenses");
            }
            if (alLic.size() == 0) {
                return null;
            }
            return (AnyLicenseInfo)alLic.get(0);
        }

        public void setDeclaredLicense(AnyLicenseInfo declaredLicense) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseDeclared");
            if (declaredLicense != null) {
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseDeclared");
                Resource lic = declaredLicense.createResource(this.enclosingSpdxDocument);
                s.addProperty(p, lic);
            }
        }

        public AnyLicenseInfo getConcludedLicenses() throws InvalidSPDXAnalysisException {
            ArrayList<AnyLicenseInfo> alLic = Lists.newArrayList();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseConcluded").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(this.enclosingSpdxDocument, t.getObject()));
            }
            if (alLic.size() > 1) {
                throw new InvalidSPDXAnalysisException("Too many concluded licenses");
            }
            if (alLic.size() == 0) {
                return null;
            }
            return (AnyLicenseInfo)alLic.get(0);
        }

        public void setConcludedLicenses(AnyLicenseInfo detectedLicenses) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseConcluded");
            if (detectedLicenses != null) {
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseConcluded");
                Resource lic = detectedLicenses.createResource(this.enclosingSpdxDocument);
                s.addProperty(p, lic);
            }
        }

        public String getLicenseComment() throws InvalidSPDXAnalysisException {
            String[] comments = SPDXDocument.this.findDocPropertieStringValues(this.node, "licenseComments");
            if (comments == null || comments.length == 0) {
                return null;
            }
            if (comments.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one license comment for a package");
            }
            return comments[0];
        }

        public void setLicenseComment(String comments) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseComments");
            if (comments != null) {
                SPDXDocument.this.addProperty(this.node, "licenseComments", new String[]{comments});
            }
        }

        public String getDeclaredCopyright() throws InvalidSPDXAnalysisException {
            String[] copyrights = SPDXDocument.this.findDocPropertieStringValues(this.node, "copyrightText");
            if (copyrights == null || copyrights.length == 0) {
                return null;
            }
            if (copyrights.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one declared copyright for a package");
            }
            return copyrights[0];
        }

        public void setDeclaredCopyright(String declaredCopyright) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "copyrightText");
            if (declaredCopyright != null) {
                SPDXDocument.this.addProperty(this.node, "copyrightText", new String[]{declaredCopyright});
            }
        }

        public String getShortDescription() throws InvalidSPDXAnalysisException {
            String[] shortDescs = SPDXDocument.this.findDocPropertieStringValues(this.node, "summary");
            if (shortDescs == null || shortDescs.length == 0) {
                return null;
            }
            if (shortDescs.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one short description for a package");
            }
            return shortDescs[0];
        }

        public void setShortDescription(String shortDescription) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "summary");
            if (shortDescription != null) {
                SPDXDocument.this.addProperty(this.node, "summary", new String[]{shortDescription});
            }
        }

        public String getDescription() throws InvalidSPDXAnalysisException {
            String[] desc = SPDXDocument.this.findDocPropertieStringValues(this.node, "description");
            if (desc == null || desc.length == 0) {
                return null;
            }
            if (desc.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one description for a package");
            }
            return desc[0];
        }

        public void setDescription(String description) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "description");
            if (description != null) {
                SPDXDocument.this.addProperty(this.node, "description", new String[]{description});
            }
        }

        public void setOriginator(String originator) throws InvalidSPDXAnalysisException {
            if (originator == null) {
                SPDXDocument.this.removeProperties(this.node, "originator");
                return;
            }
            String error = SpdxVerificationHelper.verifyOriginator(originator);
            if (error != null && !error.isEmpty()) {
                throw new InvalidSPDXAnalysisException(error);
            }
            SPDXDocument.this.removeProperties(this.node, "originator");
            SPDXDocument.this.addProperty(this.node, "originator", new String[]{originator});
        }

        public void setSupplier(String supplier) throws InvalidSPDXAnalysisException {
            if (supplier == null) {
                SPDXDocument.this.removeProperties(this.node, "supplier");
                return;
            }
            String error = SpdxVerificationHelper.verifySupplier(supplier);
            if (error != null && !error.isEmpty()) {
                throw new InvalidSPDXAnalysisException(error);
            }
            SPDXDocument.this.removeProperties(this.node, "supplier");
            SPDXDocument.this.addProperty(this.node, "supplier", new String[]{supplier});
        }

        public String getOriginator() throws InvalidSPDXAnalysisException {
            String[] originators = SPDXDocument.this.findDocPropertieStringValues(this.node, "originator");
            if (originators == null || originators.length == 0) {
                return null;
            }
            if (originators.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one originator for a package");
            }
            return originators[0];
        }

        public String getSupplier() throws InvalidSPDXAnalysisException {
            String[] suppliers = SPDXDocument.this.findDocPropertieStringValues(this.node, "supplier");
            if (suppliers == null || suppliers.length == 0) {
                return null;
            }
            if (suppliers.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one supplier for a package");
            }
            return suppliers[0];
        }

        public SPDXFile[] getFiles() throws InvalidSPDXAnalysisException {
            ArrayList<SPDXFile> alFiles = Lists.newArrayList();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "hasFile").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alFiles.add(new SPDXFile(this.enclosingSpdxDocument, t.getObject()));
            }
            SPDXFile[] retval = new SPDXFile[alFiles.size()];
            return alFiles.toArray(retval);
        }

        public void setFiles(SPDXFile[] files) throws InvalidSPDXAnalysisException {
            ArrayList<Node> alFileNodes = Lists.newArrayList();
            Node n = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "hasFile").asNode();
            Triple m = Triple.createMatch(this.node, n, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alFileNodes.add(t.getObject());
            }
            SPDXDocument.this.removeProperties(this.node, "hasFile");
            SPDXDocument.this.removeProperties(SPDXDocument.this.getSpdxDocNode(), "referencesFile");
            for (Node fileNode : alFileNodes) {
                SPDXDocument.this.model.removeAll(SPDXDocument.this.getResource(fileNode), null, null);
            }
            if (files != null) {
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
                Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
                Property docP = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "referencesFile");
                for (int i = 0; i < files.length; ++i) {
                    Resource file = files[i].createResource(SPDXDocument.this.getDocument(), SPDXDocument.this.getDocumentNamespace() + SPDXDocument.this.getNextSpdxElementRef());
                    s.addProperty(p, file);
                    docResource.addProperty(docP, file);
                }
            }
        }

        public void addFile(SPDXFile file) throws InvalidSPDXAnalysisException {
            Resource s = SPDXDocument.this.getResource(this.node);
            Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
            Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
            Property docP = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "referencesFile");
            Resource fileResource = file.createResource(SPDXDocument.this.getDocument(), SPDXDocument.this.getDocumentNamespace() + SPDXDocument.this.getNextSpdxElementRef());
            s.addProperty(p, fileResource);
            docResource.addProperty(docP, fileResource);
        }

        public void removeFile(String fileName) throws InvalidSPDXAnalysisException {
            ArrayList<Node> filesToRemove = Lists.newArrayList();
            Node fileNameProperty = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "fileName").asNode();
            Property docFileProperty = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "referencesFile");
            Property pkgFileProperty = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "hasFile");
            Resource docResource = SPDXDocument.this.getResource(SPDXDocument.this.getSpdxDocNode());
            Resource pkgResource = SPDXDocument.this.getResource(this.node);
            Triple m = Triple.createMatch(SPDXDocument.this.getSpdxDocNode(), docFileProperty.asNode(), null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                Node fileObject = t.getObject();
                Triple fileNameMatch = Triple.createMatch(fileObject, fileNameProperty, null);
                ExtendedIterator<Triple> fileNameIterator = SPDXDocument.this.model.getGraph().find(fileNameMatch);
                while (fileNameIterator.hasNext()) {
                    Triple fileNameTriple = (Triple)fileNameIterator.next();
                    String searchFileName = fileNameTriple.getObject().toString(false);
                    if (!searchFileName.equals(fileName)) continue;
                    filesToRemove.add(fileObject);
                }
            }
            for (int i = 0; i < filesToRemove.size(); ++i) {
                RDFNode o = SPDXDocument.this.model.getRDFNode((Node)filesToRemove.get(i));
                SPDXDocument.this.model.removeAll(docResource, docFileProperty, o);
                SPDXDocument.this.model.removeAll(pkgResource, pkgFileProperty, o);
            }
        }

        public String getDownloadUrl() throws InvalidSPDXAnalysisException {
            String[] urls = SPDXDocument.this.findDocPropertieStringValues(this.node, "downloadLocation");
            if (urls == null || urls.length == 0) {
                return null;
            }
            if (urls.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one URL for a package");
            }
            return urls[0];
        }

        public void setDownloadUrl(String url) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "downloadLocation");
            if (url != null) {
                SPDXDocument.this.addProperty(this.node, "downloadLocation", new String[]{url});
            }
        }

        public String getHomePage() throws InvalidSPDXAnalysisException {
            String[] urls = SPDXDocument.this.findDocPropertieStringValues(this.node, "http://usefulinc.com/ns/doap#", "homepage");
            if (urls == null || urls.length == 0) {
                return null;
            }
            if (urls.length > 1) {
                throw new InvalidSPDXAnalysisException("More than one home page for a package");
            }
            return urls[0];
        }

        public void setHomePage(String url) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "http://usefulinc.com/ns/doap#", "homepage");
            if (url != null) {
                SPDXDocument.this.addProperty(this.node, "http://usefulinc.com/ns/doap#", "homepage", new String[]{url});
            }
        }

        public SpdxPackageVerificationCode getVerificationCode() throws InvalidSPDXAnalysisException {
            SpdxPackageVerificationCode retval = null;
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "packageVerificationCode").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                retval = new SpdxPackageVerificationCode(SPDXDocument.this.model, t.getObject());
            }
            return retval;
        }

        public void setVerificationCode(SpdxPackageVerificationCode verificationCode) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "packageVerificationCode");
            if (verificationCode != null) {
                Resource verificationCodeResource = verificationCode.createResource(SPDXDocument.this.model);
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "packageVerificationCode");
                s.addProperty(p, verificationCodeResource);
            }
        }

        public SPDXPackageInfo getPackageInfo() throws InvalidSPDXAnalysisException {
            return new SPDXPackageInfo(this.getDeclaredName(), this.getVersionInfo(), this.getFileName(), this.getSha1(), this.getSourceInfo(), this.getDeclaredLicense(), this.getConcludedLicenses(), this.getLicenseInfoFromFiles(), this.getLicenseComment(), this.getDeclaredCopyright(), this.getShortDescription(), this.getDescription(), this.getDownloadUrl(), this.getVerificationCode(), this.getSupplier(), this.getOriginator(), this.getHomePage());
        }

        public void setLicenseInfoFromFiles(AnyLicenseInfo[] licenseInfo) throws InvalidSPDXAnalysisException {
            SPDXDocument.this.removeProperties(this.node, "licenseInfoFromFiles");
            if (licenseInfo != null) {
                Resource s = SPDXDocument.this.getResource(this.node);
                Property p = SPDXDocument.this.model.createProperty("http://spdx.org/rdf/terms#", "licenseInfoFromFiles");
                for (int i = 0; i < licenseInfo.length; ++i) {
                    Resource lic = licenseInfo[i].createResource(this.enclosingSpdxDocument);
                    s.addProperty(p, lic);
                }
            }
        }

        public AnyLicenseInfo[] getLicenseInfoFromFiles() throws InvalidSPDXAnalysisException {
            ArrayList<AnyLicenseInfo> alLic = Lists.newArrayList();
            Node p = SPDXDocument.this.model.getProperty("http://spdx.org/rdf/terms#", "licenseInfoFromFiles").asNode();
            Triple m = Triple.createMatch(this.node, p, null);
            ExtendedIterator<Triple> tripleIter = SPDXDocument.this.model.getGraph().find(m);
            while (tripleIter.hasNext()) {
                Triple t = (Triple)tripleIter.next();
                alLic.add(LicenseInfoFactory.getLicenseInfoFromModel(this.enclosingSpdxDocument, t.getObject()));
            }
            AnyLicenseInfo[] retval = new AnyLicenseInfo[alLic.size()];
            retval = alLic.toArray(retval);
            return retval;
        }

        public SPDXPackage clone(SPDXDocument docToCloneTo, String packageUri) throws InvalidSPDXAnalysisException {
            if (docToCloneTo.getExtractedLicenseInfos() != null && docToCloneTo.getExtractedLicenseInfos().length > 0) {
                throw new InvalidSPDXAnalysisException("Can not clone a package to an SPDX document with existing licenses");
            }
            if (docToCloneTo.getFileReferences() != null && docToCloneTo.getFileReferences().length > 0) {
                throw new InvalidSPDXAnalysisException("Can not clone a package to an SPDX document with existing files");
            }
            SPDXPackage retval = docToCloneTo.createSpdxPackage(packageUri);
            ExtractedLicenseInfo[] extractedLicenseInfos = SPDXDocument.this.getExtractedLicenseInfos();
            if (extractedLicenseInfos != null) {
                docToCloneTo.setExtractedLicenseInfos(extractedLicenseInfos);
                docToCloneTo.initializeNextLicenseRef(extractedLicenseInfos);
            }
            retval.setConcludedLicenses(this.getConcludedLicenses().clone());
            retval.setDeclaredCopyright(this.getDeclaredCopyright());
            retval.setDeclaredLicense(this.getDeclaredLicense().clone());
            retval.setDeclaredName(this.getDeclaredName());
            retval.setDescription(this.getDescription());
            retval.setDownloadUrl(this.getDownloadUrl());
            retval.setFileName(this.getFileName());
            SPDXFile[] myFiles = this.getFiles();
            if (myFiles != null) {
                SPDXFile[] clonedFiles = new SPDXFile[myFiles.length];
                for (int i = 0; i < clonedFiles.length; ++i) {
                    clonedFiles[i] = myFiles[i].clone(docToCloneTo, docToCloneTo.getDocumentNamespace() + docToCloneTo.getNextSpdxElementRef());
                }
                retval.setFiles(clonedFiles);
            }
            retval.setHomePage(this.getHomePage());
            retval.setLicenseComment(this.getLicenseComment());
            AnyLicenseInfo[] licenseInfosFromFiles = this.getLicenseInfoFromFiles();
            if (licenseInfosFromFiles != null) {
                AnyLicenseInfo[] clonedLicenseInfosFromFiles = new AnyLicenseInfo[licenseInfosFromFiles.length];
                for (int i = 0; i < clonedLicenseInfosFromFiles.length; ++i) {
                    clonedLicenseInfosFromFiles[i] = licenseInfosFromFiles[i].clone();
                }
                retval.setLicenseInfoFromFiles(clonedLicenseInfosFromFiles);
            }
            retval.setOriginator(this.getOriginator());
            retval.setSha1(this.getSha1());
            retval.setShortDescription(this.getShortDescription());
            retval.setSourceInfo(this.getSourceInfo());
            retval.setSupplier(this.getSupplier());
            retval.setVerificationCode(this.getVerificationCode());
            retval.setVersionInfo(this.getVersionInfo());
            return retval;
        }

        public List<String> verify() {
            String e22;
            ArrayList<String> retval = Lists.newArrayList();
            try {
                String name = this.getDeclaredName();
                if (name == null || name.isEmpty()) {
                    retval.add("Missing required name for package");
                }
            }
            catch (InvalidSPDXAnalysisException e22) {
                retval.add("Invalid name: " + e22.getMessage());
            }
            try {
                e22 = this.getShortDescription();
            }
            catch (InvalidSPDXAnalysisException e3) {
                retval.add("Invalid summary: " + e3.getMessage());
            }
            try {
                e22 = this.getDescription();
            }
            catch (InvalidSPDXAnalysisException e4) {
                retval.add("Invalid description: " + e4.getMessage());
            }
            try {
                String downloadLocation = this.getDownloadUrl();
                if (downloadLocation == null || downloadLocation.isEmpty()) {
                    retval.add("Missing required download location for package");
                }
            }
            catch (InvalidSPDXAnalysisException e5) {
                retval.add("Invalid download location: " + e5.getMessage());
            }
            try {
                String verify;
                String checksum = this.getSha1();
                if (checksum != null && !checksum.isEmpty() && (verify = SpdxVerificationHelper.verifyChecksumString(checksum)) != null) {
                    retval.add("Package checksum error: " + verify);
                }
            }
            catch (InvalidSPDXAnalysisException e6) {
                retval.add("Invalid checksum: " + e6.getMessage());
            }
            try {
                e22 = this.getSourceInfo();
            }
            catch (InvalidSPDXAnalysisException e7) {
                retval.add("Invalid package source info: " + e7.getMessage());
            }
            try {
                String copyrightText = this.getDeclaredCopyright();
                if (copyrightText == null || copyrightText.isEmpty()) {
                    retval.add("Missing required package copyright text");
                }
            }
            catch (InvalidSPDXAnalysisException e8) {
                retval.add("Invalid package copyright: " + e8.getMessage());
            }
            try {
                e22 = this.getLicenseComment();
            }
            catch (InvalidSPDXAnalysisException e9) {
                retval.add("Invalid license comments: " + e9.getMessage());
            }
            try {
                AnyLicenseInfo declaredLicense = this.getDeclaredLicense();
                if (declaredLicense == null) {
                    retval.add("Missing required declared license");
                } else {
                    retval.addAll(declaredLicense.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e10) {
                retval.add("Invalid package declared license: " + e10.getMessage());
            }
            try {
                AnyLicenseInfo concludedLicense = this.getConcludedLicenses();
                if (concludedLicense == null) {
                    retval.add("Missing required concluded license");
                } else {
                    retval.addAll(concludedLicense.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e11) {
                retval.add("Invalid package concluded license: " + e11.getMessage());
            }
            try {
                AnyLicenseInfo[] licenseInfosFromFiles = this.getLicenseInfoFromFiles();
                if (licenseInfosFromFiles == null || licenseInfosFromFiles.length == 0) {
                    retval.add("Missing required license information from files");
                } else {
                    for (int i = 0; i < licenseInfosFromFiles.length; ++i) {
                        retval.addAll(licenseInfosFromFiles[i].verify());
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e12) {
                retval.add("Invalid package license information from files: " + e12.getMessage());
            }
            try {
                SPDXFile[] files = this.getFiles();
                if (files == null || files.length == 0) {
                    retval.add("Missing required package files");
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        retval.addAll(files[i].verify());
                    }
                }
            }
            catch (InvalidSPDXAnalysisException e13) {
                retval.add("Invalid package files: " + e13.getMessage());
            }
            SpdxPackageVerificationCode verificationCode = null;
            try {
                verificationCode = this.getVerificationCode();
                if (verificationCode == null) {
                    retval.add("Missing required package verification code.");
                } else {
                    retval.addAll(verificationCode.verify());
                }
            }
            catch (InvalidSPDXAnalysisException e14) {
                retval.add("Invalid package verification code: " + e14.getMessage());
            }
            String supplier = null;
            try {
                String error;
                supplier = this.getSupplier();
                if (supplier != null && (error = SpdxVerificationHelper.verifySupplier(supplier)) != null && !error.isEmpty()) {
                    retval.add("Supplier error - " + error);
                }
            }
            catch (InvalidSPDXAnalysisException e15) {
                retval.add("Invalid supplier: " + e15.getMessage());
            }
            String originator = null;
            try {
                String error;
                originator = this.getOriginator();
                if (originator != null && (error = SpdxVerificationHelper.verifyOriginator(originator)) != null && !error.isEmpty()) {
                    retval.add("Originator error - " + error);
                }
            }
            catch (InvalidSPDXAnalysisException e16) {
                retval.add("Invalid originator: " + e16.getMessage());
            }
            return retval;
        }
    }
}

