/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.model.Relationship;
import org.spdx.rdfparser.model.SpdxElement;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class RelationshipsSheet
extends AbstractSheet {
    static final int ID_COL = 0;
    static final int RELATIONSHIP_COL = 1;
    static final int RELATED_ID_COL = 2;
    static final int COMMENT_COL = 3;
    static final int USER_DEFINED_COL = 4;
    static final int NUM_COLS = 4;
    static final String[] HEADER_TITLES = new String[]{"SPDX Identifier A", "Relationship", "SPDX Identifier B", "Relationship Comment", "Optional User Defined Columns..."};
    static final int[] COLUMN_WIDTHS = new int[]{20, 25, 20, 70, 50};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, false, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, true, false, false};
    static final boolean[] REQUIRED = new boolean[]{true, true, true, false, false};

    public RelationshipsSheet(Workbook workbook, String relationshipsSheetName) {
        super(workbook, relationshipsSheetName);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for Relationships does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 4; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for Relationship worksheet";
            }
            boolean done = false;
            int rowNum = this.firstRowNum + 1;
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying Relationship worksheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 4; ++i) {
            Cell cell = row.getCell(i);
            if (REQUIRED[i] && cell == null) {
                return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum()) + " in relationships sheet";
            }
            if (i != 1 || cell.getStringCellValue() == null) continue;
            try {
                Relationship.RelationshipType.fromTag(cell.getStringCellValue());
                continue;
            }
            catch (IllegalArgumentException ex) {
                return "Invalid relationship type in row " + String.valueOf(row) + ": " + cell.getStringCellValue();
            }
        }
        return null;
    }

    public static void create(Workbook wb, String sheetName) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(Relationship relationship, String elementId) {
        Row row = this.addRow();
        if (elementId != null) {
            Cell idCell = row.createCell(0, CellType.STRING);
            idCell.setCellValue(elementId);
        }
        if (relationship.getRelationshipType() != null) {
            Cell relationshipCell = row.createCell(1, CellType.STRING);
            relationshipCell.setCellValue(relationship.getRelationshipType().toTag());
        }
        if (relationship.getRelatedSpdxElement() != null) {
            Cell relatedIdCell = row.createCell(2, CellType.STRING);
            relatedIdCell.setCellValue(relationship.getRelatedSpdxElement().getId());
        }
        if (relationship.getComment() != null) {
            Cell commentCell = row.createCell(3, CellType.STRING);
            commentCell.setCellValue(relationship.getComment());
        }
    }

    public String getElmementId(int rowNum) {
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        return row.getCell(0).getStringCellValue();
    }

    public Relationship getRelationship(int rowNum, SpdxDocumentContainer container2) throws SpreadsheetException {
        SpdxElement element;
        Row row = this.sheet.getRow(rowNum);
        if (row == null) {
            return null;
        }
        Cell relatedIdCell = row.getCell(2);
        String relatedId = null;
        if (relatedIdCell != null && relatedIdCell.getStringCellValue() != null) {
            relatedId = relatedIdCell.getStringCellValue();
        }
        Relationship.RelationshipType type = null;
        Cell relationshipCell = row.getCell(1);
        if (relationshipCell != null && relationshipCell.getStringCellValue() != null) {
            type = Relationship.RelationshipType.fromTag(relationshipCell.getStringCellValue().trim());
        }
        Cell commentCell = row.getCell(3);
        String comment = null;
        if (commentCell != null && commentCell.getStringCellValue() != null) {
            comment = commentCell.getStringCellValue();
        }
        if (relatedId == null) {
            throw new SpreadsheetException("No related element ID for relationship");
        }
        try {
            element = container2.findElementById(relatedId);
        }
        catch (InvalidSPDXAnalysisException e2) {
            throw new SpreadsheetException("No element found for relationship with related ID " + relatedId);
        }
        return new Relationship(element, type, comment);
    }
}

