/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools.licensegenerator;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.spdx.compare.CompareTemplateOutputHandler;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.compare.SpdxCompareException;
import org.spdx.rdfparser.license.License;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.tools.licensegenerator.ILicenseTester;

public class LicenseTester
implements ILicenseTester {
    private Map<String, File> licenseIdToTestMap = new HashMap<String, File>();
    private static FileFilter testFileFilter = new FileFilter(){

        @Override
        public boolean accept(File arg0) {
            return arg0.isFile() && arg0.getName().toLowerCase().endsWith(".txt");
        }
    };

    public LicenseTester(File licenseTestDirectory) {
        File[] licenseIdDirs = licenseTestDirectory.listFiles();
        if (licenseIdDirs != null) {
            for (File dir : licenseIdDirs) {
                if (!dir.isDirectory()) continue;
                this.licenseIdToTestMap.put(dir.getName(), dir);
            }
        }
    }

    @Override
    public List<String> testLicense(License license) throws IOException, SpdxCompareException {
        File[] negativeTests;
        File negativeTestDir;
        File[] positiveTests;
        ArrayList<String> retval = new ArrayList<String>();
        File licenseDir = this.licenseIdToTestMap.get(license.getLicenseId());
        if (licenseDir == null || !licenseDir.exists()) {
            return retval;
        }
        File positiveTestDir = new File(licenseDir.getPath() + File.separator + "license" + File.separator + "good");
        if (positiveTestDir.exists() && positiveTestDir.isDirectory() && (positiveTests = positiveTestDir.listFiles(testFileFilter)) != null) {
            for (File test : positiveTests) {
                String text = this.readText(test);
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense(license, text);
                if (!result.isDifferenceFound()) continue;
                retval.add("Test 'positive-" + test.toPath().getFileName() + "' failed due to difference found " + result.getDifferenceMessage());
            }
        }
        if ((negativeTestDir = new File(licenseDir.getPath() + File.separator + "bad")).exists() && negativeTestDir.isDirectory() && (negativeTests = negativeTestDir.listFiles(testFileFilter)) != null) {
            for (File test : negativeTests) {
                String text = this.readText(test);
                CompareTemplateOutputHandler.DifferenceDescription result = LicenseCompareHelper.isTextStandardLicense(license, text);
                if (result.isDifferenceFound()) continue;
                retval.add("Test 'negative-" + test.toPath().getFileName() + "' failed - no difference found");
            }
        }
        return retval;
    }

    private String readText(File f) throws IOException {
        StringBuilder text = new StringBuilder();
        Files.lines(f.toPath()).forEach(line -> {
            text.append((String)line);
            text.append("\n");
        });
        return text.toString();
    }

    @Override
    public List<String> testException(LicenseException exception) throws IOException {
        File[] negativeTests;
        File negativeTestDir;
        File[] positiveTests;
        ArrayList<String> retval = new ArrayList<String>();
        File exceptionDir = this.licenseIdToTestMap.get(exception.getLicenseExceptionId());
        if (exceptionDir == null || !exceptionDir.exists()) {
            return retval;
        }
        File positiveTestDir = new File(exceptionDir.getPath() + File.separator + "exception" + File.separator + "good");
        if (positiveTestDir.exists() && positiveTestDir.isDirectory() && (positiveTests = positiveTestDir.listFiles(testFileFilter)) != null) {
            for (File test : positiveTests) {
                String text = this.readText(test);
                if (LicenseCompareHelper.isLicenseTextEquivalent(text, exception.getLicenseExceptionText())) continue;
                retval.add("Test 'positive-" + test.toPath().getFileName() + "' failed due to difference found");
            }
        }
        if ((negativeTestDir = new File(exceptionDir.getPath() + File.separator + "bad")).exists() && negativeTestDir.isDirectory() && (negativeTests = negativeTestDir.listFiles(testFileFilter)) != null) {
            for (File test : negativeTests) {
                String text = this.readText(test);
                if (!LicenseCompareHelper.isLicenseTextEquivalent(text, exception.getLicenseExceptionText())) continue;
                retval.add("Test 'negative-" + test.toPath().getFileName() + "' failed - no difference found");
            }
        }
        return retval;
    }
}

