/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.fasterxml.jackson.core.JsonParseException;
import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.impl.client.CloseableHttpClient;

public class DocumentLoader {
    public static final String DISALLOW_REMOTE_CONTEXT_LOADING = "com.github.jsonldjava.disallowRemoteContextLoading";
    @Deprecated
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private volatile CloseableHttpClient httpClient;

    public RemoteDocument loadDocument(String url) throws JsonLdError {
        String disallowRemote = System.getProperty(DISALLOW_REMOTE_CONTEXT_LOADING);
        if ("true".equalsIgnoreCase(disallowRemote)) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, url);
        }
        RemoteDocument doc = new RemoteDocument(url, null);
        try {
            doc.setDocument(this.fromURL(new URL(url)));
        }
        catch (Exception e2) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, url);
        }
        return doc;
    }

    public Object fromURL(URL url) throws JsonParseException, IOException {
        return JsonUtils.fromURL(url, this.getHttpClient());
    }

    public InputStream openStreamFromURL(URL url) throws IOException {
        return JsonUtils.openStreamForURL(url, this.getHttpClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableHttpClient getHttpClient() {
        CloseableHttpClient result = this.httpClient;
        if (result != null) return result;
        Class<DocumentLoader> clazz = DocumentLoader.class;
        synchronized (DocumentLoader.class) {
            result = this.httpClient;
            if (result != null) return result;
            this.httpClient = JsonUtils.getDefaultHttpClient();
            return this.httpClient;
        }
    }

    public void setHttpClient(CloseableHttpClient nextHttpClient) {
        this.httpClient = nextHttpClient;
    }
}

