/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava;

import com.github.mustachejava.DefaultMustacheVisitor;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.MustacheFactory;
import com.github.mustachejava.MustacheParser;
import com.github.mustachejava.MustacheVisitor;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;

public class DefaultMustacheFactory
implements MustacheFactory {
    private final MustacheParser mc = new MustacheParser(this);
    private final Map<String, Mustache> templateCache = new ConcurrentHashMap<String, Mustache>();
    private final LoadingCache<String, Mustache> mustacheCache = CacheBuilder.newBuilder().build(new CacheLoader<String, Mustache>(){

        @Override
        public Mustache load(String key) throws Exception {
            return DefaultMustacheFactory.this.mc.compile(key);
        }
    });
    private ObjectHandler oh = new ReflectionObjectHandler();
    private String resourceRoot;
    private File fileRoot;
    private ListeningExecutorService les;
    private static Pattern escapedPattern = Pattern.compile("^&\\w+;");

    public DefaultMustacheFactory() {
    }

    public DefaultMustacheFactory(String resourceRoot) {
        if (!resourceRoot.endsWith("/")) {
            resourceRoot = resourceRoot + "/";
        }
        this.resourceRoot = resourceRoot;
    }

    public DefaultMustacheFactory(File fileRoot) {
        if (!fileRoot.exists()) {
            throw new MustacheException(fileRoot + " does not exist");
        }
        if (!fileRoot.isDirectory()) {
            throw new MustacheException(fileRoot + " is not a directory");
        }
        this.fileRoot = fileRoot;
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new DefaultMustacheVisitor(this);
    }

    @Override
    public Reader getReader(String resourceName) {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        InputStream is = ccl.getResourceAsStream((this.resourceRoot == null ? "" : this.resourceRoot) + resourceName);
        if (is == null) {
            File file;
            File file2 = file = this.fileRoot == null ? new File(resourceName) : new File(this.fileRoot, resourceName);
            if (file.exists() && file.isFile()) {
                try {
                    return new BufferedReader(new FileReader(file));
                }
                catch (FileNotFoundException e2) {
                    throw new MustacheException("Found file, could not open: " + file, e2);
                }
            }
            throw new MustacheException("Template " + resourceName + " not found");
        }
        return new BufferedReader(new InputStreamReader(is, Charset.forName("utf-8")));
    }

    @Override
    public void encode(String value, Writer writer) {
        try {
            int position = 0;
            int length = value.length();
            block10: for (int i = 0; i < length; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '&': {
                        if (!escapedPattern.matcher(value.substring(i, length)).find()) {
                            position = this.append(value, writer, position, i, "&amp;");
                            continue block10;
                        }
                        if (position == 0) continue block10;
                        position = this.append(value, writer, position, i, "&");
                        continue block10;
                    }
                    case '\\': {
                        position = this.append(value, writer, position, i, "\\\\");
                        continue block10;
                    }
                    case '\"': {
                        position = this.append(value, writer, position, i, "&quot;");
                        continue block10;
                    }
                    case '<': {
                        position = this.append(value, writer, position, i, "&lt;");
                        continue block10;
                    }
                    case '>': {
                        position = this.append(value, writer, position, i, "&gt;");
                        continue block10;
                    }
                    case '\n': {
                        position = this.append(value, writer, position, i, "&#10;");
                    }
                }
            }
            writer.append(value, position, length);
        }
        catch (IOException e2) {
            throw new MustacheException("Failed to encode value: " + value);
        }
    }

    private int append(String value, Writer writer, int position, int i, String replace) throws IOException {
        writer.append(value, position, i);
        writer.append(replace);
        return i + 1;
    }

    @Override
    public ObjectHandler getObjectHandler() {
        return this.oh;
    }

    public void setObjectHandler(ObjectHandler oh) {
        this.oh = oh;
    }

    public ExecutorService getExecutorService() {
        return this.les;
    }

    public void setExecutorService(ExecutorService es) {
        this.les = es instanceof ListeningExecutorService ? (ListeningExecutorService)es : MoreExecutors.listeningDecorator(es);
    }

    public Mustache getTemplate(String templateText) {
        return this.templateCache.get(templateText);
    }

    public void putTemplate(String templateText, Mustache mustache) {
        this.templateCache.put(templateText, mustache);
    }

    @Override
    public Mustache compile(String name) {
        try {
            Mustache mustache = this.mustacheCache.get(name);
            mustache.init();
            return mustache;
        }
        catch (ExecutionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof MustacheException) {
                throw (MustacheException)cause;
            }
            throw new MustacheException(cause);
        }
    }

    @Override
    public Mustache compile(Reader reader, String name) {
        return this.compile(reader, name, "{{", "}}");
    }

    public Mustache compile(Reader reader, String file, String sm, String em) {
        Mustache compile = this.mc.compile(reader, file, sm, em);
        compile.init();
        return compile;
    }

    @Override
    public String translate(String from) {
        return from;
    }
}

