/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.iri.IRI;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.checker.CheckerIRI;
import org.apache.jena.riot.checker.CheckerLiterals;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfileBase;
import org.apache.jena.riot.system.Prologue;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.FmtUtils;

public class ParserProfileChecker
extends ParserProfileBase {
    private boolean checkLiterals = true;

    public ParserProfileChecker(Prologue prologue, ErrorHandler errorHandler) {
        super(prologue, errorHandler);
    }

    public ParserProfileChecker(Prologue prologue, ErrorHandler errorHandler, FactoryRDF factory) {
        super(prologue, errorHandler, factory);
    }

    @Override
    public String resolveIRI(String uriStr, long line, long col) {
        return this.makeIRI(uriStr, line, col).toString();
    }

    @Override
    public IRI makeIRI(String uriStr, long line, long col) {
        IRI iri = this.prologue.getResolver().resolveSilent(uriStr);
        if (uriStr.contains(" ")) {
            this.errorHandler.warning("Bad IRI: <" + uriStr + "> Spaces are not legal in URIs/IRIs.", line, col);
            return iri;
        }
        CheckerIRI.iriViolations(iri, this.errorHandler, line, col);
        return iri;
    }

    @Override
    public Triple createTriple(Node subject, Node predicate, Node object, long line, long col) {
        this.checkTriple(subject, predicate, object, line, col);
        return super.createTriple(subject, predicate, object, line, col);
    }

    private void checkTriple(Node subject, Node predicate, Node object, long line, long col) {
        if (subject == null || !subject.isURI() && !subject.isBlank()) {
            this.errorHandler.error("Subject is not a URI or blank node", line, col);
            throw new RiotException("Bad subject: " + subject);
        }
        if (predicate == null || !predicate.isURI()) {
            this.errorHandler.error("Predicate not a URI", line, col);
            throw new RiotException("Bad predicate: " + predicate);
        }
        if (object == null || !object.isURI() && !object.isBlank() && !object.isLiteral()) {
            this.errorHandler.error("Object is not a URI, blank node or literal", line, col);
            throw new RiotException("Bad object: " + object);
        }
    }

    @Override
    public Quad createQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        this.checkQuad(graph, subject, predicate, object, line, col);
        return super.createQuad(graph, subject, predicate, object, line, col);
    }

    private void checkQuad(Node graph, Node subject, Node predicate, Node object, long line, long col) {
        if (graph != null && !graph.isURI() && !graph.isBlank()) {
            this.errorHandler.error("Graph name is not a URI or blank node: " + FmtUtils.stringForNode(graph), line, col);
            throw new RiotException("Bad graph name: " + graph);
        }
        this.checkTriple(subject, predicate, object, line, col);
    }

    @Override
    public Node createURI(String x, long line, long col) {
        if (!RiotLib.isBNodeIRI(x) && !RiotLib.isPrefixIRI(x)) {
            x = this.resolveIRI(x, line, col);
        }
        return super.createURI(x, line, col);
    }

    @Override
    public Node createTypedLiteral(String lexical, RDFDatatype datatype, long line, long col) {
        Node n = NodeFactory.createLiteral(lexical, datatype);
        CheckerLiterals.checkLiteral(lexical, datatype, this.errorHandler, line, col);
        return n;
    }

    @Override
    public Node createLangLiteral(String lexical, String langTag, long line, long col) {
        Node n = NodeFactory.createLiteral(lexical, langTag);
        CheckerLiterals.checkLiteral(lexical, langTag, this.errorHandler, line, col);
        return n;
    }
}

