/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.hslf.blip.EMF;
import org.apache.poi.hslf.blip.PICT;
import org.apache.poi.hslf.blip.WMF;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.usermodel.XSLFRelation;

public final class XSLFPictureData
extends POIXMLDocumentPart
implements PictureData {
    private static final POILogger logger = POILogFactory.getLogger(XSLFPictureData.class);
    private Long checksum = null;
    private Dimension origSize = null;
    private int index = -1;

    protected XSLFPictureData() {
    }

    public XSLFPictureData(PackagePart part) {
        super(part);
    }

    @Deprecated
    public XSLFPictureData(PackagePart part, PackageRelationship rel) {
        this(part);
    }

    public InputStream getInputStream() throws IOException {
        return this.getPackagePart().getInputStream();
    }

    @Override
    public byte[] getData() {
        try {
            return IOUtils.toByteArray(this.getInputStream());
        }
        catch (IOException e2) {
            throw new POIXMLException(e2);
        }
    }

    public String getFileName() {
        String name = this.getPackagePart().getPartName().getName();
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public String suggestFileExtension() {
        return this.getPackagePart().getPartName().getExtension();
    }

    @Override
    public byte[] getChecksum() {
        this.cacheProperties();
        byte[] cs = new byte[8];
        LittleEndian.putLong(cs, 0, this.checksum);
        return cs;
    }

    @Override
    public Dimension getImageDimension() {
        this.cacheProperties();
        return this.origSize;
    }

    @Override
    public Dimension getImageDimensionInPixels() {
        Dimension dim = this.getImageDimension();
        return new Dimension(Units.pointsToPixel(dim.getWidth()), Units.pointsToPixel(dim.getHeight()));
    }

    protected void cacheProperties() {
        if (this.origSize == null || this.checksum == null) {
            byte[] data = this.getData();
            this.checksum = IOUtils.calculateChecksum(data);
            PictureData.PictureType pt = this.getType();
            if (pt == null) {
                this.origSize = new Dimension(1, 1);
                return;
            }
            switch (pt) {
                case EMF: {
                    this.origSize = new EMF.NativeHeader(data, 0).getSize();
                    break;
                }
                case WMF: {
                    this.origSize = new WMF.NativeHeader(data, 0).getSize();
                    break;
                }
                case PICT: {
                    this.origSize = new PICT.NativeHeader(data, 0).getSize();
                    break;
                }
                default: {
                    BufferedImage img = null;
                    try {
                        img = ImageIO.read(new ByteArrayInputStream(data));
                    }
                    catch (IOException e2) {
                        logger.log(5, new Object[]{"Can't determine image dimensions", e2});
                    }
                    this.origSize = img == null ? new Dimension(200, 200) : new Dimension((int)Units.pixelToPoints(img.getWidth()), (int)Units.pixelToPoints(img.getHeight()));
                }
            }
        }
    }

    @Override
    protected void prepareForCommit() {
    }

    @Override
    public String getContentType() {
        return this.getPackagePart().getContentType();
    }

    @Override
    public void setData(byte[] data) throws IOException {
        OutputStream os = this.getPackagePart().getOutputStream();
        os.write(data);
        os.close();
        this.checksum = IOUtils.calculateChecksum(data);
        this.origSize = null;
    }

    @Override
    public PictureData.PictureType getType() {
        String ct = this.getContentType();
        if (XSLFRelation.IMAGE_EMF.getContentType().equals(ct)) {
            return PictureData.PictureType.EMF;
        }
        if (XSLFRelation.IMAGE_WMF.getContentType().equals(ct)) {
            return PictureData.PictureType.WMF;
        }
        if (XSLFRelation.IMAGE_PICT.getContentType().equals(ct)) {
            return PictureData.PictureType.PICT;
        }
        if (XSLFRelation.IMAGE_JPEG.getContentType().equals(ct)) {
            return PictureData.PictureType.JPEG;
        }
        if (XSLFRelation.IMAGE_PNG.getContentType().equals(ct)) {
            return PictureData.PictureType.PNG;
        }
        if (XSLFRelation.IMAGE_DIB.getContentType().equals(ct)) {
            return PictureData.PictureType.DIB;
        }
        if (XSLFRelation.IMAGE_GIF.getContentType().equals(ct)) {
            return PictureData.PictureType.GIF;
        }
        if (XSLFRelation.IMAGE_EPS.getContentType().equals(ct)) {
            return PictureData.PictureType.EPS;
        }
        if (XSLFRelation.IMAGE_BMP.getContentType().equals(ct)) {
            return PictureData.PictureType.BMP;
        }
        if (XSLFRelation.IMAGE_WPG.getContentType().equals(ct)) {
            return PictureData.PictureType.WPG;
        }
        if (XSLFRelation.IMAGE_WDP.getContentType().equals(ct)) {
            return PictureData.PictureType.WDP;
        }
        if (XSLFRelation.IMAGE_TIFF.getContentType().equals(ct)) {
            return PictureData.PictureType.TIFF;
        }
        return null;
    }

    static XSLFRelation getRelationForType(PictureData.PictureType pt) {
        switch (pt) {
            case EMF: {
                return XSLFRelation.IMAGE_EMF;
            }
            case WMF: {
                return XSLFRelation.IMAGE_WMF;
            }
            case PICT: {
                return XSLFRelation.IMAGE_PICT;
            }
            case JPEG: {
                return XSLFRelation.IMAGE_JPEG;
            }
            case PNG: {
                return XSLFRelation.IMAGE_PNG;
            }
            case DIB: {
                return XSLFRelation.IMAGE_DIB;
            }
            case GIF: {
                return XSLFRelation.IMAGE_GIF;
            }
            case EPS: {
                return XSLFRelation.IMAGE_EPS;
            }
            case BMP: {
                return XSLFRelation.IMAGE_BMP;
            }
            case WPG: {
                return XSLFRelation.IMAGE_WPG;
            }
            case WDP: {
                return XSLFRelation.IMAGE_WDP;
            }
            case TIFF: {
                return XSLFRelation.IMAGE_TIFF;
            }
        }
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

