/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.util.Internal;
import org.apache.poi.util.Removal;
import org.apache.poi.xssf.usermodel.XSSFAnchor;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;

public final class XSSFClientAnchor
extends XSSFAnchor
implements ClientAnchor {
    private ClientAnchor.AnchorType DEFAULT_ANCHOR_TYPE;
    private ClientAnchor.AnchorType anchorType;
    private CTMarker cell1;
    private CTMarker cell2;

    public XSSFClientAnchor() {
        this.anchorType = this.DEFAULT_ANCHOR_TYPE = ClientAnchor.AnchorType.MOVE_AND_RESIZE;
        this.cell1 = CTMarker.Factory.newInstance();
        this.cell1.setCol(0);
        this.cell1.setColOff(0L);
        this.cell1.setRow(0);
        this.cell1.setRowOff(0L);
        this.cell2 = CTMarker.Factory.newInstance();
        this.cell2.setCol(0);
        this.cell2.setColOff(0L);
        this.cell2.setRow(0);
        this.cell2.setRowOff(0L);
    }

    public XSSFClientAnchor(int dx1, int dy1, int dx2, int dy2, int col1, int row1, int col2, int row2) {
        this();
        this.cell1.setCol(col1);
        this.cell1.setColOff(dx1);
        this.cell1.setRow(row1);
        this.cell1.setRowOff(dy1);
        this.cell2.setCol(col2);
        this.cell2.setColOff(dx2);
        this.cell2.setRow(row2);
        this.cell2.setRowOff(dy2);
    }

    protected XSSFClientAnchor(CTMarker cell1, CTMarker cell2) {
        this.anchorType = this.DEFAULT_ANCHOR_TYPE = ClientAnchor.AnchorType.MOVE_AND_RESIZE;
        this.cell1 = cell1;
        this.cell2 = cell2;
    }

    @Override
    public short getCol1() {
        return (short)this.cell1.getCol();
    }

    @Override
    public void setCol1(int col1) {
        this.cell1.setCol(col1);
    }

    @Override
    public short getCol2() {
        return (short)this.cell2.getCol();
    }

    @Override
    public void setCol2(int col2) {
        this.cell2.setCol(col2);
    }

    @Override
    public int getRow1() {
        return this.cell1.getRow();
    }

    @Override
    public void setRow1(int row1) {
        this.cell1.setRow(row1);
    }

    @Override
    public int getRow2() {
        return this.cell2.getRow();
    }

    @Override
    public void setRow2(int row2) {
        this.cell2.setRow(row2);
    }

    @Override
    public int getDx1() {
        return (int)this.cell1.getColOff();
    }

    @Override
    public void setDx1(int dx1) {
        this.cell1.setColOff(dx1);
    }

    @Override
    public int getDy1() {
        return (int)this.cell1.getRowOff();
    }

    @Override
    public void setDy1(int dy1) {
        this.cell1.setRowOff(dy1);
    }

    @Override
    public int getDy2() {
        return (int)this.cell2.getRowOff();
    }

    @Override
    public void setDy2(int dy2) {
        this.cell2.setRowOff(dy2);
    }

    @Override
    public int getDx2() {
        return (int)this.cell2.getColOff();
    }

    @Override
    public void setDx2(int dx2) {
        this.cell2.setColOff(dx2);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSSFClientAnchor)) {
            return false;
        }
        XSSFClientAnchor anchor = (XSSFClientAnchor)o;
        return this.getDx1() == anchor.getDx1() && this.getDx2() == anchor.getDx2() && this.getDy1() == anchor.getDy1() && this.getDy2() == anchor.getDy2() && this.getCol1() == anchor.getCol1() && this.getCol2() == anchor.getCol2() && this.getRow1() == anchor.getRow1() && this.getRow2() == anchor.getRow2();
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    public String toString() {
        return "from : " + this.cell1.toString() + "; to: " + this.cell2.toString();
    }

    @Internal
    public CTMarker getFrom() {
        return this.cell1;
    }

    protected void setFrom(CTMarker from) {
        this.cell1 = from;
    }

    @Internal
    public CTMarker getTo() {
        return this.cell2;
    }

    protected void setTo(CTMarker to) {
        this.cell2 = to;
    }

    @Override
    public void setAnchorType(ClientAnchor.AnchorType anchorType) {
        this.anchorType = anchorType;
    }

    @Override
    @Removal(version="3.17")
    public void setAnchorType(int anchorType) {
        this.anchorType = ClientAnchor.AnchorType.byId(anchorType);
    }

    @Override
    public ClientAnchor.AnchorType getAnchorType() {
        return this.anchorType;
    }

    public boolean isSet() {
        return this.cell1.getCol() != 0 || this.cell2.getCol() != 0 || this.cell1.getRow() != 0 || this.cell2.getRow() != 0;
    }
}

