/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.math.BigDecimal;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl;
import org.apache.xerces.xs.datatypes.XSDateTime;

public abstract class AbstractDateTimeDV
extends TypeValidator {
    private static final boolean DEBUG = false;
    protected static final int YEAR = 2000;
    protected static final int MONTH = 1;
    protected static final int DAY = 1;
    protected static final DatatypeFactory datatypeFactory = new DatatypeFactoryImpl();

    public short getAllowedFacets() {
        return 2552;
    }

    public boolean isIdentical(Object value1, Object value2) {
        if (!(value1 instanceof DateTimeData) || !(value2 instanceof DateTimeData)) {
            return false;
        }
        DateTimeData v1 = (DateTimeData)value1;
        DateTimeData v2 = (DateTimeData)value2;
        if (v1.timezoneHr == v2.timezoneHr && v1.timezoneMin == v2.timezoneMin) {
            return v1.equals(v2);
        }
        return false;
    }

    public int compare(Object value1, Object value2) {
        return this.compareDates((DateTimeData)value1, (DateTimeData)value2, true);
    }

    protected short compareDates(DateTimeData date1, DateTimeData date2, boolean strict) {
        if (date1.utc == date2.utc) {
            return this.compareOrder(date1, date2);
        }
        DateTimeData tempDate = new DateTimeData(null, this);
        if (date1.utc == 90) {
            this.cloneDate(date2, tempDate);
            tempDate.timezoneHr = 14;
            tempDate.timezoneMin = 0;
            tempDate.utc = 43;
            this.normalize(tempDate);
            short c1 = this.compareOrder(date1, tempDate);
            if (c1 == -1) {
                return c1;
            }
            this.cloneDate(date2, tempDate);
            tempDate.timezoneHr = -14;
            tempDate.timezoneMin = 0;
            tempDate.utc = 45;
            this.normalize(tempDate);
            short c2 = this.compareOrder(date1, tempDate);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        if (date2.utc == 90) {
            this.cloneDate(date1, tempDate);
            tempDate.timezoneHr = -14;
            tempDate.timezoneMin = 0;
            tempDate.utc = 45;
            this.normalize(tempDate);
            short c1 = this.compareOrder(tempDate, date2);
            if (c1 == -1) {
                return c1;
            }
            this.cloneDate(date1, tempDate);
            tempDate.timezoneHr = 14;
            tempDate.timezoneMin = 0;
            tempDate.utc = 43;
            this.normalize(tempDate);
            short c2 = this.compareOrder(tempDate, date2);
            if (c2 == 1) {
                return c2;
            }
            return 2;
        }
        return 2;
    }

    protected short compareOrder(DateTimeData date1, DateTimeData date2) {
        if (date1.position < 1) {
            if (date1.year < date2.year) {
                return -1;
            }
            if (date1.year > date2.year) {
                return 1;
            }
        }
        if (date1.position < 2) {
            if (date1.month < date2.month) {
                return -1;
            }
            if (date1.month > date2.month) {
                return 1;
            }
        }
        if (date1.day < date2.day) {
            return -1;
        }
        if (date1.day > date2.day) {
            return 1;
        }
        if (date1.hour < date2.hour) {
            return -1;
        }
        if (date1.hour > date2.hour) {
            return 1;
        }
        if (date1.minute < date2.minute) {
            return -1;
        }
        if (date1.minute > date2.minute) {
            return 1;
        }
        if (date1.second < date2.second) {
            return -1;
        }
        if (date1.second > date2.second) {
            return 1;
        }
        if (date1.utc < date2.utc) {
            return -1;
        }
        if (date1.utc > date2.utc) {
            return 1;
        }
        return 0;
    }

    protected void getTime(String buffer, int start, int end, DateTimeData data) throws RuntimeException {
        int stop = start + 2;
        data.hour = this.parseInt(buffer, start, stop);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        start = stop;
        data.minute = this.parseInt(buffer, start, stop += 2);
        if (buffer.charAt(stop++) != ':') {
            throw new RuntimeException("Error in parsing time zone");
        }
        int sign = this.findUTCSign(buffer, start, end);
        start = stop;
        stop = sign < 0 ? end : sign;
        data.second = this.parseSecond(buffer, start, stop);
        if (sign > 0) {
            this.getTimeZone(buffer, data, sign, end);
        }
    }

    protected int getDate(String buffer, int start, int end, DateTimeData date2) throws RuntimeException {
        start = this.getYearMonth(buffer, start, end, date2);
        if (buffer.charAt(start++) != '-') {
            throw new RuntimeException("CCYY-MM must be followed by '-' sign");
        }
        int stop = start + 2;
        date2.day = this.parseInt(buffer, start, stop);
        return stop;
    }

    protected int getYearMonth(String buffer, int start, int end, DateTimeData date2) throws RuntimeException {
        int i;
        if (buffer.charAt(0) == '-') {
            ++start;
        }
        if ((i = this.indexOf(buffer, start, end, '-')) == -1) {
            throw new RuntimeException("Year separator is missing or misplaced");
        }
        int length = i - start;
        if (length < 4) {
            throw new RuntimeException("Year must have 'CCYY' format");
        }
        if (length > 4 && buffer.charAt(start) == '0') {
            throw new RuntimeException("Leading zeros are required if the year value would otherwise have fewer than four digits; otherwise they are forbidden");
        }
        date2.year = this.parseIntYear(buffer, i);
        if (buffer.charAt(i) != '-') {
            throw new RuntimeException("CCYY must be followed by '-' sign");
        }
        start = ++i;
        i = start + 2;
        date2.month = this.parseInt(buffer, start, i);
        return i;
    }

    protected void parseTimeZone(String buffer, int start, int end, DateTimeData date2) throws RuntimeException {
        if (start < end) {
            if (!this.isNextCharUTCSign(buffer, start, end)) {
                throw new RuntimeException("Error in month parsing");
            }
            this.getTimeZone(buffer, date2, start, end);
        }
    }

    protected void getTimeZone(String buffer, DateTimeData data, int sign, int end) throws RuntimeException {
        data.utc = buffer.charAt(sign);
        if (buffer.charAt(sign) == 'Z') {
            if (end > ++sign) {
                throw new RuntimeException("Error in parsing time zone");
            }
            return;
        }
        if (sign <= end - 6) {
            int negate = buffer.charAt(sign) == '-' ? -1 : 1;
            int stop = ++sign + 2;
            data.timezoneHr = negate * this.parseInt(buffer, sign, stop);
            if (buffer.charAt(stop++) != ':') {
                throw new RuntimeException("Error in parsing time zone");
            }
            data.timezoneMin = negate * this.parseInt(buffer, stop, stop + 2);
            if (stop + 2 != end) {
                throw new RuntimeException("Error in parsing time zone");
            }
            if (data.timezoneHr != 0 || data.timezoneMin != 0) {
                data.normalized = false;
            }
        } else {
            throw new RuntimeException("Error in parsing time zone");
        }
    }

    protected int indexOf(String buffer, int start, int end, char ch) {
        for (int i = start; i < end; ++i) {
            if (buffer.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    protected void validateDateTime(DateTimeData data) {
        if (data.year == 0) {
            throw new RuntimeException("The year \"0000\" is an illegal year value");
        }
        if (data.month < 1 || data.month > 12) {
            throw new RuntimeException("The month must have values 1 to 12");
        }
        if (data.day > this.maxDayInMonthFor(data.year, data.month) || data.day < 1) {
            throw new RuntimeException("The day must have values 1 to 31");
        }
        if (data.hour > 23 || data.hour < 0) {
            if (data.hour == 24 && data.minute == 0 && data.second == 0.0) {
                data.hour = 0;
                if (++data.day > this.maxDayInMonthFor(data.year, data.month)) {
                    data.day = 1;
                    if (++data.month > 12) {
                        data.month = 1;
                        if (++data.year == 0) {
                            data.year = 1;
                        }
                    }
                }
            } else {
                throw new RuntimeException("Hour must have values 0-23, unless 24:00:00");
            }
        }
        if (data.minute > 59 || data.minute < 0) {
            throw new RuntimeException("Minute must have values 0-59");
        }
        if (data.second >= 60.0 || data.second < 0.0) {
            throw new RuntimeException("Second must have values 0-59");
        }
        if (data.timezoneHr > 14 || data.timezoneHr < -14) {
            throw new RuntimeException("Time zone should have range -14:00 to +14:00");
        }
        if ((data.timezoneHr == 14 || data.timezoneHr == -14) && data.timezoneMin != 0) {
            throw new RuntimeException("Time zone should have range -14:00 to +14:00");
        }
        if (data.timezoneMin > 59 || data.timezoneMin < -59) {
            throw new RuntimeException("Minute must have values 0-59");
        }
    }

    protected int findUTCSign(String buffer, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = buffer.charAt(i);
            if (c != 'Z' && c != '+' && c != '-') continue;
            return i;
        }
        return -1;
    }

    protected final boolean isNextCharUTCSign(String buffer, int start, int end) {
        if (start < end) {
            char c = buffer.charAt(start);
            return c == 'Z' || c == '+' || c == '-';
        }
        return false;
    }

    protected int parseInt(String buffer, int start, int end) throws NumberFormatException {
        int radix = 10;
        int result = 0;
        int digit = 0;
        int limit = -2147483647;
        int multmin = limit / radix;
        int i = start;
        do {
            if ((digit = AbstractDateTimeDV.getDigit(buffer.charAt(i))) < 0) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            result -= digit;
        } while (++i < end);
        return -result;
    }

    protected int parseIntYear(String buffer, int end) {
        int limit;
        int radix = 10;
        int result = 0;
        boolean negative = false;
        int i = 0;
        int digit = 0;
        if (buffer.charAt(0) == '-') {
            negative = true;
            limit = Integer.MIN_VALUE;
            ++i;
        } else {
            limit = -2147483647;
        }
        int multmin = limit / radix;
        while (i < end) {
            if ((digit = AbstractDateTimeDV.getDigit(buffer.charAt(i++))) < 0) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            if (result < multmin) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            if ((result *= radix) < limit + digit) {
                throw new NumberFormatException("'" + buffer + "' has wrong format");
            }
            result -= digit;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("'" + buffer + "' has wrong format");
        }
        return -result;
    }

    protected void normalize(DateTimeData date2) {
        int negate = -1;
        int temp = date2.minute + negate * date2.timezoneMin;
        int carry = this.fQuotient(temp, 60);
        date2.minute = this.mod(temp, 60, carry);
        temp = date2.hour + negate * date2.timezoneHr + carry;
        carry = this.fQuotient(temp, 24);
        date2.hour = this.mod(temp, 24, carry);
        date2.day += carry;
        while (true) {
            temp = this.maxDayInMonthFor(date2.year, date2.month);
            if (date2.day < 1) {
                date2.day += this.maxDayInMonthFor(date2.year, date2.month - 1);
                carry = -1;
            } else {
                if (date2.day <= temp) break;
                date2.day -= temp;
                carry = 1;
            }
            temp = date2.month + carry;
            date2.month = this.modulo(temp, 1, 13);
            date2.year += this.fQuotient(temp, 1, 13);
            if (date2.year != 0) continue;
            date2.year = date2.timezoneHr < 0 || date2.timezoneMin < 0 ? 1 : -1;
        }
        date2.utc = 90;
    }

    protected void saveUnnormalized(DateTimeData date2) {
        date2.unNormYear = date2.year;
        date2.unNormMonth = date2.month;
        date2.unNormDay = date2.day;
        date2.unNormHour = date2.hour;
        date2.unNormMinute = date2.minute;
        date2.unNormSecond = date2.second;
    }

    protected void resetDateObj(DateTimeData data) {
        data.year = 0;
        data.month = 0;
        data.day = 0;
        data.hour = 0;
        data.minute = 0;
        data.second = 0.0;
        data.utc = 0;
        data.timezoneHr = 0;
        data.timezoneMin = 0;
    }

    protected int maxDayInMonthFor(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (this.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    private boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    protected int mod(int a, int b, int quotient) {
        return a - quotient * b;
    }

    protected int fQuotient(int a, int b) {
        return (int)Math.floor((float)a / (float)b);
    }

    protected int modulo(int temp, int low, int high) {
        int a = temp - low;
        int b = high - low;
        return this.mod(a, b, this.fQuotient(a, b)) + low;
    }

    protected int fQuotient(int temp, int low, int high) {
        return this.fQuotient(temp - low, high - low);
    }

    protected String dateToString(DateTimeData date2) {
        StringBuffer message = new StringBuffer(25);
        this.append(message, date2.year, 4);
        message.append('-');
        this.append(message, date2.month, 2);
        message.append('-');
        this.append(message, date2.day, 2);
        message.append('T');
        this.append(message, date2.hour, 2);
        message.append(':');
        this.append(message, date2.minute, 2);
        message.append(':');
        this.append(message, date2.second);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    protected final void append(StringBuffer message, int value, int nch) {
        if (value == Integer.MIN_VALUE) {
            message.append(value);
            return;
        }
        if (value < 0) {
            message.append('-');
            value = -value;
        }
        if (nch == 4) {
            if (value < 10) {
                message.append("000");
            } else if (value < 100) {
                message.append("00");
            } else if (value < 1000) {
                message.append('0');
            }
            message.append(value);
        } else if (nch == 2) {
            if (value < 10) {
                message.append('0');
            }
            message.append(value);
        } else if (value != 0) {
            message.append((char)value);
        }
    }

    protected final void append(StringBuffer message, double value) {
        if (value < 0.0) {
            message.append('-');
            value = -value;
        }
        if (value < 10.0) {
            message.append('0');
        }
        this.append2(message, value);
    }

    protected final void append2(StringBuffer message, double value) {
        int intValue = (int)value;
        if (value == (double)intValue) {
            message.append(intValue);
        } else {
            this.append3(message, value);
        }
    }

    private void append3(StringBuffer message, double value) {
        String d = String.valueOf(value);
        int eIndex = d.indexOf(69);
        if (eIndex == -1) {
            message.append(d);
            return;
        }
        if (value < 1.0) {
            char c;
            int end;
            int exp;
            try {
                exp = this.parseInt(d, eIndex + 2, d.length());
            }
            catch (Exception e2) {
                message.append(d);
                return;
            }
            message.append("0.");
            for (int i = 1; i < exp; ++i) {
                message.append('0');
            }
            for (end = eIndex - 1; end > 0 && (c = d.charAt(end)) == '0'; --end) {
            }
            for (int i = 0; i <= end; ++i) {
                char c2 = d.charAt(i);
                if (c2 == '.') continue;
                message.append(c2);
            }
        } else {
            int i;
            int exp;
            try {
                exp = this.parseInt(d, eIndex + 1, d.length());
            }
            catch (Exception e3) {
                message.append(d);
                return;
            }
            int integerEnd = exp + 2;
            for (i = 0; i < eIndex; ++i) {
                char c = d.charAt(i);
                if (c == '.') continue;
                if (i == integerEnd) {
                    message.append('.');
                }
                message.append(c);
            }
            for (i = integerEnd - eIndex; i > 0; --i) {
                message.append('0');
            }
        }
    }

    protected double parseSecond(String buffer, int start, int end) throws NumberFormatException {
        int dot = -1;
        for (int i = start; i < end; ++i) {
            char ch = buffer.charAt(i);
            if (ch == '.') {
                dot = i;
                continue;
            }
            if (ch <= '9' && ch >= '0') continue;
            throw new NumberFormatException("'" + buffer + "' has wrong format");
        }
        if (dot == -1 ? start + 2 != end : start + 2 != dot || dot + 1 == end) {
            throw new NumberFormatException("'" + buffer + "' has wrong format");
        }
        return Double.parseDouble(buffer.substring(start, end));
    }

    private void cloneDate(DateTimeData finalValue, DateTimeData tempDate) {
        tempDate.year = finalValue.year;
        tempDate.month = finalValue.month;
        tempDate.day = finalValue.day;
        tempDate.hour = finalValue.hour;
        tempDate.minute = finalValue.minute;
        tempDate.second = finalValue.second;
        tempDate.utc = finalValue.utc;
        tempDate.timezoneHr = finalValue.timezoneHr;
        tempDate.timezoneMin = finalValue.timezoneMin;
    }

    protected XMLGregorianCalendar getXMLGregorianCalendar(DateTimeData data) {
        return null;
    }

    protected Duration getDuration(DateTimeData data) {
        return null;
    }

    protected final BigDecimal getFractionalSecondsAsBigDecimal(DateTimeData data) {
        StringBuffer buf = new StringBuffer();
        this.append3(buf, data.unNormSecond);
        String value = buf.toString();
        int index = value.indexOf(46);
        if (index == -1) {
            return null;
        }
        BigDecimal _val = new BigDecimal(value = value.substring(index));
        if (_val.compareTo(BigDecimal.valueOf(0L)) == 0) {
            return null;
        }
        return _val;
    }

    static final class DateTimeData
    implements XSDateTime {
        int year;
        int month;
        int day;
        int hour;
        int minute;
        int utc;
        double second;
        int timezoneHr;
        int timezoneMin;
        private String originalValue;
        boolean normalized = true;
        int unNormYear;
        int unNormMonth;
        int unNormDay;
        int unNormHour;
        int unNormMinute;
        double unNormSecond;
        int position;
        final AbstractDateTimeDV type;
        private String canonical;

        public DateTimeData(String originalValue, AbstractDateTimeDV type) {
            this.originalValue = originalValue;
            this.type = type;
        }

        public DateTimeData(int year, int month, int day, int hour, int minute, double second, int utc, String originalValue, boolean normalized, AbstractDateTimeDV type) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
            this.minute = minute;
            this.second = second;
            this.utc = utc;
            this.type = type;
            this.originalValue = originalValue;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DateTimeData)) {
                return false;
            }
            return this.type.compareDates(this, (DateTimeData)obj, true) == 0;
        }

        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = this.type.dateToString(this);
            }
            return this.canonical;
        }

        public int getYears() {
            if (this.type instanceof DurationDV) {
                return 0;
            }
            return this.normalized ? this.year : this.unNormYear;
        }

        public int getMonths() {
            if (this.type instanceof DurationDV) {
                return this.year * 12 + this.month;
            }
            return this.normalized ? this.month : this.unNormMonth;
        }

        public int getDays() {
            if (this.type instanceof DurationDV) {
                return 0;
            }
            return this.normalized ? this.day : this.unNormDay;
        }

        public int getHours() {
            if (this.type instanceof DurationDV) {
                return 0;
            }
            return this.normalized ? this.hour : this.unNormHour;
        }

        public int getMinutes() {
            if (this.type instanceof DurationDV) {
                return 0;
            }
            return this.normalized ? this.minute : this.unNormMinute;
        }

        public double getSeconds() {
            if (this.type instanceof DurationDV) {
                return (double)(this.day * 24 * 60 * 60 + this.hour * 60 * 60 + this.minute * 60) + this.second;
            }
            return this.normalized ? this.second : this.unNormSecond;
        }

        public boolean hasTimeZone() {
            return this.utc != 0;
        }

        public int getTimeZoneHours() {
            return this.timezoneHr;
        }

        public int getTimeZoneMinutes() {
            return this.timezoneMin;
        }

        public String getLexicalValue() {
            return this.originalValue;
        }

        public XSDateTime normalize() {
            if (!this.normalized) {
                DateTimeData dt = (DateTimeData)this.clone();
                dt.normalized = true;
                return dt;
            }
            return this;
        }

        public boolean isNormalized() {
            return this.normalized;
        }

        public Object clone() {
            DateTimeData dt = new DateTimeData(this.year, this.month, this.day, this.hour, this.minute, this.second, this.utc, this.originalValue, this.normalized, this.type);
            dt.canonical = this.canonical;
            dt.position = this.position;
            dt.timezoneHr = this.timezoneHr;
            dt.timezoneMin = this.timezoneMin;
            dt.unNormYear = this.unNormYear;
            dt.unNormMonth = this.unNormMonth;
            dt.unNormDay = this.unNormDay;
            dt.unNormHour = this.unNormHour;
            dt.unNormMinute = this.unNormMinute;
            dt.unNormSecond = this.unNormSecond;
            return dt;
        }

        public XMLGregorianCalendar getXMLGregorianCalendar() {
            return this.type.getXMLGregorianCalendar(this);
        }

        public Duration getDuration() {
            return this.type.getDuration(this);
        }
    }
}

