/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.parsers;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.parsers.ObjectFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;

public class XMLGrammarPreparser {
    private static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    protected static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String GRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Hashtable KNOWN_LOADERS = new Hashtable();
    private static final String[] RECOGNIZED_PROPERTIES;
    protected final SymbolTable fSymbolTable;
    protected final XMLErrorReporter fErrorReporter;
    protected XMLEntityResolver fEntityResolver;
    protected XMLGrammarPool fGrammarPool;
    protected Locale fLocale;
    private final Hashtable fLoaders;
    private int fModCount = 1;

    public XMLGrammarPreparser() {
        this(new SymbolTable());
    }

    public XMLGrammarPreparser(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fLoaders = new Hashtable();
        this.fErrorReporter = new XMLErrorReporter();
        this.setLocale(Locale.getDefault());
        this.fEntityResolver = new XMLEntityManager();
    }

    public boolean registerPreparser(String grammarType, XMLGrammarLoader loader) {
        if (loader == null) {
            if (KNOWN_LOADERS.containsKey(grammarType)) {
                String loaderName = (String)KNOWN_LOADERS.get(grammarType);
                try {
                    ClassLoader cl = ObjectFactory.findClassLoader();
                    XMLGrammarLoader gl = (XMLGrammarLoader)ObjectFactory.newInstance(loaderName, cl, true);
                    this.fLoaders.put(grammarType, new XMLGrammarLoaderContainer(gl));
                }
                catch (Exception e2) {
                    return false;
                }
                return true;
            }
            return false;
        }
        this.fLoaders.put(grammarType, new XMLGrammarLoaderContainer(loader));
        return true;
    }

    public Grammar preparseGrammar(String type, XMLInputSource is) throws XNIException, IOException {
        if (this.fLoaders.containsKey(type)) {
            XMLGrammarLoaderContainer xglc = (XMLGrammarLoaderContainer)this.fLoaders.get(type);
            XMLGrammarLoader gl = xglc.loader;
            if (xglc.modCount != this.fModCount) {
                gl.setProperty(SYMBOL_TABLE, this.fSymbolTable);
                gl.setProperty(ENTITY_RESOLVER, this.fEntityResolver);
                gl.setProperty(ERROR_REPORTER, this.fErrorReporter);
                if (this.fGrammarPool != null) {
                    try {
                        gl.setProperty(GRAMMAR_POOL, this.fGrammarPool);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                xglc.modCount = this.fModCount;
            }
            return gl.loadGrammar(is);
        }
        return null;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
        this.fErrorReporter.setLocale(locale);
    }

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setErrorHandler(XMLErrorHandler errorHandler) {
        this.fErrorReporter.setProperty(ERROR_HANDLER, errorHandler);
    }

    public XMLErrorHandler getErrorHandler() {
        return this.fErrorReporter.getErrorHandler();
    }

    public void setEntityResolver(XMLEntityResolver entityResolver) {
        if (this.fEntityResolver != entityResolver) {
            if (++this.fModCount < 0) {
                this.clearModCounts();
            }
            this.fEntityResolver = entityResolver;
        }
    }

    public XMLEntityResolver getEntityResolver() {
        return this.fEntityResolver;
    }

    public void setGrammarPool(XMLGrammarPool grammarPool) {
        if (this.fGrammarPool != grammarPool) {
            if (++this.fModCount < 0) {
                this.clearModCounts();
            }
            this.fGrammarPool = grammarPool;
        }
    }

    public XMLGrammarPool getGrammarPool() {
        return this.fGrammarPool;
    }

    public XMLGrammarLoader getLoader(String type) {
        XMLGrammarLoaderContainer xglc = (XMLGrammarLoaderContainer)this.fLoaders.get(type);
        return xglc != null ? xglc.loader : null;
    }

    public void setFeature(String featureId, boolean value) {
        Enumeration loaders = this.fLoaders.elements();
        while (loaders.hasMoreElements()) {
            XMLGrammarLoader gl = ((XMLGrammarLoaderContainer)loaders.nextElement()).loader;
            try {
                gl.setFeature(featureId, value);
            }
            catch (Exception exception) {}
        }
        if (featureId.equals(CONTINUE_AFTER_FATAL_ERROR)) {
            this.fErrorReporter.setFeature(CONTINUE_AFTER_FATAL_ERROR, value);
        }
    }

    public void setProperty(String propId, Object value) {
        Enumeration loaders = this.fLoaders.elements();
        while (loaders.hasMoreElements()) {
            XMLGrammarLoader gl = ((XMLGrammarLoaderContainer)loaders.nextElement()).loader;
            try {
                gl.setProperty(propId, value);
            }
            catch (Exception exception) {}
        }
    }

    public boolean getFeature(String type, String featureId) {
        XMLGrammarLoader gl = ((XMLGrammarLoaderContainer)this.fLoaders.get((Object)type)).loader;
        return gl.getFeature(featureId);
    }

    public Object getProperty(String type, String propertyId) {
        XMLGrammarLoader gl = ((XMLGrammarLoaderContainer)this.fLoaders.get((Object)type)).loader;
        return gl.getProperty(propertyId);
    }

    private void clearModCounts() {
        Enumeration loaders = this.fLoaders.elements();
        while (loaders.hasMoreElements()) {
            XMLGrammarLoaderContainer xglc = (XMLGrammarLoaderContainer)loaders.nextElement();
            xglc.modCount = 0;
        }
        this.fModCount = 1;
    }

    static {
        KNOWN_LOADERS.put("http://www.w3.org/2001/XMLSchema", "org.apache.xerces.impl.xs.XMLSchemaLoader");
        KNOWN_LOADERS.put("http://www.w3.org/TR/REC-xml", "org.apache.xerces.impl.dtd.XMLDTDLoader");
        RECOGNIZED_PROPERTIES = new String[]{SYMBOL_TABLE, ERROR_REPORTER, ERROR_HANDLER, ENTITY_RESOLVER, GRAMMAR_POOL};
    }

    static class XMLGrammarLoaderContainer {
        public final XMLGrammarLoader loader;
        public int modCount = 0;

        public XMLGrammarLoaderContainer(XMLGrammarLoader loader) {
            this.loader = loader;
        }
    }
}

