/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerWrapper
implements XMLErrorHandler {
    protected ErrorHandler fErrorHandler;

    public ErrorHandlerWrapper() {
    }

    public ErrorHandlerWrapper(ErrorHandler errorHandler) {
        this.setErrorHandler(errorHandler);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        if (this.fErrorHandler != null) {
            SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
            try {
                this.fErrorHandler.warning(saxException);
            }
            catch (SAXParseException e2) {
                throw ErrorHandlerWrapper.createXMLParseException(e2);
            }
            catch (SAXException e3) {
                throw ErrorHandlerWrapper.createXNIException(e3);
            }
        }
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        if (this.fErrorHandler != null) {
            SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
            try {
                this.fErrorHandler.error(saxException);
            }
            catch (SAXParseException e2) {
                throw ErrorHandlerWrapper.createXMLParseException(e2);
            }
            catch (SAXException e3) {
                throw ErrorHandlerWrapper.createXNIException(e3);
            }
        }
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        if (this.fErrorHandler != null) {
            SAXParseException saxException = ErrorHandlerWrapper.createSAXParseException(exception);
            try {
                this.fErrorHandler.fatalError(saxException);
            }
            catch (SAXParseException e2) {
                throw ErrorHandlerWrapper.createXMLParseException(e2);
            }
            catch (SAXException e3) {
                throw ErrorHandlerWrapper.createXNIException(e3);
            }
        }
    }

    protected static SAXParseException createSAXParseException(XMLParseException exception) {
        return new SAXParseException(exception.getMessage(), exception.getPublicId(), exception.getExpandedSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getException());
    }

    protected static XMLParseException createXMLParseException(SAXParseException exception) {
        final String fPublicId = exception.getPublicId();
        final String fExpandedSystemId = exception.getSystemId();
        final int fLineNumber = exception.getLineNumber();
        final int fColumnNumber = exception.getColumnNumber();
        XMLLocator location = new XMLLocator(){

            public String getPublicId() {
                return fPublicId;
            }

            public String getExpandedSystemId() {
                return fExpandedSystemId;
            }

            public String getBaseSystemId() {
                return null;
            }

            public String getLiteralSystemId() {
                return null;
            }

            public int getColumnNumber() {
                return fColumnNumber;
            }

            public int getLineNumber() {
                return fLineNumber;
            }

            public int getCharacterOffset() {
                return -1;
            }

            public String getEncoding() {
                return null;
            }

            public String getXMLVersion() {
                return null;
            }
        };
        return new XMLParseException(location, exception.getMessage(), exception);
    }

    protected static XNIException createXNIException(SAXException exception) {
        return new XNIException(exception.getMessage(), exception);
    }
}

