/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.spdx.compare.NormalizedFileNameComparator;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.spdxspreadsheet.AbstractSheet;

public abstract class AbstractFileCompareSheet
extends AbstractSheet {
    static final int FILENAME_COL_WIDTH = 80;
    static final int DIFF_COL_WIDTH = 10;
    static final int FILENAME_COL = 0;
    static final int DIFF_COL = 1;
    static final int FIRST_DOCUMENT_COL = 2;
    static final String FILENAME_TITLE = "File Path";
    static final String DIFF_TITLE = "Same/Diff";
    static final String DIFFERENT_VALUE = "Different";
    static final String EQUAL_VALUE = "Equal";
    static final String NO_FILE_VALUE = "[No File]";
    private static final int MAX_VALUE_LENGTH = 32000;
    private NormalizedFileNameComparator normalizedFileNameComparator = new NormalizedFileNameComparator();

    public AbstractFileCompareSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        return null;
    }

    public static void create(Workbook wb, String sheetName, int columnWidth) {
        int sheetNum = wb.getSheetIndex(sheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(sheetName);
        Row row = sheet.createRow(0);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle defaultStyle = AbstractSheet.createLeftWrapStyle(wb);
        sheet.setColumnWidth(0, 20480);
        sheet.setDefaultColumnStyle(0, defaultStyle);
        Cell fileNameHeadercell = row.createCell(0);
        fileNameHeadercell.setCellStyle(headerStyle);
        fileNameHeadercell.setCellValue(FILENAME_TITLE);
        sheet.setColumnWidth(1, 2560);
        sheet.setDefaultColumnStyle(1, defaultStyle);
        Cell diffHeaderCell = row.createCell(1);
        diffHeaderCell.setCellStyle(headerStyle);
        diffHeaderCell.setCellValue(DIFF_TITLE);
        for (int i = 2; i < 27; ++i) {
            sheet.setColumnWidth(i, columnWidth * 256);
            sheet.setDefaultColumnStyle(i, defaultStyle);
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
        }
    }

    public void importCompareResults(SpdxComparer comparer, SpdxFile[][] files, String[] docNames) throws SpdxCompareException {
        if (docNames == null) {
            throw new SpdxCompareException("Document names can not be null");
        }
        if (files.length != docNames.length) {
            throw new SpdxCompareException("Number of document names does not match the number of SPDX documents being compared");
        }
        this.clear();
        Row header = this.sheet.getRow(0);
        for (int i = 0; i < docNames.length; ++i) {
            Cell headerCell = header.getCell(i + 2);
            headerCell.setCellValue(docNames[i]);
        }
        int[] fileIndexes = new int[files.length];
        for (int i = 0; i < fileIndexes.length; ++i) {
            fileIndexes[i] = 0;
        }
        while (!this.allFilesExhausted(files, fileIndexes)) {
            Row currentRow = this.addRow();
            String fileName = this.getNextFileName(files, fileIndexes);
            Cell fileNameCell = currentRow.createCell(0);
            fileNameCell.setCellValue(fileName);
            boolean allValuesMatch = true;
            SpdxFile lastFile = null;
            int lastDocIndex = 0;
            for (int i = 0; i < files.length; ++i) {
                Cell cell = currentRow.createCell(i + 2);
                if (fileIndexes[i] < files[i].length && this.normalizedFileNameComparator.compare(files[i][fileIndexes[i]].getName(), fileName) == 0) {
                    String val = this.getFileValue(files[i][fileIndexes[i]]);
                    if (allValuesMatch && lastFile != null && !this.valuesMatch(comparer, lastFile, lastDocIndex, files[i][fileIndexes[i]], i)) {
                        allValuesMatch = false;
                    }
                    lastFile = files[i][fileIndexes[i]];
                    if (val.length() > 32000) {
                        val = val.substring(0, 31991) + "[more...]";
                    }
                    cell.setCellValue(val);
                    int n = i;
                    fileIndexes[n] = fileIndexes[n] + 1;
                    continue;
                }
                cell.setCellValue(NO_FILE_VALUE);
                allValuesMatch = false;
            }
            Cell diffCell = currentRow.createCell(1);
            if (allValuesMatch) {
                this.setCellAllEqual(diffCell);
                continue;
            }
            this.setCellDifference(diffCell);
        }
    }

    abstract boolean valuesMatch(SpdxComparer var1, SpdxFile var2, int var3, SpdxFile var4, int var5) throws SpdxCompareException;

    private void setCellDifference(Cell cell) {
        cell.setCellValue(DIFFERENT_VALUE);
        cell.setCellStyle(this.yellowWrapped);
    }

    private void setCellAllEqual(Cell cell) {
        cell.setCellValue(EQUAL_VALUE);
        cell.setCellStyle(this.greenWrapped);
    }

    abstract String getFileValue(SpdxFile var1);

    private String getNextFileName(SpdxFile[][] files, int[] fileIndexes) {
        String retval = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].length <= fileIndexes[i]) continue;
            String fileName = files[i][fileIndexes[i]].getName();
            if (retval != null && this.normalizedFileNameComparator.compare(retval, fileName) <= 0) continue;
            retval = fileName;
        }
        return NormalizedFileNameComparator.normalizeFileName(retval);
    }

    private boolean allFilesExhausted(SpdxFile[][] files, int[] fileIndexes) {
        for (int i = 0; i < fileIndexes.length; ++i) {
            if (fileIndexes[i] >= files[i].length) continue;
            return false;
        }
        return true;
    }
}

