/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.compare;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.spdx.compare.SpdxCompareException;
import org.spdx.compare.SpdxComparer;
import org.spdx.compare.SpdxFileComparer;
import org.spdx.compare.SpdxFileDifference;
import org.spdx.compare.SpdxItemComparer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;
import org.spdx.rdfparser.model.SpdxItem;
import org.spdx.rdfparser.model.SpdxSnippet;

public class SpdxSnippetComparer
extends SpdxItemComparer {
    private boolean inProgress = false;
    private boolean differenceFound = false;
    private boolean byteRangeEquals = true;
    private boolean lineRangeEquals = true;
    private boolean snippetFromFilesEquals = true;
    private boolean nameEquals = true;
    Map<SpdxDocument, Map<SpdxDocument, SpdxFileDifference>> snippetFromFileDifferences = Maps.newHashMap();
    Map<SpdxDocument, Map<SpdxDocument, SpdxFile>> uniqueSnippetFromFile = Maps.newHashMap();

    public SpdxSnippetComparer(Map<SpdxDocument, Map<SpdxDocument, Map<String, String>>> extractedLicenseIdMap) {
        super(extractedLicenseIdMap);
    }

    public void addDocumentSnippet(SpdxDocument spdxDocument, SpdxSnippet snippet) throws SpdxCompareException {
        this.checkInProgress();
        if (this.name == null) {
            this.name = snippet.toString();
        }
        this.inProgress = true;
        Iterator iter = this.documentItem.entrySet().iterator();
        SpdxSnippet snippet2 = null;
        SpdxDocument document2 = null;
        while (iter.hasNext() && snippet2 == null) {
            Map.Entry entry = iter.next();
            if (!(entry.getValue() instanceof SpdxSnippet)) continue;
            snippet2 = (SpdxSnippet)entry.getValue();
            document2 = (SpdxDocument)entry.getKey();
        }
        if (snippet2 != null) {
            try {
                if (!snippet2.equivalentConsideringNull(snippet2.getByteRange(), snippet.getByteRange())) {
                    this.byteRangeEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                throw new SpdxCompareException("SPDX error getting byte range: " + e2.getMessage());
            }
            try {
                if (!snippet2.equivalentConsideringNull(snippet2.getLineRange(), snippet.getLineRange())) {
                    this.lineRangeEquals = false;
                    this.differenceFound = true;
                }
            }
            catch (InvalidSPDXAnalysisException e3) {
                throw new SpdxCompareException("SPDX error getting line range: " + e3.getMessage());
            }
            try {
                SpdxFile fromFile = snippet.getSnippetFromFile();
                SpdxFile fromFile2 = snippet2.getSnippetFromFile();
                this.compareSnippetFromFiles(spdxDocument, fromFile, document2, fromFile2);
            }
            catch (InvalidSPDXAnalysisException e4) {
                throw new SpdxCompareException("SPDX error getting snippet from file: " + e4.getMessage());
            }
            if (!SpdxComparer.stringsEqual(snippet2.getName(), snippet.getName())) {
                this.nameEquals = false;
                this.differenceFound = true;
            }
        }
        this.inProgress = false;
        super.addDocumentItem(spdxDocument, snippet);
    }

    private void compareSnippetFromFiles(SpdxDocument spdxDocument, SpdxFile fromFile, SpdxDocument document2, SpdxFile fromFile2) throws SpdxCompareException {
        if (fromFile == null) {
            if (fromFile2 != null) {
                Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(document2);
                if (unique == null) {
                    unique = Maps.newHashMap();
                    this.uniqueSnippetFromFile.put(document2, unique);
                }
                unique.put(spdxDocument, fromFile2);
                this.snippetFromFilesEquals = false;
            }
        } else if (fromFile2 == null) {
            Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(spdxDocument);
            if (unique == null) {
                unique = Maps.newHashMap();
                this.uniqueSnippetFromFile.put(spdxDocument, unique);
            }
            unique.put(document2, fromFile);
            this.snippetFromFilesEquals = false;
        } else if (!Objects.equal(fromFile2.getName(), fromFile.getName())) {
            Map<SpdxDocument, SpdxFile> unique = this.uniqueSnippetFromFile.get(spdxDocument);
            if (unique == null) {
                unique = Maps.newHashMap();
                this.uniqueSnippetFromFile.put(spdxDocument, unique);
            }
            unique.put(document2, fromFile);
            Map<SpdxDocument, SpdxFile> unique2 = this.uniqueSnippetFromFile.get(document2);
            if (unique2 == null) {
                unique2 = Maps.newHashMap();
                this.uniqueSnippetFromFile.put(document2, unique2);
            }
            unique2.put(spdxDocument, fromFile2);
            this.snippetFromFilesEquals = false;
        } else {
            SpdxFileComparer fileCompare = new SpdxFileComparer(this.extractedLicenseIdMap);
            fileCompare.addDocumentFile(spdxDocument, fromFile);
            fileCompare.addDocumentFile(document2, fromFile2);
            if (fileCompare.isDifferenceFound()) {
                this.snippetFromFilesEquals = false;
                HashMap<SpdxDocument, SpdxFileDifference> comparerMap = Maps.newHashMap();
                this.snippetFromFileDifferences.put(spdxDocument, comparerMap);
                Map<SpdxDocument, SpdxFileDifference> comparerMap2 = this.snippetFromFileDifferences.get(document2);
                if (comparerMap2 == null) {
                    comparerMap2 = Maps.newHashMap();
                    this.snippetFromFileDifferences.put(document2, comparerMap2);
                }
                comparerMap.put(document2, fileCompare.getFileDifference(spdxDocument, document2));
                comparerMap2.put(spdxDocument, fileCompare.getFileDifference(document2, spdxDocument));
            }
        }
        if (!this.snippetFromFilesEquals) {
            this.differenceFound = true;
        }
    }

    @Override
    public boolean isDifferenceFound() throws SpdxCompareException {
        this.checkInProgress();
        return this.differenceFound || super.isDifferenceFound();
    }

    @Override
    protected void checkInProgress() throws SpdxCompareException {
        if (this.inProgress) {
            throw new SpdxCompareException("File compare in progress - can not obtain compare results until compare has completed");
        }
        super.checkInProgress();
    }

    public SpdxFileDifference getSnippetFromFileDifference(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFileDifference> differenceMap = this.snippetFromFileDifferences.get(docA);
        if (differenceMap == null) {
            return null;
        }
        return differenceMap.get(docB);
    }

    public boolean isByteRangeEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.byteRangeEquals;
    }

    public boolean isLineRangeEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.lineRangeEquals;
    }

    public boolean isSnippetFromFilesEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.snippetFromFilesEquals;
    }

    public boolean isNameEquals() throws SpdxCompareException {
        this.checkInProgress();
        return this.nameEquals;
    }

    public SpdxFile getUniqueSnippetFromFile(SpdxDocument docA, SpdxDocument docB) throws SpdxCompareException {
        this.checkInProgress();
        Map<SpdxDocument, SpdxFile> docMap = this.uniqueSnippetFromFile.get(docA);
        if (docMap == null) {
            return null;
        }
        return docMap.get(docB);
    }

    public int getNumSnippets() {
        return this.documentItem.size();
    }

    public SpdxSnippet getDocSnippet(SpdxDocument spdxDocument) {
        SpdxItem retItem = (SpdxItem)this.documentItem.get(spdxDocument);
        if (retItem != null && retItem instanceof SpdxSnippet) {
            return (SpdxSnippet)retItem;
        }
        return null;
    }
}

