/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.html;

import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.ExternalRef;

public class ExternalRefContext {
    private String category = "[UNKNOWN]";
    private String type = "[UNKNOWN]";
    private String locator = "[UNKNOWN]";

    public ExternalRefContext(ExternalRef externalRef) {
        if (externalRef != null) {
            if (externalRef.getReferenceCategory() != null) {
                this.category = externalRef.getReferenceCategory().getTag();
            }
            try {
                if (externalRef.getReferenceType() != null) {
                    this.type = externalRef.getReferenceType().toString();
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                this.type = "[ERROR: " + e2.getMessage() + "]";
            }
            if (externalRef.getReferenceLocator() != null) {
                this.locator = externalRef.getReferenceLocator();
            }
        }
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLocator() {
        return this.locator;
    }

    public void setLocator(String locator) {
        this.locator = locator;
    }
}

