/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.merge;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.spdx.merge.SpdxLicenseMapper;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.DoapProject;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.rdfparser.model.SpdxFile;

public class SpdxFileInfoMerger {
    private SpdxDocument master = null;
    private SpdxLicenseMapper mapper = null;

    public SpdxFileInfoMerger(SpdxDocument master, SpdxLicenseMapper mapper) {
        this.master = master;
        this.mapper = mapper;
    }

    public SpdxFile[] mergeFileInfo(SpdxDocument[] subDocs) throws InvalidSPDXAnalysisException {
        List<SpdxFile> masterFileInfo = this.master.getDocumentContainer().findAllFiles();
        ArrayList<SpdxFile> retval = Lists.newArrayList(this.cloneFiles(masterFileInfo));
        block0: for (int q = 0; q < subDocs.length; ++q) {
            SpdxFile[] subFileInfo = this.cloneList(subDocs[q].getDocumentContainer().findAllFiles());
            for (int k = 0; k < subFileInfo.length; ++k) {
                boolean foundNameMatch = false;
                boolean foundSha1Match = false;
                SpdxFile temp = null;
                for (int p = 0; p < retval.size(); ++p) {
                    temp = (SpdxFile)retval.get(p);
                    if (subFileInfo[k].getName().equalsIgnoreCase(((SpdxFile)retval.get(p)).getName())) {
                        foundNameMatch = true;
                    }
                    if (!subFileInfo[k].getSha1().equals(((SpdxFile)retval.get(p)).getSha1())) continue;
                    foundSha1Match = true;
                    break;
                }
                if (!foundNameMatch && !foundSha1Match) {
                    if (this.mapper.docInNonStdLicIdMap(subDocs[q])) {
                        this.mapper.replaceNonStdLicInFile(subDocs[q], subFileInfo[k]);
                        retval.add(subFileInfo[k]);
                        continue;
                    }
                    retval.add(subFileInfo[k]);
                    continue;
                }
                boolean foundMasterDOAP = false;
                boolean foundChildDOAP = false;
                if (this.checkDoapProject(temp)) {
                    foundMasterDOAP = true;
                    continue block0;
                }
                if (this.checkDoapProject(subFileInfo[k])) {
                    foundChildDOAP = true;
                    continue block0;
                }
                if (foundMasterDOAP && foundChildDOAP) {
                    DoapProject[] masterArtifactOf = this.cloneDoapProject(temp.getArtifactOf());
                    DoapProject[] subArtifactOfA = this.cloneDoapProject(subFileInfo[k].getArtifactOf());
                    DoapProject[] mergedArtifactOf = this.mergeDOAPInfo(masterArtifactOf, subArtifactOfA);
                    temp.setArtifactOf(mergedArtifactOf);
                }
                if (foundMasterDOAP || !foundChildDOAP) continue;
                DoapProject[] childArtifactOfB = this.cloneDoapProject(subFileInfo[k].getArtifactOf());
                temp.setArtifactOf(childArtifactOfB);
            }
        }
        SpdxFile[] fileMergeResult = new SpdxFile[retval.size()];
        retval.toArray(fileMergeResult);
        retval.clear();
        return fileMergeResult;
    }

    public boolean checkDoapProject(SpdxFile spdxFile) {
        boolean foundDoapProject = false;
        if (spdxFile.getArtifactOf() != null && spdxFile.getArtifactOf().length > 0) {
            foundDoapProject = true;
        }
        return foundDoapProject;
    }

    public DoapProject[] mergeDOAPInfo(DoapProject[] masterArtifactOf, DoapProject[] subArtifactOf) {
        ArrayList<DoapProject> retval = Lists.newArrayList(masterArtifactOf);
        for (int l = 0; l < subArtifactOf.length; ++l) {
            boolean foundMatch = false;
            for (int u = 0; u < masterArtifactOf.length; ++u) {
                if (!subArtifactOf[l].equals(masterArtifactOf[u])) continue;
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            retval.add(subArtifactOf[l]);
        }
        DoapProject[] mergedArtifactOf = new DoapProject[retval.size()];
        retval.toArray(mergedArtifactOf);
        retval.clear();
        return mergedArtifactOf;
    }

    public List<SpdxFile> cloneFiles(List<SpdxFile> filesArray) {
        ArrayList<SpdxFile> clonedFilesArray = new ArrayList<SpdxFile>();
        for (int h = 0; h < filesArray.size(); ++h) {
            clonedFilesArray.add(filesArray.get(h).clone());
        }
        return clonedFilesArray;
    }

    public SpdxFile[] cloneList(List<SpdxFile> filesList) {
        ArrayList<SpdxFile> clonedFilesList = Lists.newArrayList();
        for (int h = 0; h < filesList.size(); ++h) {
            clonedFilesList.add(filesList.get(h));
        }
        SpdxFile[] clonedFilesArray = new SpdxFile[clonedFilesList.size()];
        clonedFilesList.toArray(clonedFilesArray);
        return clonedFilesArray;
    }

    public DoapProject[] cloneDoapProject(DoapProject[] orgProjectArray) {
        DoapProject[] clonedProjectArray = new DoapProject[orgProjectArray.length];
        for (int j = 0; j < orgProjectArray.length; ++j) {
            clonedProjectArray[j] = orgProjectArray[j].clone();
        }
        return clonedProjectArray;
    }
}

