/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.license.ISpdxListedLicenseProvider;
import org.spdx.rdfparser.license.LicenseCsvException;
import org.spdx.rdfparser.license.LicenseException;
import org.spdx.rdfparser.license.LicenseRestrictionException;
import org.spdx.rdfparser.license.SpdxListedLicense;
import org.spdx.spdxspreadsheet.SPDXLicenseSpreadsheet;

@Deprecated
public class SpdxLicenseCsv
implements ISpdxListedLicenseProvider {
    static final Logger logger = LoggerFactory.getLogger(SpdxLicenseCsv.class.getName());
    public static final int LICENSE_NAME_COL = 0;
    public static final int LICENSE_ID_COL = 1;
    public static final int LICENSE_NOTES_COL = 3;
    public static final int LICENSE_TEXT_COL = 6;
    public static final int LICENSE_URL_COL = 2;
    public static final int LICENSE_TEMPLATE_COL = 7;
    public static final int LICENSE_HEADER_COL = 5;
    public static final int IS_OSI_APPROVED_COL = 4;
    static final char DELIM = ',';
    static final char STRING_DELIM = '\"';
    static final String[] HEADER_ROW = new String[]{"Full name of License", "License Identifier", "Source/url", "Notes", "OSI Approved", "Standard License Header", "Text", "Template"};
    private static final int NUM_COLS = HEADER_ROW.length;
    List<String> warnings = new ArrayList<String>();
    private File csvFile = null;
    private CSVReader reader = null;
    private List<CsvLicenseIterator> openIterators = Lists.newArrayList();

    public SpdxLicenseCsv(File csvFile) throws IOException, LicenseCsvException {
        this.csvFile = csvFile;
        this.reader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8"), ',', '\"');
        String[] header = this.reader.readNext();
        if (header.length != NUM_COLS) {
            throw new LicenseCsvException("Incorrect number of columns for License CSV file.  Expected " + String.valueOf(NUM_COLS) + ", found " + String.valueOf(header.length));
        }
        for (int i = 0; i < header.length; ++i) {
            if (header[i].equals(HEADER_ROW[i])) continue;
            throw new LicenseCsvException("Invalid row header at column " + String.valueOf(i) + ", expected " + HEADER_ROW[i] + ", found " + header[i]);
        }
    }

    @Override
    public Iterator<SpdxListedLicense> getLicenseIterator() throws LicenseCsvException {
        CsvLicenseIterator retval;
        try {
            retval = new CsvLicenseIterator(this.csvFile);
        }
        catch (IOException e2) {
            logger.error("IO Exception getting license iterator: " + e2.getMessage());
            throw new LicenseCsvException("IO Exception getting license iterator: " + e2.getMessage());
        }
        catch (LicenseCsvException e3) {
            logger.error("License csv file format error: " + e3.getMessage());
            throw e3;
        }
        this.openIterators.add(retval);
        return retval;
    }

    public void close() throws IOException {
        for (int i = 0; i < this.openIterators.size(); ++i) {
            this.openIterators.get(i).close();
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public Iterator<LicenseException> getExceptionIterator() throws LicenseRestrictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<SPDXLicenseSpreadsheet.DeprecatedLicenseInfo> getDeprecatedLicenseIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    private static class CsvLicenseIterator
    implements Iterator<SpdxListedLicense> {
        private CSVReader iterReader = null;
        SpdxListedLicense nextStandardLicense = null;

        public CsvLicenseIterator(File csvFile) throws IOException, LicenseCsvException {
            this.iterReader = new CSVReader(new InputStreamReader((InputStream)new FileInputStream(csvFile), "UTF-8"), ',', '\"');
            this.iterReader.readNext();
            this.readNextStandardLicense();
        }

        private void readNextStandardLicense() throws IOException, LicenseCsvException {
            String[] nextRow = this.iterReader.readNext();
            if (nextRow == null) {
                this.nextStandardLicense = null;
                return;
            }
            if (nextRow.length != HEADER_ROW.length) {
                this.nextStandardLicense = null;
                throw new LicenseCsvException("Invalid number of columns.  Expected " + String.valueOf(HEADER_ROW.length) + ", found " + String.valueOf(nextRow.length));
            }
            try {
                String licenseUrlsString = nextRow[2];
                String[] licenseUrls = licenseUrlsString.split("\\s");
                for (int i = 0; i < licenseUrls.length; ++i) {
                    licenseUrls[i] = licenseUrls[i].trim();
                }
                this.nextStandardLicense = new SpdxListedLicense(nextRow[0], nextRow[1], nextRow[6], licenseUrls, nextRow[3], nextRow[5], nextRow[7], this.isTrue(nextRow[4]));
            }
            catch (InvalidSPDXAnalysisException e2) {
                this.nextStandardLicense = null;
                throw new LicenseCsvException("Error creating standard license: " + e2.getMessage(), e2);
            }
        }

        private boolean isTrue(String string) {
            if (string == null || string.isEmpty()) {
                return false;
            }
            return string.toUpperCase().equals("Y") || string.toUpperCase().equals("YES");
        }

        @Override
        public boolean hasNext() {
            return this.nextStandardLicense != null;
        }

        @Override
        public SpdxListedLicense next() {
            SpdxListedLicense retval = this.nextStandardLicense;
            if (retval != null) {
                try {
                    this.readNextStandardLicense();
                }
                catch (IOException e2) {
                    logger.error("IO Exception getting next record: " + e2.getMessage());
                }
                catch (LicenseCsvException e3) {
                    logger.error("License csv file format error getting next record: " + e3.getMessage());
                }
            }
            return retval;
        }

        @Override
        public void remove() {
        }

        public void close() {
            if (this.iterReader != null) {
                try {
                    this.iterReader.close();
                    this.iterReader = null;
                }
                catch (IOException e2) {
                    logger.error("IO error closing CSV reader: " + e2.getMessage());
                }
            }
        }
    }
}

