/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxVerificationHelper;
import org.spdx.rdfparser.model.Checksum;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.RdfModelObject;
import org.spdx.rdfparser.model.SpdxDocument;

public class ExternalDocumentRef
extends RdfModelObject
implements Comparable<ExternalDocumentRef> {
    static final Logger logger = LoggerFactory.getLogger(RdfModelObject.class.getClass());
    Checksum checksum;
    String spdxDocumentNamespace;
    String externalDocumentId;
    SpdxDocument spdxDocument = null;

    public ExternalDocumentRef(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        this.checksum = this.findChecksumPropertyValue("http://spdx.org/rdf/terms#", "checksum");
        this.spdxDocumentNamespace = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "spdxDocument");
        this.externalDocumentId = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "externalDocumentId");
    }

    public ExternalDocumentRef(String spdxDocumentUri, Checksum checksum, String externalDocumentId) {
        this.spdxDocumentNamespace = spdxDocumentUri;
        this.checksum = checksum;
        this.externalDocumentId = externalDocumentId;
    }

    public ExternalDocumentRef(SpdxDocument externalDocument, Checksum checksum, String externalDocumentId) {
        this.spdxDocument = externalDocument;
        this.spdxDocumentNamespace = this.documentToDocumentUri(externalDocument);
        this.externalDocumentId = externalDocumentId;
        this.checksum = checksum;
    }

    private String documentToDocumentUri(SpdxDocument document) {
        if (document == null) {
            return null;
        }
        String retval = document.getDocumentContainer().getDocumentNamespace();
        if (retval.endsWith("#")) {
            retval = retval.substring(0, retval.length() - 1);
        }
        return retval;
    }

    @Override
    public List<String> verify() {
        ArrayList<String> retval = Lists.newArrayList();
        String uri = "UNKNOWN";
        if (this.spdxDocumentNamespace == null) {
            retval.add("Missing required external document URI");
        } else {
            uri = this.spdxDocumentNamespace;
            if (!SpdxVerificationHelper.isValidUri(uri)) {
                retval.add("Invalid URI for external Spdx Document URI: " + this.spdxDocumentNamespace);
            }
        }
        if (this.checksum == null) {
            retval.add("Missing checksum for external document " + uri);
        } else {
            retval.addAll(this.checksum.verify());
            if (this.checksum.getAlgorithm() != Checksum.ChecksumAlgorithm.checksumAlgorithm_sha1) {
                retval.add("Checksum algorithm is not SHA1 for external reference " + uri);
            }
        }
        if (this.externalDocumentId == null) {
            retval.add("Missing external document ID for document " + uri);
        } else if (!SpdxVerificationHelper.isValidExternalDocRef(this.externalDocumentId)) {
            retval.add("Invalid external document ID: " + this.externalDocumentId);
        }
        return retval;
    }

    @Override
    public String getUri(IModelContainer modelContainer) {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://spdx.org/rdf/terms#ExternalDocumentRef");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        this.setPropertyUriValue("http://spdx.org/rdf/terms#", "spdxDocument", this.spdxDocumentNamespace);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "checksum", this.checksum);
        this.setPropertyValue("http://spdx.org/rdf/terms#", "externalDocumentId", this.externalDocumentId);
    }

    public Checksum getChecksum() throws InvalidSPDXAnalysisException {
        Checksum refreshedChecksum;
        if (this.resource != null && this.refreshOnGet && ((refreshedChecksum = this.findChecksumPropertyValue("http://spdx.org/rdf/terms#", "checksum")) == null || !refreshedChecksum.equivalent(this.checksum))) {
            this.checksum = refreshedChecksum;
        }
        return this.checksum;
    }

    public void setChecksum(Checksum checksum) throws InvalidSPDXAnalysisException {
        this.checksum = checksum;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "checksum", this.checksum);
    }

    public String getSpdxDocumentNamespace() {
        if (this.resource != null && this.refreshOnGet) {
            this.spdxDocumentNamespace = this.findUriPropertyValue("http://spdx.org/rdf/terms#", "spdxDocument");
        }
        return this.spdxDocumentNamespace;
    }

    public void setSpdxDocumentNamespace(String spdxDocumentNamespace) throws InvalidSPDXAnalysisException {
        this.spdxDocumentNamespace = spdxDocumentNamespace;
        if (this.spdxDocumentNamespace == null) {
            this.removePropertyValue("http://spdx.org/rdf/terms#", "spdxDocument");
        } else {
            this.setPropertyUriValue("http://spdx.org/rdf/terms#", "spdxDocument", this.spdxDocumentNamespace);
        }
    }

    public SpdxDocument getSpdxDocument() {
        return this.spdxDocument;
    }

    public void setSpdxDocument(SpdxDocument spdxDocument) throws InvalidSPDXAnalysisException {
        this.spdxDocument = spdxDocument;
        this.setSpdxDocumentNamespace(this.documentToDocumentUri(spdxDocument));
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof ExternalDocumentRef)) {
            return false;
        }
        ExternalDocumentRef compref = (ExternalDocumentRef)compare;
        try {
            return Objects.equal(this.getSpdxDocumentNamespace(), compref.getSpdxDocumentNamespace()) && this.equivalentConsideringNull(this.getChecksum(), compref.getChecksum()) && Objects.equal(this.getExternalDocumentId(), compref.getExternalDocumentId());
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Invald SPDX Analysis exception comparing external document references: " + e2.getMessage(), e2);
            return false;
        }
    }

    public ExternalDocumentRef clone() {
        return new ExternalDocumentRef(this.spdxDocumentNamespace, this.checksum.clone(), this.externalDocumentId);
    }

    public String getExternalDocumentId() {
        if (this.resource != null && this.refreshOnGet) {
            this.externalDocumentId = this.findSinglePropertyValue("http://spdx.org/rdf/terms#", "externalDocumentId");
        }
        return this.externalDocumentId;
    }

    public void setExternalDocumentId(String externalDocumentId) {
        this.externalDocumentId = externalDocumentId;
        this.setPropertyValue("http://spdx.org/rdf/terms#", "externalDocumentId", externalDocumentId);
    }

    @Override
    public int compareTo(ExternalDocumentRef o) {
        if (o.getExternalDocumentId() == null && this.externalDocumentId != null) {
            return 1;
        }
        if (this.externalDocumentId == null) {
            return -1;
        }
        int retval = this.externalDocumentId.compareTo(o.getExternalDocumentId());
        if (retval != 0) {
            return retval;
        }
        if (o.getSpdxDocumentNamespace() == null && this.spdxDocumentNamespace != null) {
            return 1;
        }
        if (this.spdxDocumentNamespace == null) {
            return -1;
        }
        retval = this.spdxDocumentNamespace.compareTo(o.getSpdxDocumentNamespace());
        if (retval != 0) {
            return retval;
        }
        try {
            if ((o.getChecksum() == null || o.getChecksum().getValue() == null) && this.checksum != null && this.checksum.getValue() != null) {
                return 1;
            }
        }
        catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
            // empty catch block
        }
        if (this.checksum == null || this.checksum.getValue() == null) {
            return -1;
        }
        try {
            return this.checksum.getValue().compareTo(o.getChecksum().getValue());
        }
        catch (InvalidSPDXAnalysisException e2) {
            return 0;
        }
    }
}

