/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.model.pointer;

import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.model.IRdfModel;
import org.spdx.rdfparser.model.pointer.ByteOffsetPointer;
import org.spdx.rdfparser.model.pointer.CompoundPointer;
import org.spdx.rdfparser.model.pointer.LineCharPointer;
import org.spdx.rdfparser.model.pointer.SinglePointer;

public class StartEndPointer
extends CompoundPointer
implements Comparable<StartEndPointer> {
    private SinglePointer endPointer;

    public StartEndPointer(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        super(modelContainer, node);
        this.getPropertiesFromModel();
    }

    public StartEndPointer(SinglePointer startPointer, SinglePointer endPointer) {
        super(startPointer);
        this.endPointer = endPointer;
    }

    @Override
    public List<String> verify() {
        List<String> retval = super.verify();
        if (this.endPointer == null) {
            retval.add("Missing required end pointer");
        } else {
            retval.addAll(this.endPointer.verify());
            if (this.startPointer != null && this.startPointer instanceof ByteOffsetPointer && !(this.endPointer instanceof ByteOffsetPointer)) {
                retval.add("Inconsistent start and end pointer types");
            }
            if (this.startPointer != null && this.startPointer instanceof LineCharPointer && !(this.endPointer instanceof LineCharPointer)) {
                retval.add("Inconsistent start and end pointer types");
            }
            if (this.startPointer != null && this.startPointer.compareTo(this.endPointer) > 0) {
                retval.add("End pointer is less than start pointer");
            }
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        SinglePointer myEndPointer;
        SinglePointer compEndPointer;
        if (!(compare instanceof StartEndPointer)) {
            return false;
        }
        if (!super.equivalent(compare)) {
            return false;
        }
        try {
            compEndPointer = ((StartEndPointer)compare).getEndPointer();
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting the equiv. end pointer", e2);
            return false;
        }
        try {
            myEndPointer = this.getEndPointer();
        }
        catch (InvalidSPDXAnalysisException e3) {
            logger.error("Error getting tmy end pointer", e3);
            return false;
        }
        if (myEndPointer == null) {
            return compEndPointer == null;
        }
        if (compEndPointer == null) {
            return false;
        }
        return myEndPointer.equivalent(compEndPointer);
    }

    @Override
    public void getPropertiesFromModel() throws InvalidSPDXAnalysisException {
        super.getPropertiesFromModel();
        this.endPointer = this.findSinglePointerPropertyValue("http://www.w3.org/2009/pointers#", "endPointer");
    }

    @Override
    public String getUri(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        return null;
    }

    @Override
    public Resource getType(Model model) {
        return model.createResource("http://www.w3.org/2009/pointers#StartEndPointer");
    }

    @Override
    public void populateModel() throws InvalidSPDXAnalysisException {
        super.populateModel();
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "endPointer", this.endPointer);
    }

    public SinglePointer getEndPointer() throws InvalidSPDXAnalysisException {
        if (this.model != null && this.refreshOnGet) {
            this.endPointer = this.findSinglePointerPropertyValue("http://www.w3.org/2009/pointers#", "endPointer");
        }
        return this.endPointer;
    }

    public void setEndPointer(SinglePointer endPointer) throws InvalidSPDXAnalysisException {
        this.endPointer = endPointer;
        this.setPropertyValue("http://www.w3.org/2009/pointers#", "endPointer", this.endPointer);
    }

    public StartEndPointer clone() {
        SinglePointer newStartPointer = null;
        SinglePointer newEndPointer = null;
        if (this.startPointer != null) {
            newStartPointer = this.startPointer.clone();
        }
        if (this.endPointer != null) {
            newEndPointer = this.endPointer.clone();
        }
        return new StartEndPointer(newStartPointer, newEndPointer);
    }

    @Override
    public int compareTo(StartEndPointer o) {
        if (o == null) {
            return 1;
        }
        try {
            if (this.startPointer == null) {
                if (o.getStartPointer() == null) {
                    return 0;
                }
                return -1;
            }
            if (o.getStartPointer() == null) {
                return 1;
            }
            return this.startPointer.compareTo(o.getStartPointer());
        }
        catch (InvalidSPDXAnalysisException e2) {
            logger.error("Error getting comparison for start end pointer", e2);
            return -1;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("From: ");
        if (this.startPointer != null) {
            sb.append(this.startPointer.toString());
        } else {
            sb.append("[UNKNOWN]");
        }
        sb.append(" To: ");
        if (this.endPointer != null) {
            sb.append(this.endPointer.toString());
        } else {
            sb.append("[UNKNOWN]");
        }
        return sb.toString();
    }
}

