/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.spdxspreadsheet;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.SpdxDocumentContainer;
import org.spdx.rdfparser.model.ExternalRef;
import org.spdx.rdfparser.referencetype.ListedReferenceTypes;
import org.spdx.rdfparser.referencetype.ReferenceType;
import org.spdx.spdxspreadsheet.AbstractSheet;
import org.spdx.spdxspreadsheet.SpreadsheetException;

public class ExternalRefsSheet
extends AbstractSheet {
    static final Logger logger = LoggerFactory.getLogger(ExternalRefsSheet.class);
    static final int PKG_ID_COL = 0;
    static final int REF_CATEGORY_COL = 1;
    static final int REF_TYPE_COL = 2;
    static final int REF_LOCATOR_COL = 3;
    static final int COMMENT_COL = 4;
    static final int USER_DEFINED_COLS = 5;
    static final int NUM_COLS = 6;
    static final boolean[] REQUIRED = new boolean[]{true, true, true, true, false, false};
    static final String[] HEADER_TITLES = new String[]{"Package ID", "Category", "Type", "Locator", "Comment", "User Defined ..."};
    static final int[] COLUMN_WIDTHS = new int[]{25, 25, 40, 60, 40, 40};
    static final boolean[] LEFT_WRAP = new boolean[]{false, false, true, true, true, true};
    static final boolean[] CENTER_NOWRAP = new boolean[]{true, true, false, false, false, false};

    public ExternalRefsSheet(Workbook workbook, String sheetName) {
        super(workbook, sheetName);
    }

    @Override
    public String verify() {
        try {
            if (this.sheet == null) {
                return "Worksheet for External Refs does not exist";
            }
            Row firstRow = this.sheet.getRow(this.firstRowNum);
            for (int i = 0; i < 5; ++i) {
                Cell cell = firstRow.getCell(i + this.firstCellNum);
                if (cell != null && cell.getStringCellValue() != null && cell.getStringCellValue().equals(HEADER_TITLES[i])) continue;
                return "Column " + HEADER_TITLES[i] + " missing for External Refs worksheet";
            }
            boolean done = false;
            int rowNum = this.getFirstDataRow();
            while (!done) {
                Row row = this.sheet.getRow(rowNum);
                if (row == null || row.getCell(this.firstCellNum) == null) {
                    done = true;
                    continue;
                }
                String error = this.validateRow(row);
                if (error != null) {
                    return error;
                }
                ++rowNum;
            }
            return null;
        }
        catch (Exception ex) {
            return "Error in verifying External Refs work sheet: " + ex.getMessage();
        }
    }

    private String validateRow(Row row) {
        for (int i = 0; i < 6; ++i) {
            Cell cell = row.getCell(i);
            if (cell != null || !REQUIRED[i]) continue;
            return "Required cell " + HEADER_TITLES[i] + " missing for row " + String.valueOf(row.getRowNum());
        }
        return null;
    }

    public static void create(Workbook wb, String externalRefsSheetName) {
        int sheetNum = wb.getSheetIndex(externalRefsSheetName);
        if (sheetNum >= 0) {
            wb.removeSheetAt(sheetNum);
        }
        Sheet sheet = wb.createSheet(externalRefsSheetName);
        CellStyle headerStyle = AbstractSheet.createHeaderStyle(wb);
        CellStyle centerStyle = AbstractSheet.createCenterStyle(wb);
        CellStyle wrapStyle = AbstractSheet.createLeftWrapStyle(wb);
        Row row = sheet.createRow(0);
        for (int i = 0; i < HEADER_TITLES.length; ++i) {
            sheet.setColumnWidth(i, COLUMN_WIDTHS[i] * 256);
            if (LEFT_WRAP[i]) {
                sheet.setDefaultColumnStyle(i, wrapStyle);
            } else if (CENTER_NOWRAP[i]) {
                sheet.setDefaultColumnStyle(i, centerStyle);
            }
            Cell cell = row.createCell(i);
            cell.setCellStyle(headerStyle);
            cell.setCellValue(HEADER_TITLES[i]);
        }
    }

    public void add(String packageId, ExternalRef externalRef, SpdxDocumentContainer container2) throws SpreadsheetException {
        Row row = this.addRow();
        if (packageId != null) {
            row.createCell(0).setCellValue(packageId);
        }
        if (externalRef != null) {
            if (externalRef.getReferenceCategory() != null) {
                row.createCell(1).setCellValue(externalRef.getReferenceCategory().getTag());
            }
            try {
                if (externalRef.getReferenceType() != null) {
                    row.createCell(2).setCellValue(ExternalRefsSheet.refTypeToString(externalRef.getReferenceType(), container2));
                }
            }
            catch (InvalidSPDXAnalysisException e2) {
                throw new SpreadsheetException("Error getting external reference type: " + e2.getMessage());
            }
            if (externalRef.getReferenceLocator() != null) {
                row.createCell(3).setCellValue(externalRef.getReferenceLocator());
            }
            if (externalRef.getComment() != null) {
                row.createCell(4).setCellValue(externalRef.getComment());
            }
        }
    }

    protected static String refTypeToString(ReferenceType referenceType, SpdxDocumentContainer container2) {
        String retval;
        if (referenceType == null) {
            return "[No Reference Type]";
        }
        URI referenceTypeUri = referenceType.getReferenceTypeUri();
        if (referenceTypeUri == null) {
            return "[No Reference Type]";
        }
        try {
            retval = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceName(referenceTypeUri);
        }
        catch (InvalidSPDXAnalysisException e2) {
            retval = null;
        }
        if (retval == null && (retval = referenceTypeUri.toString()).startsWith(container2.getDocumentNamespace())) {
            retval = retval.substring(container2.getDocumentNamespace().length());
        }
        return retval;
    }

    public ExternalRef[] getExternalRefsForPkgid(String id, SpdxDocumentContainer container2) {
        if (id == null || this.sheet == null) {
            return new ExternalRef[0];
        }
        ArrayList<ExternalRef> retval = Lists.newArrayList();
        int i = this.getFirstDataRow();
        Row row = this.sheet.getRow(i++);
        while (row != null) {
            Cell pkgIdCell = row.getCell(0);
            if (pkgIdCell != null && id.equals(pkgIdCell.getStringCellValue())) {
                ExternalRef.ReferenceCategory refCategory = null;
                Cell refCategoryCell = row.getCell(1);
                if (refCategoryCell != null) {
                    refCategory = ExternalRef.ReferenceCategory.fromTag(refCategoryCell.getStringCellValue());
                }
                Cell refTypeCell = row.getCell(2);
                ReferenceType refType = null;
                if (refTypeCell != null) {
                    String refTypeStr = refTypeCell.getStringCellValue();
                    refType = ExternalRefsSheet.stringToRefType(refTypeStr, container2);
                }
                Cell refLocatorCell = row.getCell(3);
                String refLocator = null;
                if (refLocatorCell != null) {
                    refLocator = refLocatorCell.getStringCellValue();
                }
                Cell commentCell = row.getCell(4);
                String comment = null;
                if (commentCell != null) {
                    comment = commentCell.getStringCellValue();
                }
                retval.add(new ExternalRef(refCategory, refType, refLocator, comment));
            }
            row = this.sheet.getRow(i++);
        }
        return retval.toArray(new ExternalRef[retval.size()]);
    }

    protected static ReferenceType stringToRefType(String refTypeStr, SpdxDocumentContainer container2) {
        ReferenceType refType = null;
        if (refTypeStr != null) {
            refTypeStr = refTypeStr.trim();
            try {
                refType = ListedReferenceTypes.getListedReferenceTypes().getListedReferenceTypeByName(refTypeStr.trim());
            }
            catch (InvalidSPDXAnalysisException invalidSPDXAnalysisException) {
                // empty catch block
            }
            if (refType == null) {
                if (!refTypeStr.contains(":") && !refTypeStr.contains("/")) {
                    refTypeStr = container2.getDocumentNamespace() + refTypeStr;
                }
                try {
                    refType = new ReferenceType(new URI(refTypeStr), null, null, null);
                }
                catch (InvalidSPDXAnalysisException e2) {
                    logger.warn("SPDX Exception creating reference type", e2);
                }
                catch (URISyntaxException e3) {
                    logger.warn("Invalid URI for reference type: " + refTypeStr);
                }
            }
        }
        return refType;
    }
}

