/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.spdx.rdfparser.JavaSha1ChecksumGenerator;
import org.spdx.rdfparser.SpdxPackageVerificationCode;
import org.spdx.rdfparser.VerificationCodeGenerator;

public class GenerateVerificationCode {
    public static void main(String[] args) {
        File sourceDirectory;
        if (args.length < 1 || args.length > 2) {
            GenerateVerificationCode.error("Incorrect number of arguments.");
            System.exit(1);
        }
        if (!(sourceDirectory = new File(args[0])).exists()) {
            GenerateVerificationCode.error("Source directory " + args[0] + " does not exist.");
            System.exit(1);
        }
        if (!sourceDirectory.isDirectory()) {
            GenerateVerificationCode.error("File " + args[0] + " is not a directory.");
            System.exit(1);
        }
        String skippedRegex = null;
        File[] skippedFiles = new File[]{};
        if (args.length > 1) {
            skippedRegex = args[1];
            skippedFiles = GenerateVerificationCode.collectSkippedFiles(skippedRegex, sourceDirectory);
        }
        try {
            VerificationCodeGenerator vcg = new VerificationCodeGenerator(new JavaSha1ChecksumGenerator());
            SpdxPackageVerificationCode verificationCode = vcg.generatePackageVerificationCode(sourceDirectory, skippedFiles);
            GenerateVerificationCode.printVerificationCode(verificationCode);
            System.exit(0);
        }
        catch (Exception ex) {
            GenerateVerificationCode.error("Error creating verification code: " + ex.getMessage());
        }
    }

    private static File[] collectSkippedFiles(String skippedRegex, File dir) {
        Pattern skippedPattern = Pattern.compile(skippedRegex);
        ArrayList<File> skippedFiles = Lists.newArrayList();
        GenerateVerificationCode.collectSkippedFiles(skippedPattern, skippedFiles, dir.getPath(), dir);
        File[] retval = new File[skippedFiles.size()];
        retval = skippedFiles.toArray(retval);
        return retval;
    }

    private static void collectSkippedFiles(Pattern skippedPattern, List<File> skippedFiles, String rootPath, File dir) {
        File[] children;
        if (dir.isFile()) {
            String relativePath = dir.getPath().substring(rootPath.length() + 1);
            if (skippedPattern.matcher(relativePath).matches()) {
                skippedFiles.add(dir);
            }
        } else if (dir.isDirectory() && (children = dir.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                if (children[i].isFile()) {
                    String relativePath = children[i].getPath().substring(rootPath.length() + 1);
                    if (!skippedPattern.matcher(relativePath).matches()) continue;
                    skippedFiles.add(children[i]);
                    continue;
                }
                if (!children[i].isDirectory()) continue;
                GenerateVerificationCode.collectSkippedFiles(skippedPattern, skippedFiles, rootPath, children[i]);
            }
        }
    }

    private static void printVerificationCode(SpdxPackageVerificationCode verificationCode) {
        System.out.println("Verification code value: " + verificationCode.getValue());
        String[] excludedFiles = verificationCode.getExcludedFileNames();
        if (excludedFiles != null && excludedFiles.length > 0) {
            System.out.println("Excluded files:");
            for (int i = 0; i < excludedFiles.length; ++i) {
                System.out.println("\t" + excludedFiles[i]);
            }
        } else {
            System.out.println("No excluded files");
        }
    }

    private static void error(String string) {
        System.out.println(string);
        GenerateVerificationCode.usage();
    }

    private static void usage() {
        System.out.println("Usage: GenerateVerificationCode sourceDirectory");
        System.out.println("where sourceDirectory is the root of the archive file for which the verification code is generated");
    }
}

