/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.tools;

import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import org.spdx.rdfparser.SPDXDocumentFactory;
import org.spdx.rdfparser.model.SpdxDocument;
import org.spdx.tag.CommonCode;

public class SpdxViewer {
    static final int MIN_ARGS = 1;
    static final int MAX_ARGS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage:\n SPDXViewer file\nwhere file is the file path to a valid SPDX RDF XML file");
            return;
        }
        if (args.length > 1) {
            System.out.printf("Warning: Extra arguments will be ignored", new Object[0]);
        }
        SpdxDocument doc = null;
        try {
            doc = SPDXDocumentFactory.createSpdxDocument(args[0]);
        }
        catch (Exception ex) {
            System.out.print("Error creating SPDX Document: " + ex.getMessage());
            return;
        }
        try (PrintWriter writer = new PrintWriter(System.out);){
            List<String> verify = doc.verify();
            if (verify.size() > 0) {
                System.out.println("This SPDX Document is not valid due to:");
                for (int i = 0; i < verify.size(); ++i) {
                    System.out.print("\t" + verify.get(i) + "\n");
                }
            }
            Properties constants = CommonCode.getTextFromProperties("org/spdx/tag/SpdxViewerConstants.properties");
            CommonCode.printDoc(doc, writer, constants);
        }
    }
}

