/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.rdfparser.license;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.spdx.compare.LicenseCompareHelper;
import org.spdx.html.InvalidLicenseTemplateException;
import org.spdx.licenseTemplate.LicenseTemplateRuleException;
import org.spdx.licenseTemplate.SpdxLicenseTemplateHelper;
import org.spdx.rdfparser.IModelContainer;
import org.spdx.rdfparser.InvalidSPDXAnalysisException;
import org.spdx.rdfparser.RdfModelHelper;
import org.spdx.rdfparser.RdfParserHelper;
import org.spdx.rdfparser.license.DuplicateExtractedLicenseIdException;
import org.spdx.rdfparser.model.IRdfModel;

public class LicenseException
implements IRdfModel,
Cloneable {
    Model model = null;
    Node exceptionNode = null;
    Resource resource = null;
    private String licenseExceptionId;
    private String name;
    private String licenseExceptionText;
    private String[] seeAlso;
    private String comment;
    private String example;
    private String licenseExceptionTemplate;
    private String exceptionTextHtml = null;

    public LicenseException(IModelContainer modelContainer, Node node) throws InvalidSPDXAnalysisException {
        Triple t;
        Triple t2;
        this.model = modelContainer.getModel();
        this.exceptionNode = node;
        this.resource = RdfParserHelper.convertToResource(this.model, this.exceptionNode);
        Node p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionId").asNode();
        Triple m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        ExtendedIterator tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.licenseExceptionId = t2.getObject().toString(false);
        }
        this.name = null;
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "name").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.name = t2.getObject().toString(false);
        }
        this.licenseExceptionText = null;
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionText").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.licenseExceptionText = t2.getObject().toString(false);
        }
        this.licenseExceptionTemplate = null;
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionTemplate").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            t2 = (Triple)tripleIter.next();
            this.licenseExceptionTemplate = t2.getObject().toString(false);
        }
        ArrayList alsourceUrls = Lists.newArrayList();
        p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            alsourceUrls.add(t.getObject().toString(false));
        }
        this.seeAlso = alsourceUrls.toArray(new String[alsourceUrls.size()]);
        p = this.model.getProperty("http://www.w3.org/2000/01/rdf-schema#", "comment").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        if (!tripleIter.hasNext()) {
            p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseNotes").asNode();
            m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
            tripleIter = this.model.getGraph().find(m);
        }
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.comment = t.getObject().toString(false);
        } else {
            this.comment = null;
        }
        this.example = null;
        p = this.model.getProperty("http://spdx.org/rdf/terms#", "example").asNode();
        m = Triple.createMatch((Node)this.exceptionNode, (Node)p, null);
        tripleIter = this.model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            t = (Triple)tripleIter.next();
            this.example = t.getObject().toString(false);
        }
    }

    @Deprecated
    public LicenseException(String licenseExceptionId, String name, String licenseExceptionText, String[] seeAlso, String comment, String example) {
        this.licenseExceptionId = licenseExceptionId;
        this.name = name;
        this.licenseExceptionText = licenseExceptionText;
        this.seeAlso = seeAlso;
        this.comment = comment;
        this.example = example;
    }

    public LicenseException(String licenseExceptionId, String name, String licenseExceptionText, String[] seeAlso, String comment) {
        this(licenseExceptionId, name, licenseExceptionText, null, seeAlso, comment);
    }

    public LicenseException(String licenseExceptionId, String name, String licenseExceptionText, String licenseExceptionTemplate, String[] seeAlso, String comment, String exceptionTextHtml) {
        this.licenseExceptionId = licenseExceptionId;
        this.name = name;
        this.licenseExceptionText = licenseExceptionText;
        this.seeAlso = seeAlso;
        this.comment = comment;
        this.licenseExceptionTemplate = licenseExceptionTemplate;
        this.exceptionTextHtml = exceptionTextHtml;
    }

    public LicenseException(String licenseExceptionId, String name, String licenseExceptionText, String licenseExceptionTemplate, String[] seeAlso, String comment) {
        this(licenseExceptionId, name, licenseExceptionText, licenseExceptionTemplate, seeAlso, comment, null);
    }

    public LicenseException(String licenseExceptionId, String name, String licenseExceptionText) {
        this(licenseExceptionId, name, licenseExceptionText, new String[0], "", "");
    }

    public LicenseException() {
        this(null);
    }

    public LicenseException(String exceptionId) {
        this(exceptionId, null, null);
    }

    @Override
    public Resource createResource(IModelContainer modelContainer) throws InvalidSPDXAnalysisException {
        Property textProperty;
        String existingExceptionText;
        if (this.model != null && this.exceptionNode != null && this.resource != null && (this.model.equals((Object)modelContainer.getModel()) || this.exceptionNode.isURI())) {
            return this.resource;
        }
        this.model = modelContainer.getModel();
        this.exceptionNode = LicenseException.findException(this.model, this.licenseExceptionId);
        this.resource = null;
        if (this.exceptionNode != null) {
            if (this.exceptionNode.isURI()) {
                this.resource = this.model.createResource(this.exceptionNode.getURI());
            } else if (this.exceptionNode.isBlank()) {
                this.resource = this.model.createResource(new AnonId(this.exceptionNode.getBlankNodeId()));
            }
        } else {
            Resource type = this.model.createResource("http://spdx.org/rdf/terms#LicenseException");
            this.resource = this.model.createResource(type);
        }
        if (this.exceptionNode != null && (existingExceptionText = LicenseException.getExceptionTextFromModel(this.model, this.exceptionNode)) != null && this.licenseExceptionText != null && !LicenseCompareHelper.isLicenseTextEquivalent(existingExceptionText, this.licenseExceptionText)) {
            throw new DuplicateExtractedLicenseIdException("License exception ID " + this.licenseExceptionId + " already exists.  Can not add a license restriciton with the same ID but different text.");
        }
        if (this.licenseExceptionId != null) {
            Property idProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionId");
            this.model.removeAll(this.resource, idProperty, null);
            this.resource.addProperty(idProperty, this.licenseExceptionId);
        }
        if (this.name != null) {
            Property nameProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "name");
            this.model.removeAll(this.resource, nameProperty, null);
            this.resource.addProperty(nameProperty, this.name);
        }
        if (this.comment != null) {
            Property commentProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, commentProperty, null);
            this.resource.addProperty(commentProperty, this.comment);
        }
        if (this.example != null) {
            Property exampleProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "example");
            this.model.removeAll(this.resource, exampleProperty, null);
            this.resource.addProperty(exampleProperty, this.example);
        }
        if (this.seeAlso != null && this.seeAlso.length > 0) {
            Property seeAlsoProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            this.model.removeAll(this.resource, seeAlsoProperty, null);
            for (int i = 0; i < this.seeAlso.length; ++i) {
                this.resource.addProperty(seeAlsoProperty, this.seeAlso[i]);
            }
        }
        if (this.licenseExceptionText != null) {
            textProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionText");
            this.model.removeAll(this.resource, textProperty, null);
            this.resource.addProperty(textProperty, this.licenseExceptionText);
        }
        if (this.licenseExceptionTemplate != null) {
            textProperty = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionTemplate");
            this.model.removeAll(this.resource, textProperty, null);
            this.resource.addProperty(textProperty, this.licenseExceptionTemplate);
        }
        return this.resource;
    }

    public static String getExceptionTextFromModel(Model model, Node exceptionNode) {
        Node p = model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionText").asNode();
        Triple m = Triple.createMatch((Node)exceptionNode, (Node)p, null);
        ExtendedIterator tripleIter = model.getGraph().find(m);
        if (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            return t.getObject().toString(false);
        }
        return null;
    }

    public static Node findException(Model model, String id) {
        Property idProperty = model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionId");
        Property typeProperty = model.getProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "type");
        Property exceptionTypeProperty = model.getProperty("http://spdx.org/rdf/terms#", "LicenseException");
        Triple m = Triple.createMatch(null, (Node)idProperty.asNode(), null);
        ExtendedIterator tripleIter = model.getGraph().find(m);
        while (tripleIter.hasNext()) {
            Triple t = (Triple)tripleIter.next();
            if (!t.getObject().toString(false).equals(id)) continue;
            Triple typeMatch = Triple.createMatch((Node)t.getSubject(), (Node)typeProperty.asNode(), (Node)exceptionTypeProperty.asNode());
            ExtendedIterator typeTripleIter = model.getGraph().find(typeMatch);
            if (!typeTripleIter.hasNext()) continue;
            return t.getSubject();
        }
        return null;
    }

    public String getLicenseExceptionId() {
        return this.licenseExceptionId;
    }

    public void setLicenseExceptionId(String id) throws InvalidSPDXAnalysisException {
        Node duplicateNode;
        if (this.model != null && (duplicateNode = LicenseException.findException(this.model, this.licenseExceptionId)) != null && !duplicateNode.equals((Object)this.exceptionNode)) {
            throw new InvalidSPDXAnalysisException("Can not set the License Exception ID to " + id + ".  That ID is already in use.");
        }
        this.licenseExceptionId = id;
        if (this.exceptionNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionId");
            this.model.removeAll(this.resource, p, null);
            if (id != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionId");
                this.resource.addProperty(p, id);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.exceptionNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "name");
            this.model.removeAll(this.resource, p, null);
            if (name != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "name");
                this.resource.addProperty(p, name);
            }
        }
    }

    public String getLicenseExceptionText() {
        return this.licenseExceptionText;
    }

    public void setLicenseExceptionText(String text) {
        this.licenseExceptionText = text;
        if (this.exceptionNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionText");
            this.model.removeAll(this.resource, p, null);
            if (text != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionText");
                this.resource.addProperty(p, text);
            }
        }
    }

    public String getLicenseExceptionTemplate() {
        if (this.licenseExceptionTemplate == null) {
            return this.licenseExceptionText;
        }
        return this.licenseExceptionTemplate;
    }

    public void setLicenseExceptionTemplate(String template) {
        this.licenseExceptionTemplate = template;
        if (this.exceptionNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "licenseExceptionTemplate");
            this.model.removeAll(this.resource, p, null);
            if (template != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "licenseExceptionTemplate");
                this.resource.addProperty(p, template);
            }
        }
    }

    public String[] getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String[] url) {
        this.seeAlso = url;
        if (this.exceptionNode != null) {
            Property seeAlsoPropery = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "seeAlso");
            this.resource.removeAll(seeAlsoPropery);
            if (url != null) {
                for (int i = 0; i < url.length; ++i) {
                    this.resource.addProperty(seeAlsoPropery, url[i]);
                }
            }
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
        if (this.exceptionNode != null) {
            Property commentProperty = this.model.createProperty("http://www.w3.org/2000/01/rdf-schema#", "comment");
            this.model.removeAll(this.resource, commentProperty, null);
            if (comment != null) {
                this.resource.addProperty(commentProperty, comment);
            }
        }
    }

    @Deprecated
    public String getExample() {
        return this.example;
    }

    @Deprecated
    public void setExample(String example) {
        this.example = example;
        if (this.exceptionNode != null) {
            Property p = this.model.getProperty("http://spdx.org/rdf/terms#", "example");
            this.model.removeAll(this.resource, p, null);
            if (example != null) {
                p = this.model.createProperty("http://spdx.org/rdf/terms#", "example");
                this.resource.addProperty(p, example);
            }
        }
    }

    public LicenseException clone() {
        LicenseException retval = new LicenseException(this.getLicenseExceptionId(), this.getName(), this.getLicenseExceptionText(), this.getLicenseExceptionTemplate(), this.seeAlso, this.comment);
        retval.setExample(this.getExample());
        return retval;
    }

    public String toString() {
        return "WITH " + this.licenseExceptionId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof LicenseException)) {
            return false;
        }
        LicenseException le = (LicenseException)o;
        if (this.licenseExceptionId == null || le.licenseExceptionId == null) {
            return false;
        }
        return this.licenseExceptionId.equals(le.licenseExceptionId);
    }

    public int hashCode() {
        if (this.licenseExceptionId == null) {
            return 0;
        }
        return this.licenseExceptionId.hashCode();
    }

    @Override
    public List<String> verify() {
        ArrayList retval = Lists.newArrayList();
        if (this.getLicenseExceptionId() == null || this.getLicenseExceptionId().trim().isEmpty()) {
            retval.add("Missing required license exception ID");
        }
        if (this.getLicenseExceptionText() == null || this.getLicenseExceptionText().trim().isEmpty()) {
            retval.add("Missing required license exception text");
        }
        return retval;
    }

    @Override
    public boolean equivalent(IRdfModel compare) {
        if (compare == this) {
            return true;
        }
        if (!(compare instanceof LicenseException)) {
            return false;
        }
        LicenseException lCompare = (LicenseException)compare;
        return LicenseCompareHelper.isLicenseTextEquivalent(this.licenseExceptionText, lCompare.getLicenseExceptionText()) && Objects.equal((Object)this.comment, (Object)lCompare.getComment()) && Objects.equal((Object)this.example, (Object)lCompare.getExample()) && Objects.equal((Object)this.name, (Object)lCompare.getName()) && Objects.equal((Object)this.licenseExceptionTemplate, (Object)lCompare.getLicenseExceptionTemplate()) && RdfModelHelper.arraysEqual(this.seeAlso, lCompare.getSeeAlso());
    }

    @Override
    public void setMultipleObjectsForSameNode() {
    }

    @Override
    public void setSingleObjectForSameNode() {
    }

    public String getExceptionTextHtml() throws InvalidLicenseTemplateException {
        if (this.exceptionTextHtml == null) {
            String templateText = this.getLicenseExceptionTemplate();
            if (templateText != null && !templateText.trim().isEmpty()) {
                try {
                    this.exceptionTextHtml = SpdxLicenseTemplateHelper.templateTextToHtml(templateText);
                }
                catch (LicenseTemplateRuleException ex) {
                    throw new InvalidLicenseTemplateException("Invalid license rule found in exception text for exception " + this.getName() + ":" + ex.getMessage());
                }
            } else {
                this.exceptionTextHtml = SpdxLicenseTemplateHelper.formatEscapeHTML(this.getLicenseExceptionText());
            }
        }
        return this.exceptionTextHtml;
    }
}

